/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.admin.mbeans;

import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.sun.portal.admin.server.AdminServerUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

public class AMHelper {
    public static AMObject getAMObject(String dn) throws Exception {
        AMStoreConnection sc = new AMStoreConnection(AdminServerUtil.getSSOToken());
        int objectType = sc.getAMObjectType(dn);
        AMOrganization dpObj = null;
        switch (objectType) {
            case 2: {
                dpObj = sc.getOrganization(dn);
                break;
            }
            case 3: {
                dpObj = sc.getOrganizationalUnit(dn);
                break;
            }
            case 9: 
            case 10: {
                dpObj = sc.getStaticGroup(dn);
                break;
            }
            case 11: {
                dpObj = sc.getDynamicGroup(dn);
                break;
            }
            case 12: {
                dpObj = sc.getAssignableDynamicGroup(dn);
                break;
            }
            case 6: {
                dpObj = sc.getRole(dn);
                break;
            }
            case 8: {
                dpObj = sc.getFilteredRole(dn);
                break;
            }
            case 1: {
                dpObj = sc.getUser(dn);
                break;
            }
            case 5: {
                dpObj = sc.getPeopleContainer(dn);
                break;
            }
            case 4: {
                dpObj = sc.getGroupContainer(dn);
                break;
            }
        }
        return dpObj;
    }

    public static String getOrganizationDN(String dn) throws Exception {
        return AMHelper.getAMObject(dn).getOrganizationDN();
    }

    public static AMOrganization getOrganization(String dn) throws Exception {
        AMStoreConnection sc = new AMStoreConnection(AdminServerUtil.getSSOToken());
        return sc.getOrganization(AMHelper.getOrganizationDN(dn));
    }

    public static String getNamingAttribute(int objectType) {
        String namingAttribute = "";
        try {
            namingAttribute = AMStoreConnection.getNamingAttribute((int)objectType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return namingAttribute;
    }

    public static String DNToName(String roleDN) {
        String result = roleDN;
        if (DN.isDN((String)roleDN)) {
            String[] components = LDAPDN.explodeDN((String)roleDN, (boolean)true);
            result = components[0];
            String HD_NAME = "help_desk_" + AMHelper.getNamingAttribute(9) + "=";
            String suffix = "Admin";
            if (result.startsWith(HD_NAME)) {
                result = result.substring(HD_NAME.length());
                suffix = "Help Desk Admin";
                int end = result.indexOf("_");
                if (end == -1) {
                    end = result.length();
                }
                result = result.substring(0, end) + " " + suffix;
            } else {
                String grpNamingAttr = AMHelper.getNamingAttribute(9);
                String pcNamingAttr = AMHelper.getNamingAttribute(5);
                if (result.startsWith(grpNamingAttr + "=")) {
                    int start = 3;
                    int end = result.indexOf("_" + grpNamingAttr + "=");
                    if (end == -1 && (end = result.lastIndexOf("_" + AMHelper.getNamingAttribute(4))) == -1) {
                        end = result.length();
                    }
                    result = result.substring(start, end) + " " + suffix;
                } else if (result.startsWith(pcNamingAttr + "=")) {
                    int start = 3;
                    int end = (result = result.substring(start)).indexOf("_");
                    if (end == -1) {
                        end = result.length();
                    }
                    result = result.substring(0, end) + " " + suffix;
                }
            }
        }
        return result;
    }

    public static Map getAllRoles(String dn) throws Exception {
        Set roles = AMHelper.getOrganization(dn).getRoles(1);
        HashMap<String, String> result = new HashMap<String, String>(roles.size());
        Iterator i = roles.iterator();
        while (i.hasNext()) {
            String roleDN = (String)i.next();
            String roleDNDisplayString = AMHelper.DNToName(roleDN);
            if (roleDNDisplayString.startsWith("_WSRPRole_")) continue;
            result.put(roleDN, roleDNDisplayString);
        }
        return result;
    }
}

