/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.taskadmin;

import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.taskadmin.ChannelTaskAdmin;
import com.sun.portal.taskadmin.TaskAdminException;
import com.sun.portal.wsrp.WSRPException;
import com.sun.portal.wsrp.common.stubs.LocalizedString;
import com.sun.portal.wsrp.common.stubs.PortletDescription;
import com.sun.portal.wsrp.common.stubs.ServiceDescription;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntity;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManagerFactory;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class WSRPTaskAdmin
extends ChannelTaskAdmin {
    ProducerEntityManager pem = null;

    public WSRPTaskAdmin(HttpServletRequest req, String baseDN) throws TaskAdminException {
        super(req, baseDN);
        try {
            this.pem = ProducerEntityManagerFactory.getInstance().getProducerEntityManager(this.context.getOrganizationDN(baseDN), req);
        }
        catch (WSRPException e) {
            throw new TaskAdminException("WSRPTaskAdmin():Unable to intialize WSRPTaskAdmin", (Throwable)e);
        }
    }

    public void createWSRPChannel(String chname, String pid, String rid) throws TaskAdminException {
        this.createChannel(chname, "_WSRPProvider");
        DPChannel ch = this.dpRoot.getChannel(chname);
        ch.getProperties().setString("consumerID", this.context.getOrganizationDN(this.baseDN));
        ch.getProperties().setString("producerEntityID", pid);
        ch.getProperties().setString("portletID", rid);
        ch.getProperties().setString("portletHandle", rid);
    }

    public String getProducerName(String producerID) throws TaskAdminException {
        try {
            return this.pem.getProducerEntity(producerID).getName();
        }
        catch (WSRPException e) {
            Object[] tokens = new Object[]{this.baseDN, producerID, e.getMessage()};
            throw new TaskAdminException(27, tokens);
        }
    }

    public Set getExistingProducerIds() throws TaskAdminException {
        try {
            return this.pem.getProducerEntityIds();
        }
        catch (WSRPException e) {
            e.printStackTrace();
            Object[] tokens = new Object[]{this.baseDN, e.getMessage()};
            throw new TaskAdminException(25, tokens);
        }
    }

    public Set getPortletHandlers(String producerID) throws TaskAdminException {
        HashSet<String> portletHandlers = new HashSet<String>();
        try {
            ProducerEntity pe = this.pem.getProducerEntity(producerID);
            ServiceDescription sd = pe.getServiceDescription();
            PortletDescription[] portlets = sd.getOfferedPortlets();
            for (int i = 0; i < portlets.length; ++i) {
                String handle = portlets[i].getPortletHandle();
                portletHandlers.add(handle);
            }
        }
        catch (WSRPException e) {
            Object[] tokens = new Object[]{this.baseDN, e.getMessage()};
            throw new TaskAdminException(26, tokens);
        }
        return portletHandlers;
    }

    public String getPortletName(String producerID, String portletID) throws TaskAdminException {
        try {
            PortletDescription pd = this.pem.getProducerEntity(producerID).getPortletDescription(portletID);
            LocalizedString name = pd.getDisplayName();
            if (name != null && name.getValue() != null) {
                return name.getValue();
            }
            return pd.getPortletHandle();
        }
        catch (WSRPException e) {
            Object[] tokens = new Object[]{this.baseDN, producerID, portletID, e.getMessage()};
            throw new TaskAdminException(28, tokens);
        }
    }
}

