/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.server.mbeans;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.mbeans.PSMBean;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public abstract class PSResource
implements PSMBean {
    protected PSConfigContext cc = null;
    protected PortalDomainContext pdc = null;
    protected List path = null;
    protected String m_sPsID = null;
    protected String m_sPsDomainID = null;
    protected static final String fs = File.separator;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        if (cc == null) {
            throw new NullPointerException("cc is null.");
        }
        if (pdc == null) {
            throw new NullPointerException("pdc is null.");
        }
        if (path == null) {
            throw new NullPointerException("path is null.");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("path cannot be empty.");
        }
        this.cc = cc;
        this.pdc = pdc;
        this.path = path;
        this.m_sPsDomainID = pdc.getID();
        this.m_sPsID = (String)path.get(0);
    }

    public PSConfigContext getPSConfigContext() {
        return this.cc;
    }

    public PortalDomainContext getPortalDomainContext() {
        return this.pdc;
    }

    public String getDomainID() {
        return this.m_sPsDomainID;
    }

    public List getPath() {
        return this.path;
    }

    public String getID() {
        return this.m_sPsID;
    }

    public Map getMultipleAttributeValues(String type, Set names) throws PSMBeanException {
        try {
            return this.pdc.getMultipleAttributeValues(type, this.path, names);
        }
        catch (Exception e) {
            throw new PSMBeanException("admin.error.getMultipleAttributeValues", e.getMessage(), e);
        }
    }

    public void setMultipleAttributeValues(String type, Map attributes) throws PSMBeanException {
        try {
            this.pdc.setMultipleAttributeValues(type, this.path, attributes);
        }
        catch (Exception e) {
            throw new PSMBeanException("admin.error.setMultipleAttributeValues", e.getMessage(), e);
        }
    }

    public Set getAttributeValues(String type, String name) throws PSMBeanException {
        try {
            return this.pdc.getAttributeValues(type, this.path, name);
        }
        catch (Exception e) {
            throw new PSMBeanException("admin.error.getAttributeValues", e.getMessage(), e, new String[]{name});
        }
    }

    public void setAttributeValues(String type, String name, Set values) throws PSMBeanException {
        try {
            this.pdc.setAttributeValues(type, this.path, name, values);
        }
        catch (Exception e) {
            throw new PSMBeanException("admin.error.setAttributeValues", e.getMessage(), e, new String[]{name});
        }
    }

    public String getAttributeValue(String type, String name) throws PSMBeanException {
        try {
            return this.pdc.getAttributeValue(type, this.path, name);
        }
        catch (Exception e) {
            throw new PSMBeanException("admin.error.getAttributeValue", e.getMessage(), e, new String[]{name});
        }
    }

    public void setAttributeValue(String type, String name, String value) throws PSMBeanException {
        try {
            this.pdc.setAttributeValue(type, this.path, name, value);
        }
        catch (Exception e) {
            throw new PSMBeanException("admin.error.setAttributeValue", e.getMessage(), e, new String[]{name});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invokeRemoteOperation(String host, ObjectName mBeanName, String operationName, Object[] params, String[] signature) throws PSMBeanException {
        Object object;
        JMXConnector connector = null;
        try {
            try {
                connector = AdminServerUtil.getJMXConnector(host);
                MBeanServerConnection s = connector.getMBeanServerConnection();
                object = s.invoke(mBeanName, operationName, params, signature);
                Object var10_10 = null;
                if (connector == null) return object;
            }
            catch (Exception e) {
                throw new PSMBeanException("admin.error.invokeRemoteOperation", e.getMessage(), e, new Object[]{operationName, host});
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (connector == null) throw throwable;
            try {
                connector.close();
                throw throwable;
            }
            catch (Exception e2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return object;
        }
        connector.close();
        return object;
    }

    protected boolean isResourceAvailable(String type, String id) throws PSMBeanException {
        try {
            ArrayList resources = new ArrayList(this.pdc.getResourceIDs(type, this.path));
            return resources.contains(id);
        }
        catch (Exception e) {
            String message = "Error reading resources in domain " + this.pdc.getID();
            throw new PSMBeanException("admin.error.get.resources", e.getMessage(), e, new Object[]{this.pdc.getID()});
        }
    }

    public String getStackTrace(Throwable t) {
        StringBuffer strace = new StringBuffer();
        StackTraceElement[] ste = t.getStackTrace();
        strace.append(t.getMessage());
        strace.append('\n');
        for (int i = 0; i < ste.length; ++i) {
            strace.append(ste[i].toString());
            strace.append('\n');
        }
        return strace.toString();
    }
}

