/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.server;

import com.iplanet.am.util.SystemProperties;
import com.sun.cacao.DeploymentDescriptor;
import com.sun.cacao.Module;
import com.sun.cacao.agent.DispatchInterceptor;
import com.sun.cacao.agent.DomainDispatcher;
import com.sun.cacao.agent.auth.AccessControlDispatcher;
import com.sun.cacao.agent.auth.CacaoCallbackHandler;
import com.sun.cacao.container.Container;
import com.sun.jdmk.JdmkMBeanServer;
import com.sun.portal.admin.common.PSConfigConstants;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PSConfigContextImpl;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.context.PortalDomainContextFactory;
import com.sun.portal.admin.common.jaxb.PortalResource;
import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.PASAccessController;
import com.sun.portal.admin.server.PASLogger;
import com.sun.portal.admin.server.PASMechanism;
import com.sun.portal.admin.server.PASModuleMBean;
import com.sun.portal.admin.server.PortalDomainDispatcher;
import com.sun.portal.admin.server.mbeans.PSResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class PASModule
extends Module
implements PASModuleMBean,
PSConfigConstants {
    private static Logger logger = PASLogger.getLogger();
    public static final String FS = File.separator;
    public static final String[] SIGNATURE = new String[]{(class$java$lang$String == null ? (class$java$lang$String = PASModule.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$String == null ? (class$java$lang$String = PASModule.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$util$List == null ? (class$java$util$List = PASModule.class$("java.util.List")) : class$java$util$List).getName()};
    public static ObjectName myObjectName = null;
    protected Unmarshaller unmarshaller = null;
    protected List portalResources = null;
    protected Map classNamesCache = new HashMap();
    protected Map configContexts = new HashMap();
    protected String mechanismName;
    protected Map childrenCache = new HashMap();
    private DomainDispatcher portalDomainDispatcher = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$com$sun$portal$admin$server$PASPrincipal;

    public PASModule(DeploymentDescriptor descriptor) {
        super(descriptor);
        myObjectName = this.getObjectName();
        logger.log(Level.FINEST, "PSAD_CSPAS0201", myObjectName);
    }

    public void reloadMBeans(String domainID, String type, List parentPath) {
        PSConfigContext cc = (PSConfigContext)this.configContexts.get(domainID);
        PortalDomainContext pdc = null;
        try {
            pdc = PortalDomainContextFactory.getPortalDomainContext(domainID);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "PSAD_CSPAS0202", domainID);
            logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
            return;
        }
        this.unregisterResourceMBeans(domainID, type, parentPath);
        this.registerResourceMBeans(cc, pdc, type, parentPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void reloadMBeans(PortalDomainContext pdc, String type, List parentPath) {
        String domainID = pdc.getID();
        Set hosts = null;
        try {
            hosts = pdc.getAttributeValues("PortalDomain", Collections.singletonList(domainID), "Host");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "PSAD_CSPAS0203", domainID);
            logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
            return;
        }
        Iterator i = hosts.iterator();
        while (i.hasNext()) {
            String host = (String)i.next();
            JMXConnector connector = null;
            connector = AdminServerUtil.getJMXConnector(host);
            MBeanServerConnection s = connector.getMBeanServerConnection();
            Object[] params = new Object[]{domainID, type, parentPath};
            s.invoke(myObjectName, "reloadMBeans", params, SIGNATURE);
            Object var11_12 = null;
            if (connector == null) continue;
            try {
                connector.close();
            }
            catch (Exception e2) {
                logger.log(Level.WARNING, "PSAD_CSPAS0205", host);
                logger.log(Level.WARNING, "PSAD_CSPAS0000", e2);
            }
            continue;
            {
                catch (Exception e) {
                    logger.log(Level.WARNING, "PSAD_CSPAS0204", host);
                    logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
                    var11_12 = null;
                    if (connector == null) continue;
                    try {
                        connector.close();
                    }
                    catch (Exception e2) {
                        logger.log(Level.WARNING, "PSAD_CSPAS0205", host);
                        logger.log(Level.WARNING, "PSAD_CSPAS0000", e2);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var11_12 = null;
                if (connector != null) {
                    try {
                        connector.close();
                    }
                    catch (Exception e2) {
                        logger.log(Level.WARNING, "PSAD_CSPAS0205", host);
                        logger.log(Level.WARNING, "PSAD_CSPAS0000", e2);
                    }
                }
                throw throwable;
            }
        }
    }

    public static MBeanServer getMBeanServer() {
        return Container.getMbs();
    }

    protected void start() {
        Properties parameters;
        String psconfigDir;
        String message = null;
        try {
            DispatchInterceptor dispatcher = (DispatchInterceptor)((JdmkMBeanServer)PASModule.getMBeanServer()).getMBeanServerInterceptor();
            this.portalDomainDispatcher = new PortalDomainDispatcher(PASModule.getMBeanServer());
            dispatcher.addDomainDispatcher(this.portalDomainDispatcher);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "PSAD_CSPAS0206", e);
        }
        if (this.unmarshaller == null) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.sun.portal.admin.common.jaxb");
                this.unmarshaller = jaxbContext.createUnmarshaller();
            }
            catch (JAXBException e) {
                message = "Error creating a JAXB unmarshaller.";
                logger.log(Level.SEVERE, "PSAD_CSPAS0207", e);
                throw new RuntimeException(message);
            }
        }
        if ((psconfigDir = (parameters = this.getDeploymentDescriptor().getParameters()).getProperty("ps.config.location")) == null) {
            message = "ps.config.location is missing in module.xml file.";
            logger.log(Level.SEVERE, "PSAD_CSPAS0208", "ps.config.location");
            throw new RuntimeException(message);
        }
        File[] files = this.getFilesInDirectory(psconfigDir + FS + "domains");
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            String domainID = files[i].getName();
            logger.log(Level.FINEST, "PSAD_CSPAS0209", domainID);
            try {
                File domainConfigFile;
                PSConfigContextImpl cc = new PSConfigContextImpl(domainID);
                if (this.portalResources == null) {
                    this.loadPortalResources(cc.getPSBaseDir());
                }
                if (!(domainConfigFile = new File(files[i], "PortalDomainConfig.properties")).isFile() || !domainConfigFile.canRead()) {
                    logger.log(Level.WARNING, "PSAD_CSPAS0210", domainConfigFile);
                    continue;
                }
                PortalDomainContextFactory.loadPortalDomainContext(domainID, cc, this.portalResources, logger);
                this.configContexts.put(domainID, cc);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "PSAD_CSPAS0211", domainID);
                logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
            }
        }
        LinkedList<PASAccessController> l = new LinkedList<PASAccessController>();
        PASAccessController pasAccessController = new PASAccessController();
        l.add(pasAccessController);
        AccessControlDispatcher.getPrincipalMap().put(class$com$sun$portal$admin$server$PASPrincipal == null ? (class$com$sun$portal$admin$server$PASPrincipal = PASModule.class$("com.sun.portal.admin.server.PASPrincipal")) : class$com$sun$portal$admin$server$PASPrincipal, l);
        PASMechanism pasMechanism = new PASMechanism();
        this.mechanismName = pasMechanism.getName();
        CacaoCallbackHandler.getMechanisms().put(this.mechanismName, pasMechanism);
        this.addNotificationListener(pasMechanism);
        this.registerPSMBeans();
    }

    protected void stop() {
        this.unregisterPSMBeans();
        PASMechanism pasMechanism = (PASMechanism)CacaoCallbackHandler.getMechanisms().get(this.mechanismName);
        this.removeNotificationListener(pasMechanism);
        CacaoCallbackHandler.getMechanisms().remove(this.mechanismName);
        this.mechanismName = null;
        AccessControlDispatcher.getPrincipalMap().remove(class$com$sun$portal$admin$server$PASPrincipal == null ? (class$com$sun$portal$admin$server$PASPrincipal = PASModule.class$("com.sun.portal.admin.server.PASPrincipal")) : class$com$sun$portal$admin$server$PASPrincipal);
        this.childrenCache.clear();
        this.configContexts.clear();
        PortalDomainContextFactory.unloadAllPortalDomainContexts();
        this.classNamesCache.clear();
        this.portalResources = null;
        DispatchInterceptor dispatcher = (DispatchInterceptor)((JdmkMBeanServer)PASModule.getMBeanServer()).getMBeanServerInterceptor();
        dispatcher.removeDomainDispatcher(this.portalDomainDispatcher);
    }

    protected File[] getFilesInDirectory(String directory) {
        String message = null;
        logger.log(Level.FINEST, "PSAD_CSPAS0212", directory);
        File dir = new File(directory);
        try {
            if (!dir.exists()) {
                message = directory + " doesn't exist.";
                logger.log(Level.SEVERE, "PSAD_CSPAS0213", directory);
                throw new RuntimeException(message);
            }
            if (!dir.isDirectory()) {
                message = directory + " isn't a directory.";
                logger.log(Level.SEVERE, "PSAD_CSPAS0214", directory);
                throw new RuntimeException(message);
            }
            if (!dir.canRead()) {
                message = "Cannot read the directory " + directory;
                logger.log(Level.SEVERE, "PSAD_CSPAS0215", directory);
                throw new RuntimeException(message);
            }
            File[] files = dir.listFiles();
            if (files == null) {
                message = directory + " isn't a directory.";
                logger.log(Level.SEVERE, "PSAD_CSPAS0214", directory);
                throw new RuntimeException(message);
            }
            return files;
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, "PSAD_CSPAS0215", directory);
            logger.log(Level.SEVERE, "PSAD_CSPAS0000", e);
            throw e;
        }
    }

    protected void loadPortalResources(String psBaseDir) {
        this.portalResources = new LinkedList();
        this.classNamesCache = new HashMap();
        String mbeansDir = psBaseDir + FS + "admin" + FS + "mbeans";
        File[] files = this.getFilesInDirectory(mbeansDir);
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i].getName();
            if (!fileName.endsWith("xml")) continue;
            logger.log(Level.FINEST, "PSAD_CSPAS0216", fileName);
            try {
                FileInputStream fis = new FileInputStream(files[i]);
                PortalResource r = (PortalResource)this.unmarshaller.unmarshal((InputStream)fis);
                String type = r.getType();
                logger.log(Level.FINEST, "PSAD_CSPAS0217", type);
                this.portalResources.add(r);
                this.classNamesCache.put(type, r.getClassName());
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "PSAD_CSPAS0218", fileName);
                logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
            }
        }
    }

    protected void registerPSMBeans() {
        Set domainIDs = PortalDomainContextFactory.getAllPortalDomainIDs();
        Iterator i = domainIDs.iterator();
        while (i.hasNext()) {
            String domainID = (String)i.next();
            logger.log(Level.FINEST, "PSAD_CSPAS0219", domainID);
            PSConfigContext cc = (PSConfigContext)this.configContexts.get(domainID);
            PortalDomainContext pdc = PortalDomainContextFactory.getPortalDomainContext(domainID);
            for (int j = 0; j < this.portalResources.size(); ++j) {
                PortalResource r = (PortalResource)this.portalResources.get(j);
                String type = r.getType();
                if (AdminUtil.getParentType(type) != null) continue;
                this.registerResourceMBeans(cc, pdc, type, Collections.EMPTY_LIST);
            }
            this.registerPASInstanceToDomain(pdc);
        }
    }

    protected void unregisterPSMBeans() {
        Set domainIDs = PortalDomainContextFactory.getAllPortalDomainIDs();
        Iterator i = domainIDs.iterator();
        while (i.hasNext()) {
            String domainID = (String)i.next();
            this.unregisterPASInstanceFromDomain(domainID);
            for (int j = 0; j < this.portalResources.size(); ++j) {
                PortalResource r = (PortalResource)this.portalResources.get(j);
                String type = r.getType();
                if (AdminUtil.getParentType(type) != null) continue;
                this.unregisterResourceMBeans(domainID, type, Collections.EMPTY_LIST);
            }
        }
    }

    protected void registerResourceMBeans(PSConfigContext cc, PortalDomainContext pdc, String type, List parentPath) {
        String className = (String)this.classNamesCache.get(type);
        if (className == null) {
            logger.log(Level.WARNING, "PSAD_CSPAS0220", type);
            return;
        }
        Set resourceIDs = null;
        try {
            resourceIDs = pdc.getResourceIDs(type, parentPath);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "PSAD_CSPAS0221", type);
            logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
            return;
        }
        Iterator i = resourceIDs.iterator();
        while (i.hasNext()) {
            String resourceID = (String)i.next();
            if (type.equals("PortalDomain") && !resourceID.equalsIgnoreCase(pdc.getID())) continue;
            List path = AdminUtil.getChildPath(parentPath, resourceID);
            try {
                PSResource resource = (PSResource)Class.forName(className).newInstance();
                resource.init(cc, pdc, Collections.unmodifiableList(path));
                ObjectName objectName = AdminUtil.getResourceMBeanObjectName(type, path);
                this.getMbs().registerMBean(resource, objectName);
                logger.log(Level.FINEST, "PSAD_CSPAS0222", objectName);
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "PSAD_CSPAS0223", type);
                logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
                continue;
            }
            Set children = this.getChildren(type);
            Iterator j = children.iterator();
            while (j.hasNext()) {
                this.registerResourceMBeans(cc, pdc, (String)j.next(), path);
            }
        }
    }

    protected void unregisterResourceMBeans(String domainID, String type, List parentPath) {
        ObjectName pattern = null;
        try {
            pattern = AdminUtil.getResourcesPattern(type, parentPath);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "PSAD_CSPAS0224", type);
            logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
            return;
        }
        Set<ObjectName> objectNames = this.getMbs().queryNames(pattern, null);
        Iterator<ObjectName> i = objectNames.iterator();
        while (i.hasNext()) {
            ObjectName objectName = i.next();
            String resourceID = objectName.getKeyProperty("name");
            if (type.equals("PortalDomain") && !resourceID.equalsIgnoreCase(domainID)) continue;
            List path = AdminUtil.getChildPath(parentPath, resourceID);
            Set children = this.getChildren(type);
            Iterator j = children.iterator();
            while (j.hasNext()) {
                this.unregisterResourceMBeans(domainID, (String)j.next(), path);
            }
            try {
                this.getMbs().unregisterMBean(objectName);
                logger.log(Level.FINEST, "PSAD_CSPAS0225", objectName);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "PSAD_CSPAS0226", objectName);
                logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
            }
        }
    }

    protected Set getChildren(String type) {
        TreeSet<String> children = (TreeSet<String>)this.childrenCache.get(type);
        if (children == null) {
            children = new TreeSet<String>();
            for (int i = 0; i < this.portalResources.size(); ++i) {
                PortalResource r = (PortalResource)this.portalResources.get(i);
                String t = r.getType();
                if (!type.equals(AdminUtil.getParentType(t))) continue;
                children.add(t);
            }
            this.childrenCache.put(type, children);
        }
        return children;
    }

    protected void registerPASInstanceToDomain(PortalDomainContext pdc) {
        String domainID = pdc.getID();
        List<String> path = Collections.singletonList(domainID);
        try {
            TreeSet<String> hosts = new TreeSet<String>(pdc.getAttributeValues("PortalDomain", path, "Host"));
            hosts.add(InetAddress.getLocalHost().getHostName());
            pdc.setAttributeValues("PortalDomain", path, "Host", hosts);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "PSAD_CSPAS0227", domainID);
            logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
        }
    }

    protected void unregisterPASInstanceFromDomain(String domainID) {
        List<String> path = Collections.singletonList(domainID);
        try {
            PortalDomainContext pdc = PortalDomainContextFactory.getPortalDomainContext(domainID);
            TreeSet hosts = new TreeSet(pdc.getAttributeValues("PortalDomain", path, "Host"));
            hosts.remove(InetAddress.getLocalHost().getHostName());
            pdc.setAttributeValues("PortalDomain", path, "Host", hosts);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "PSAD_CSPAS0228", domainID);
            logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
        }
    }

    protected Set getJMXConnectorServers() {
        ObjectName connectorServers = null;
        try {
            connectorServers = new ObjectName("*:type=javax.management.remote.JMXConnectorServerMBean,*");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getMbs().queryNames(connectorServers, null);
    }

    protected void addNotificationListener(PASMechanism pasMechanism) {
        Set connectorServers = this.getJMXConnectorServers();
        Iterator i = connectorServers.iterator();
        while (i.hasNext()) {
            ObjectName connectorServer = (ObjectName)i.next();
            try {
                this.getMbs().addNotificationListener(connectorServer, pasMechanism, (NotificationFilter)pasMechanism, null);
                logger.log(Level.FINEST, "PSAD_CSPAS0229", connectorServer);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "PSAD_CSPAS0230", connectorServer);
                logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
            }
        }
    }

    protected void removeNotificationListener(PASMechanism pasMechanism) {
        Set connectorServers = this.getJMXConnectorServers();
        Iterator i = connectorServers.iterator();
        while (i.hasNext()) {
            ObjectName connectorServer = (ObjectName)i.next();
            try {
                this.getMbs().removeNotificationListener(connectorServer, pasMechanism);
                logger.log(Level.FINEST, "PSAD_CSPAS0231", connectorServer);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "PSAD_CSPAS0232", connectorServer);
                logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Properties properties = new Properties();
        properties.setProperty("com.iplanet.security.SecureRandomFactoryImpl", "com.iplanet.am.util.SecureRandomFactoryImpl");
        properties.setProperty("com.iplanet.security.SSLSocketFactoryImpl", "netscape.ldap.factory.JSSESocketFactory");
        properties.setProperty("com.iplanet.security.encryptor", "com.iplanet.services.util.JCEEncryption");
        properties.setProperty("com.iplanet.am.session.client.polling.enable", Boolean.TRUE.toString());
        SystemProperties.initializeProperties((Properties)properties);
    }
}

