/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.server;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.cacao.agent.auth.CallbackInfo;
import com.sun.cacao.agent.auth.Credential;
import com.sun.cacao.agent.auth.Mechanism;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.context.PortalDomainContextFactory;
import com.sun.portal.admin.server.PASLogger;
import com.sun.portal.admin.server.PASPrincipal;
import java.security.Principal;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import netscape.ldap.util.DN;

public class PASMechanism
implements Mechanism,
NotificationFilter,
NotificationListener {
    private static Logger logger = PASLogger.getLogger();

    public String getName() {
        return "com.sun.portal";
    }

    public boolean isIdentityAsserted() {
        return false;
    }

    public CallbackInfo parse(String authenticationID, String password, String[] authPieces, String[] passwdPieces) throws SecurityException {
        DN userDN;
        String message = null;
        String userName = authPieces[1];
        String domainID = authPieces[2];
        String uid = userName;
        PortalDomainContext pdc = null;
        String orgDN = null;
        try {
            pdc = PortalDomainContextFactory.getPortalDomainContext(domainID);
        }
        catch (Exception e) {
            message = "Authentication failed: " + e.getMessage();
            logger.log(Level.WARNING, "PSAD_CSPAS0101", e.getMessage());
            logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
            throw new SecurityException(message);
        }
        if (DN.isDN((String)userName)) {
            userDN = new DN(userName);
            String[] components = userDN.explodeDN(true);
            if (components.length < 3) {
                message = "Authentication failed due to incorrect user DN format: " + userName;
                logger.log(Level.WARNING, "PSAD_CSPAS0102", userName);
                throw new SecurityException(message);
            }
            uid = components[0];
            orgDN = userDN.getParent().getParent().toString();
        } else {
            orgDN = pdc.getDefaultOrg();
            userName = "uid=" + uid + ",ou=People," + orgDN;
        }
        userDN = new DN(userName);
        DN superUserDN = new DN(pdc.getSuperUser());
        if (!userDN.equals(superUserDN)) {
            message = "Authentication failed: " + userName + " is not a super user";
            logger.log(Level.WARNING, "PSAD_CSPAS0103", userName);
            throw new SecurityException(message);
        }
        AuthContext authContext = null;
        try {
            authContext = new AuthContext(orgDN);
            authContext.login(AuthContext.IndexType.MODULE_INSTANCE, "LDAP");
        }
        catch (AuthLoginException e) {
            message = "Authentication failed: " + e.getMessage();
            logger.log(Level.WARNING, "PSAD_CSPAS0101", e.getMessage());
            logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
            throw new SecurityException(message);
        }
        while (authContext.hasMoreRequirements()) {
            Callback[] callbacks = authContext.getRequirements();
            if (callbacks == null) continue;
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)callbacks[i];
                    ncb.setName(uid);
                    continue;
                }
                if (!(callbacks[i] instanceof PasswordCallback)) continue;
                PasswordCallback pcb = (PasswordCallback)callbacks[i];
                pcb.setPassword(passwdPieces[0].toCharArray());
            }
            authContext.submitRequirements(callbacks);
        }
        AuthContext.Status loginStatus = authContext.getStatus();
        if (loginStatus == AuthContext.Status.SUCCESS) {
            Subject subject = authContext.getSubject();
            PASPrincipal pasPrincipal = new PASPrincipal(userName, domainID);
            try {
                pasPrincipal.setSSOToken(authContext.getSSOToken());
            }
            catch (Exception e) {
                message = "Authentication failed: " + e.getMessage();
                logger.log(Level.WARNING, "PSAD_CSPAS0101", e.getMessage());
                logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
                throw new SecurityException(message);
            }
            subject.getPrincipals().add((Principal)((Object)pasPrincipal));
            logger.log(Level.FINER, "PSAD_CSPAS0104", subject);
            subject.getPublicCredentials().add(new Credential(authenticationID));
            subject.getPrivateCredentials().add(new Credential(password));
            return new CallbackInfo(subject, false);
        }
        AuthLoginException e = authContext.getLoginException();
        message = "Authentication failed: " + e.getMessage();
        logger.log(Level.WARNING, "PSAD_CSPAS0101", e.getMessage());
        logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
        throw new SecurityException(message);
    }

    public boolean isNotificationEnabled(Notification notification) {
        return notification instanceof JMXConnectionNotification;
    }

    public void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        if ("jmx.remote.connection.closed".equals(type) || "jmx.remote.connection.failed".equals(type)) {
            logger.log(Level.FINER, "PSAD_CSPAS0105", type);
            JMXConnectionNotification connectionNotification = (JMXConnectionNotification)notification;
            String connectionID = connectionNotification.getConnectionId();
            logger.log(Level.FINER, "PSAD_CSPAS0106", connectionID);
            StringTokenizer st = new StringTokenizer(connectionID, " ");
            if (st.countTokens() > 2) {
                String protocol = st.nextToken();
                StringTokenizer principals = new StringTokenizer(st.nextToken(), ";");
                while (principals.hasMoreTokens()) {
                    String principal = principals.nextToken();
                    if (principal.equals("root") || principal.startsWith("com") || DN.isDN((String)principal)) continue;
                    try {
                        SSOTokenManager manager = SSOTokenManager.getInstance();
                        SSOToken token = manager.createSSOToken(principal);
                        manager.destroyToken(token);
                        logger.log(Level.FINER, "PSAD_CSPAS0107", principal);
                    }
                    catch (Exception e) {}
                }
            }
        }
    }
}

