/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.server;

import com.sun.cacao.agent.auth.AccessControlActionEnum;
import com.sun.cacao.agent.auth.AccessController;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.context.PortalDomainContextFactory;
import com.sun.portal.admin.server.PASLogger;
import com.sun.portal.admin.server.PASModule;
import com.sun.portal.admin.server.PASPrincipal;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import netscape.ldap.util.DN;

public class PASAccessController
implements AccessController {
    private static Logger logger = PASLogger.getLogger();

    public boolean checkMBeanPermission(Principal principal, ClassLoader classloader, String classname, String member, ObjectName objectName, AccessControlActionEnum action) throws SecurityException {
        if (!(principal instanceof PASPrincipal)) {
            return false;
        }
        if (objectName == null) {
            return false;
        }
        if (!objectName.getDomain().equals("com.sun.portal") && !objectName.equals(PASModule.myObjectName)) {
            return false;
        }
        PASPrincipal pasPrincipal = (PASPrincipal)((Object)principal);
        String userName = pasPrincipal.getName();
        String domainID = pasPrincipal.getPortalDomainID();
        PortalDomainContext pdc = null;
        String message = null;
        try {
            pdc = PortalDomainContextFactory.getPortalDomainContext(domainID);
        }
        catch (Exception e) {
            message = "Access denied: " + e.getMessage();
            logger.log(Level.WARNING, "PSAD_CSPAS0001", e.getMessage());
            logger.log(Level.WARNING, "PSAD_CSPAS0000", e);
            throw new SecurityException(message);
        }
        DN userDN = new DN(userName);
        DN superUserDN = new DN(pdc.getSuperUser());
        if (userDN.equals(superUserDN)) {
            return true;
        }
        message = "Access denied: " + userName + " is not a super user";
        logger.log(Level.WARNING, "PSAD_CSPAS0002", userName);
        throw new SecurityException(message);
    }
}

