/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.common.util;

import com.sun.portal.admin.common.util.AdminClientUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class AdminUtil {
    public static final String JMX_DOMAIN = "com.sun.portal";
    public static final String DEFAULT_DOMAIN = "defaultDomain";
    public static final String DEFAULT_PORTAL = "defaultPortal";
    public static final String UPGRADED_PORTAL = "Upgraded";
    public static final String DEFAULT_INSTANCE = "defaultInstance";
    public static final String KEY_TYPE = "type";
    public static final String KEY_ID = "name";
    public static final String PORTAL_DOMAIN_MBEAN = "PortalDomain";
    public static final String AMOBJECTSEARCH_MBEAN = "AMObjectSearch";
    public static final String SSOADAPTER_MBEAN = "SSOAdapter";
    public static final String SCHEDULER_MBEAN = "Scheduler";
    public static final String PORTAL_MBEAN = "Portal";
    public static final String DESKTOP_DYNAMIC_MBEAN = "DesktopDynamic";
    public static final String PORTAL_SERVER_INSTANCE_MBEAN = "ServerInstance";
    public static final String DISPLAYPROFILE_MBEAN = "DisplayProfile";
    public static final String DPADMINWRAPPER_MBEAN = "DPAdminWrapper";
    public static final String MONITORING_MBEAN = "Monitoring";
    public static final String PORTLET_ADMIN_MBEAN = "PortletAdmin";
    public static final String SRA_MBEAN = "SRA";
    public static final String REWRITER_MBEAN = "Rewriter";
    public static final String SRA_MONITORING_MBEAN = "SRAMonitoring";
    public static final String SEARCHSERVER_MBEAN = "SearchServer";
    public static final String SEARCH_DATABASE_MBEAN = "Database";
    public static final String SEARCH_ROBOT_MBEAN = "Robot";
    public static final String SEARCH_SITEPROBE_MBEAN = "SiteProbe";
    public static final String SEARCH_AUTOCLASSIFY_MBEAN = "Autoclassify";
    public static final String SEARCH_CATEGORY_MBEAN = "Category";
    public static final String PROFILER_MBEAN = "Profiler";
    public static final String FILE_UPLOAD_DOWNLOAD_MANAGER = "UploadDownloadFileManager";
    public static final String PORTAL_DOMAIN_MBEAN_TYPE = "PortalDomain";
    public static final String SEARCHSERVER_MBEAN_TYPE = "PortalDomain.SearchServer";
    public static final String FILE_UPLOAD_DOWNLOAD_MANAGER_MBEAN_TYPE = "PortalDomain.UploadDownloadFileManager";
    public static final String AMOBJECTSEARCH_MBEAN_TYPE = "PortalDomain.AMObjectSearch";
    public static final String SSOADAPTER_MBEAN_TYPE = "PortalDomain.SSOAdapter";
    public static final String SCHEDULER_MBEAN_TYPE = "PortalDomain.Scheduler";
    public static final String PORTAL_MBEAN_TYPE = "PortalDomain.Portal";
    public static final String PORTAL_SERVER_INSTANCE_MBEAN_TYPE = "PortalDomain.Portal.ServerInstance";
    public static final String DESKTOP_DYNAMIC_MBEAN_TYPE = "PortalDomain.Portal.DesktopDynamic";
    public static final String DISPLAYPROFILE_MBEAN_TYPE = "PortalDomain.Portal.DisplayProfile";
    public static final String DPADMINWRAPPER_MBEAN_TYPE = "PortalDomain.Portal.DPAdminWrapper";
    public static final String PORTLET_ADMIN_MBEAN_TYPE = "PortalDomain.Portal.PortletAdmin";
    public static final String MONITORING_MBEAN_TYPE = "PortalDomain.Portal.ServerInstance.Monitoring";
    public static final String SRA_MBEAN_TYPE = "PortalDomain.SRA";
    public static final String REWRITER_MBEAN_TYPE = "PortalDomain.Rewriter";
    public static final String SRA_MONITORING_MBEAN_TYPE = "PortalDomain.SRAMonitoring";
    public static final String SEARCH_DATABASE_MBEAN_TYPE = "PortalDomain.SearchServer.Database";
    public static final String SEARCH_ROBOT_MBEAN_TYPE = "PortalDomain.SearchServer.Robot";
    public static final String SEARCH_SITEPROBE_MBEAN_TYPE = "PortalDomain.SearchServer.SiteProbe";
    public static final String SEARCH_AUTOCLASSIFY_MBEAN_TYPE = "PortalDomain.SearchServer.Autoclassify";
    public static final String SEARCH_CATEGORY_MBEAN_TYPE = "PortalDomain.SearchServer.Category";
    public static final String PROFILER_MBEAN_TYPE = "PortalDomain.Portal.Profiler";
    public static final int DEFAULT_UPLOAD_SIZE = 4096;
    public static final int DEFAULT_DOWNLOAD_SIZE = 4096;

    public static String getParentType(String type) {
        if (type == null) {
            throw new NullPointerException("type is null.");
        }
        int index = type.lastIndexOf(".");
        return index >= 0 ? type.substring(0, index) : null;
    }

    public static List getChildPath(List parentPath, String childID) {
        if (parentPath == null) {
            throw new NullPointerException("parentPath is null.");
        }
        if (childID == null) {
            throw new NullPointerException("childID is null.");
        }
        LinkedList<String> childPath = new LinkedList<String>(parentPath);
        childPath.addFirst(childID);
        return childPath;
    }

    public static ObjectName getResourcesPattern(String type, List parentPath) throws MalformedObjectNameException {
        if (type == null) {
            throw new NullPointerException("type is null.");
        }
        if (parentPath == null) {
            throw new NullPointerException("parentPath is null.");
        }
        StringBuffer name = new StringBuffer(JMX_DOMAIN);
        name.append(":");
        name.append("type=" + type);
        StringTokenizer st = new StringTokenizer(type, ".");
        if (st.countTokens() != parentPath.size() + 1) {
            String message = "type is inconsistent with parentPath's length.";
            throw new IllegalArgumentException(message);
        }
        for (int i = parentPath.size() - 1; i >= 0; --i) {
            name.append(",");
            String resourceID = (String)parentPath.get(i);
            name.append(st.nextToken() + "=" + resourceID.toLowerCase());
        }
        name.append(",*");
        return new ObjectName(name.toString());
    }

    public static ObjectName getAllResourcesPattern(String parentType, List parentPath) throws MalformedObjectNameException {
        if (parentType == null) {
            throw new NullPointerException("parentType is null.");
        }
        if (parentPath == null) {
            throw new NullPointerException("parentPath is null.");
        }
        StringBuffer name = new StringBuffer(JMX_DOMAIN);
        name.append(":");
        StringTokenizer st = new StringTokenizer(parentType, ".");
        if (st.countTokens() != parentPath.size()) {
            String message = "parentType is inconsistent with parentPath's length.";
            throw new IllegalArgumentException(message);
        }
        for (int i = parentPath.size() - 1; i >= 0; --i) {
            String resourceID = (String)parentPath.get(i);
            name.append(st.nextToken() + "=" + resourceID.toLowerCase());
            name.append(",");
        }
        name.append("*");
        return new ObjectName(name.toString());
    }

    public static ObjectName getResourceMBeanObjectName(String type, List path) throws MalformedObjectNameException {
        if (type == null) {
            throw new NullPointerException("type is null.");
        }
        if (path == null) {
            throw new NullPointerException("path is null.");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("path cannot be empty.");
        }
        Hashtable<String, String> keyProperties = new Hashtable<String, String>();
        keyProperties.put(KEY_TYPE, type);
        String resourceID = (String)path.get(0);
        keyProperties.put(KEY_ID, resourceID.toLowerCase());
        StringTokenizer st = new StringTokenizer(type, ".");
        if (st.countTokens() != path.size()) {
            String message = "type is inconsistent with path's length.";
            throw new IllegalArgumentException(message);
        }
        for (int i = path.size() - 1; i > 0; --i) {
            resourceID = (String)path.get(i);
            keyProperties.put(st.nextToken(), resourceID.toLowerCase());
        }
        return new ObjectName(JMX_DOMAIN, keyProperties);
    }

    public static ObjectName getPortalDomainsPattern() throws MalformedObjectNameException {
        return AdminUtil.getResourcesPattern("PortalDomain", Collections.EMPTY_LIST);
    }

    public static ObjectName getPortalDomainMBeanObjectName(String domainID) throws MalformedObjectNameException {
        if (domainID == null) {
            throw new NullPointerException("domainID is null.");
        }
        return AdminUtil.getResourceMBeanObjectName("PortalDomain", Collections.singletonList(domainID));
    }

    public static ObjectName getPortalsPattern(String domainID) throws MalformedObjectNameException {
        if (domainID == null) {
            throw new NullPointerException("domainID is null.");
        }
        return AdminUtil.getResourcesPattern(PORTAL_MBEAN_TYPE, Collections.singletonList(domainID));
    }

    public static ObjectName getSearchServerPattern(String domainID) throws MalformedObjectNameException {
        if (domainID == null) {
            throw new NullPointerException("domainID is null.");
        }
        return AdminUtil.getResourcesPattern(SEARCHSERVER_MBEAN_TYPE, Collections.singletonList(domainID));
    }

    public static ObjectName getSearchDatabasePattern(String domainID, String searchServerID) throws MalformedObjectNameException {
        if (domainID == null) {
            throw new NullPointerException("domainID is null.");
        }
        if (searchServerID == null) {
            throw new NullPointerException("searchServerID is null.");
        }
        LinkedList<String> path = new LinkedList<String>();
        path.addFirst(domainID);
        path.addFirst(searchServerID);
        return AdminUtil.getResourcesPattern(SEARCH_DATABASE_MBEAN_TYPE, path);
    }

    public static ObjectName getPortalMBeanObjectName(String domainID, String portalID) throws MalformedObjectNameException {
        if (domainID == null) {
            throw new NullPointerException("domainID is null.");
        }
        if (portalID == null) {
            throw new NullPointerException("portalID is null.");
        }
        LinkedList<String> path = new LinkedList<String>();
        path.addFirst(domainID);
        path.addFirst(portalID);
        return AdminUtil.getResourceMBeanObjectName(PORTAL_MBEAN_TYPE, path);
    }

    public static ObjectName getPortalServerInstancesPattern(String domainID, String portalID) throws MalformedObjectNameException {
        if (domainID == null) {
            throw new NullPointerException("domainID is null.");
        }
        if (portalID == null) {
            throw new NullPointerException("portalID is null.");
        }
        LinkedList<String> path = new LinkedList<String>();
        path.addFirst(domainID);
        path.addFirst(portalID);
        return AdminUtil.getResourcesPattern(PORTAL_SERVER_INSTANCE_MBEAN_TYPE, path);
    }

    public static ObjectName getInstanceMBeanObjectName(String domainID, String portalID, String instanceID) throws MalformedObjectNameException {
        if (domainID == null) {
            throw new NullPointerException("domainID is null.");
        }
        if (portalID == null) {
            throw new NullPointerException("portalID is null.");
        }
        if (instanceID == null) {
            throw new NullPointerException("instanceID is null.");
        }
        LinkedList<String> path = new LinkedList<String>();
        path.addFirst(domainID);
        path.addFirst(portalID);
        path.addFirst(instanceID);
        return AdminUtil.getResourceMBeanObjectName(PORTAL_SERVER_INSTANCE_MBEAN_TYPE, path);
    }

    public static ObjectName getDisplayProfileMBeanObjectName(String domainId, String portalId) throws MalformedObjectNameException {
        if (domainId == null) {
            throw new NullPointerException("domainID is null.");
        }
        if (portalId == null) {
            throw new NullPointerException("portalID is null.");
        }
        ObjectName objName = null;
        String resourceId = DISPLAYPROFILE_MBEAN;
        LinkedList<String> path = new LinkedList<String>();
        path.addFirst(domainId);
        path.addFirst(portalId);
        path.addFirst(resourceId);
        objName = AdminClientUtil.getResourceMBeanObjectName(DISPLAYPROFILE_MBEAN_TYPE, path);
        return objName;
    }

    public static boolean isLocal(String host) throws UnknownHostException {
        InetAddress[] addresses = InetAddress.getAllByName(host);
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            // empty catch block
        }
        if (networkInterfaces != null) {
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> localAddrs = networkInterface.getInetAddresses();
                while (localAddrs.hasMoreElements()) {
                    InetAddress address = localAddrs.nextElement();
                    for (int i = 0; i < addresses.length; ++i) {
                        if (!addresses[i].equals(address)) continue;
                        return true;
                    }
                }
            }
        }
        InetAddress localHost = InetAddress.getLocalHost();
        String localHostName = localHost.getHostName();
        InetAddress[] localAddrs = InetAddress.getAllByName(localHostName);
        String canonicalHostName = localHost.getCanonicalHostName();
        InetAddress[] localCAddrs = InetAddress.getAllByName(canonicalHostName);
        for (int i = 0; i < addresses.length; ++i) {
            int j;
            if (addresses[i].equals(localHost)) {
                return true;
            }
            for (j = 0; j < localAddrs.length; ++j) {
                if (!addresses[i].equals(localAddrs[j])) continue;
                return true;
            }
            for (j = 0; j < localCAddrs.length; ++j) {
                if (!addresses[i].equals(localCAddrs[j])) continue;
                return true;
            }
        }
        return false;
    }
}

