/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.common.context.ldap;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.context.PortalDomainContextException;
import com.sun.portal.admin.common.context.ldap.LDAPPortalDomainContextConstants;
import com.sun.portal.admin.common.jaxb.Attribute;
import com.sun.portal.admin.common.jaxb.PortalResource;
import com.sun.portal.admin.common.util.AdminUtil;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.factory.JSSESocketFactory;

public class LDAPPortalDomainContext
implements PortalDomainContext,
LDAPPortalDomainContextConstants {
    public static final String[] NO_ATTRS = new String[]{"1.1"};
    public static final String ALL_OBJECT_CLASSES = "objectClass=*";
    protected String rootSuffix = null;
    protected String domainID = null;
    protected PSConfigContext configContext = null;
    protected List portalResources = null;
    protected Logger logger = null;
    protected LDAPConnection connection = null;
    protected Map attributesMap = null;

    public void init(String domainID, PSConfigContext configContext, List portalResources, Logger logger) throws PortalDomainContextException {
        String credentials;
        String principal;
        String portStr;
        if (domainID == null) {
            throw new NullPointerException("domainID is null");
        }
        if (configContext == null) {
            throw new NullPointerException("configContext is null");
        }
        if (portalResources == null) {
            throw new NullPointerException("portalResources is null");
        }
        if (logger == null) {
            throw new NullPointerException("logger is null");
        }
        this.domainID = domainID;
        this.configContext = configContext;
        this.portalResources = portalResources;
        this.logger = logger;
        String baseDir = configContext.getPSBaseDir();
        String host = configContext.getDomainDataHost();
        if (host == null || host.trim().length() == 0) {
            host = configContext.getDirectoryServerHost();
        }
        if ((portStr = configContext.getDomainDataPort()) == null || portStr.trim().length() == 0) {
            portStr = configContext.getDirectoryServerPort();
        }
        int port = 0;
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            throw new PortalDomainContextException(e);
        }
        this.rootSuffix = configContext.getDomainDataRootSuffix();
        if (this.rootSuffix == null || this.rootSuffix.trim().length() == 0) {
            this.rootSuffix = configContext.getRootSuffix();
        }
        if ((principal = configContext.getDomainDataPrincipal()) == null || principal.trim().length() == 0) {
            principal = configContext.getUserDataStoreManager();
        }
        if ((credentials = configContext.getDomainDataCredentials()) == null || credentials.trim().length() == 0) {
            credentials = configContext.getUserDataStoreManagerCredentials();
        }
        this.connection = configContext.isDomainDataSecure() ? new LDAPConnection((LDAPSocketFactory)new JSSESocketFactory(null)) : new LDAPConnection();
        this.connection.getSearchConstraints().setReferrals(true);
        try {
            this.connection.connect(host, port, principal, credentials);
            this.loadResourceSchema();
        }
        catch (LDAPException e) {
            throw new PortalDomainContextException(e);
        }
        this.ensureDomainNode();
    }

    public String getID() {
        return this.domainID;
    }

    public String getDefaultOrg() {
        return this.configContext.getDefaultOrganization();
    }

    public String getSuperUser() {
        return this.configContext.getAdminUserDN();
    }

    public Map getMultipleAttributeValues(String type, List path, Set names) throws PortalDomainContextException {
        if (names == null) {
            throw new NullPointerException("names is null.");
        }
        TreeMap<String, Set> result = new TreeMap<String, Set>();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Set values = this.getAttributeValues(type, path, name);
            result.put(name, values);
        }
        return result;
    }

    public void setMultipleAttributeValues(String type, List path, Map attributes) throws PortalDomainContextException {
        if (attributes == null) {
            throw new NullPointerException("attributes is null.");
        }
        Iterator i = attributes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry attribute = i.next();
            String name = (String)attribute.getKey();
            Set values = (Set)attribute.getValue();
            this.setAttributeValues(type, path, name, values);
        }
    }

    public Set getAttributeValues(String type, List path, String name) throws PortalDomainContextException {
        if (type == null) {
            throw new NullPointerException("type is null.");
        }
        if (path == null) {
            throw new NullPointerException("path is null.");
        }
        if (name == null) {
            throw new NullPointerException("name is null.");
        }
        List attributes = (List)this.attributesMap.get(type);
        if (attributes == null) {
            throw new NoSuchElementException("No such resource type: " + type);
        }
        if (!attributes.contains(name)) {
            throw new NoSuchElementException("No such attribute: " + name);
        }
        String nameLDAP = this.getLDAPName(this.getObjectClass(type), name);
        try {
            return this.getAttributeValues(this.getDN(type, path), nameLDAP);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 16) {
                return Collections.EMPTY_SET;
            }
            if (e.getLDAPResultCode() == 32) {
                throw new NoSuchElementException("No such resource instance.");
            }
            throw new PortalDomainContextException(e);
        }
    }

    public void setAttributeValues(String type, List path, String name, Set values) throws PortalDomainContextException {
        if (type == null) {
            throw new NullPointerException("type is null.");
        }
        if (path == null) {
            throw new NullPointerException("path is null.");
        }
        if (name == null) {
            throw new NullPointerException("name is null.");
        }
        List attributes = (List)this.attributesMap.get(type);
        if (attributes == null) {
            throw new NoSuchElementException("No such resource type: " + type);
        }
        if (!attributes.contains(name)) {
            throw new NoSuchElementException("No such attribute: " + name);
        }
        String nameLDAP = this.getLDAPName(this.getObjectClass(type), name);
        try {
            this.setAttributeValues(this.getDN(type, path), nameLDAP, values);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 32) {
                throw new NoSuchElementException("No such resource instance.");
            }
            throw new PortalDomainContextException(e);
        }
    }

    public String getAttributeValue(String type, List path, String name) throws PortalDomainContextException {
        Iterator values = this.getAttributeValues(type, path, name).iterator();
        if (values.hasNext()) {
            return (String)values.next();
        }
        return null;
    }

    public void setAttributeValue(String type, List path, String name, String value) throws PortalDomainContextException {
        TreeSet<String> values = new TreeSet<String>();
        if (value != null) {
            values.add(value);
        }
        this.setAttributeValues(type, path, name, values);
    }

    public Set getResourceIDs(String type, List parentPath) throws PortalDomainContextException {
        if (type == null) {
            throw new NullPointerException("type is null.");
        }
        if (parentPath == null) {
            throw new NullPointerException("parentPath is null.");
        }
        if (!this.attributesMap.containsKey(type)) {
            throw new NoSuchElementException("No such resource type: " + type);
        }
        String parentDN = this.getDN(AdminUtil.getParentType(type), parentPath);
        String objectClass = this.getObjectClass(type);
        String filter = "(objectClass=" + objectClass + ")";
        String id = this.getID(objectClass);
        try {
            LDAPSearchResults results = this.connection.search(parentDN, 1, filter, new String[]{id}, false);
            TreeSet result = new TreeSet();
            while (results.hasMoreElements()) {
                Enumeration values;
                LDAPEntry portalEntry = results.next();
                LDAPAttribute attr = portalEntry.getAttribute(id);
                if (attr == null || (values = attr.getStringValues()) == null || !values.hasMoreElements()) continue;
                result.add(values.nextElement());
            }
            return result;
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 32) {
                throw new NoSuchElementException("No such parent resource instance.");
            }
            throw new PortalDomainContextException(e);
        }
    }

    public void createResource(String type, List parentPath, String resourceID, Map attributes) throws PortalDomainContextException {
        if (type == null) {
            throw new NullPointerException("type is null.");
        }
        if (parentPath == null) {
            throw new NullPointerException("parentPath is null.");
        }
        if (resourceID == null) {
            throw new NullPointerException("resourceID is null.");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is null.");
        }
        this.checkID(resourceID);
        List path = AdminUtil.getChildPath(parentPath, resourceID);
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        String oc = this.getObjectClass(type);
        String[] objectClass = new String[]{"top", oc};
        attrs.add(new LDAPAttribute("objectClass", objectClass));
        attrs.add(new LDAPAttribute(this.getID(oc), resourceID));
        List attributeNames = (List)this.attributesMap.get(type);
        if (attributeNames == null) {
            throw new NoSuchElementException("No such resource type: " + type);
        }
        Iterator i = attributes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            if (!attributeNames.contains(name)) {
                throw new NoSuchElementException("No such attribute: " + name);
            }
            String nameLDAP = this.getLDAPName(oc, name);
            this.addAttr(attrs, nameLDAP, entry.getValue());
        }
        String message = null;
        try {
            this.connection.add(new LDAPEntry(this.getDN(type, path), attrs));
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 68) {
                message = "PS resource instance with same ID already exists.";
                throw new PortalDomainContextException(message);
            }
            if (e.getLDAPResultCode() == 32) {
                message = "No such parent resource instance.";
                throw new NoSuchElementException(message);
            }
            throw new PortalDomainContextException(e);
        }
    }

    public void removeResource(String type, List path) throws PortalDomainContextException {
        if (type == null) {
            throw new NullPointerException("type is null.");
        }
        if (path == null) {
            throw new NullPointerException("path is null.");
        }
        String dn = this.getDN(type, path);
        if (!dn.equals(this.rootSuffix)) {
            try {
                this.deleteSubTree(dn);
            }
            catch (LDAPException e) {
                throw new PortalDomainContextException(e);
            }
        }
    }

    public void destroy() {
        try {
            this.connection.disconnect();
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        this.attributesMap = null;
        this.connection = null;
        this.logger = null;
        this.portalResources = null;
        this.configContext = null;
        this.domainID = null;
        this.rootSuffix = null;
    }

    protected void loadResourceSchema() throws LDAPException {
        this.attributesMap = new TreeMap();
        for (int i = 0; i < this.portalResources.size(); ++i) {
            PortalResource resource = (PortalResource)this.portalResources.get(i);
            String type = resource.getType();
            String objectClass = this.getObjectClass(type);
            String resourceID = this.getID(objectClass);
            LDAPAttributeSchema attributeSchema = new LDAPAttributeSchema(resourceID, this.getOID(resourceID), resource.getDescription() + " ID", 1, false);
            attributeSchema.add(this.connection);
            List attributes = resource.getAttribute();
            String[] required = new String[]{resourceID};
            String[] optional = new String[attributes.size()];
            LinkedList<String> attributeNames = new LinkedList<String>();
            for (int j = 0; j < attributes.size(); ++j) {
                Attribute attribute = (Attribute)attributes.get(j);
                String attributeName = attribute.getName();
                String nameLDAP = this.getLDAPName(objectClass, attributeName);
                attributeSchema = new LDAPAttributeSchema(nameLDAP, this.getOID(nameLDAP), attribute.getDescription(), 1, false);
                attributeSchema.add(this.connection);
                optional[j] = nameLDAP;
                attributeNames.add(attributeName);
            }
            LDAPObjectClassSchema objectClassSchema = new LDAPObjectClassSchema(objectClass, this.getOID(objectClass), "top", resource.getDescription(), required, optional);
            objectClassSchema.add(this.connection);
            this.attributesMap.put(type, attributeNames);
        }
    }

    protected void ensureDomainNode() throws PortalDomainContextException {
        if (!this.attributesMap.containsKey("PortalDomain")) {
            throw new PortalDomainContextException("No domain MBean type!");
        }
        String domainDN = this.getDN("PortalDomain", Collections.singletonList(this.domainID));
        try {
            this.connection.read(domainDN, NO_ATTRS);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 32) {
                this.createResource("PortalDomain", Collections.EMPTY_LIST, this.domainID, Collections.EMPTY_MAP);
            }
            throw new PortalDomainContextException(e);
        }
    }

    protected Set getAttributeValues(String dn, String name) throws LDAPException {
        LDAPEntry entry = this.connection.read(dn, new String[]{name});
        LDAPAttribute attribute = entry.getAttribute(name);
        if (attribute == null) {
            return Collections.EMPTY_SET;
        }
        TreeSet result = new TreeSet();
        Enumeration values = attribute.getStringValues();
        if (values != null) {
            while (values.hasMoreElements()) {
                result.add(values.nextElement());
            }
        }
        return result;
    }

    protected void setAttributeValues(String dn, String name, Set values) throws LDAPException {
        if (values == null) {
            throw new NullPointerException("values is null.");
        }
        String[] stringValues = values.toArray(new String[0]);
        LDAPAttribute a = new LDAPAttribute(name, stringValues);
        LDAPModification m = new LDAPModification(2, a);
        this.connection.modify(dn, m);
    }

    protected String getObjectClass(String type) {
        return "sunPortalAdmin" + type.replaceAll("\\.", "");
    }

    protected String getID(String objectClass) {
        return objectClass + "ID";
    }

    protected String getLDAPName(String objectClass, String attributeName) {
        return objectClass + attributeName;
    }

    protected String getOID(String name) {
        return name + "-oid";
    }

    protected String getDN(String type, List path) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; type != null && i < path.size(); ++i) {
            result.append(this.getID(this.getObjectClass(type)));
            result.append("=");
            result.append(path.get(i));
            result.append(",");
            type = AdminUtil.getParentType(type);
        }
        result.append(this.rootSuffix);
        return result.toString();
    }

    protected void checkID(String id) {
        if ((id = id.trim()).length() == 0) {
            throw new IllegalArgumentException("The given ID is blank.");
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-') continue;
            throw new IllegalArgumentException(id + " is not an " + "alpha-numeric string.");
        }
    }

    protected void addAttr(LDAPAttributeSet attrs, String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            attrs.add(new LDAPAttribute(name, (String)value));
        } else if (value instanceof String[]) {
            attrs.add(new LDAPAttribute(name, (String[])value));
        } else {
            throw new ClassCastException("Type of " + name + "'s value is " + "neither String nor String[].");
        }
    }

    protected void deleteSubTree(String dn) throws LDAPException {
        block3: {
            try {
                LDAPSearchResults results = this.connection.search(dn, 1, ALL_OBJECT_CLASSES, NO_ATTRS, false);
                while (results.hasMoreElements()) {
                    this.deleteSubTree(results.next().getDN());
                }
                this.connection.delete(dn);
            }
            catch (LDAPException e) {
                if (e.getLDAPResultCode() == 32) break block3;
                throw e;
            }
        }
    }
}

