/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.common.context;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.context.PortalDomainContextException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;

public class PortalDomainContextFactory {
    private static Map contexts = Collections.synchronizedMap(new HashMap());

    public static void loadPortalDomainContext(String domainID, PSConfigContext configContext, List portalResources, Logger logger) throws PortalDomainContextException {
        if (domainID == null) {
            throw new NullPointerException("domainID is null");
        }
        if (configContext == null) {
            throw new NullPointerException("configContext is null");
        }
        if (portalResources == null) {
            throw new NullPointerException("portalResources is null");
        }
        if (logger == null) {
            throw new NullPointerException("logger is null");
        }
        String className = configContext.getDomainDataClass();
        try {
            PortalDomainContext context = (PortalDomainContext)Class.forName(className).newInstance();
            context.init(domainID, configContext, portalResources, logger);
            contexts.put(domainID, context);
        }
        catch (Throwable e) {
            throw new PortalDomainContextException(e);
        }
    }

    public static void unloadAllPortalDomainContexts() {
        Iterator i = contexts.values().iterator();
        while (i.hasNext()) {
            ((PortalDomainContext)i.next()).destroy();
        }
        contexts.clear();
    }

    public static Set getAllPortalDomainIDs() {
        return contexts.keySet();
    }

    public static PortalDomainContext getPortalDomainContext(String domainID) {
        if (domainID == null) {
            throw new NullPointerException("domainID is null");
        }
        PortalDomainContext context = (PortalDomainContext)contexts.get(domainID);
        if (context == null) {
            throw new NoSuchElementException("No such domain: " + domainID);
        }
        return context;
    }
}

