/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.common.context;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.util.ResourceLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import sun.misc.BASE64Decoder;

public class PSConfigContextImpl
implements PSConfigContext {
    protected static final String FS = File.separator;
    protected String domainDir = null;
    protected Properties isConfig;
    protected Properties psConfig;
    protected Properties domainConfig;
    protected Properties portalVersion;
    protected Properties sraConfig;
    protected BASE64Decoder decoder = new BASE64Decoder();

    public PSConfigContextImpl(String domainID) throws FileNotFoundException, IOException {
        ResourceLoader rl = ResourceLoader.getInstance((Properties)System.getProperties());
        this.psConfig = rl.getProperties("PSConfig.properties");
        if (this.psConfig != null) {
            this.domainDir = this.getPSConfigDir() + FS + "domains" + FS + domainID;
            String file = this.domainDir + FS + "PortalDomainConfig.properties";
            this.domainConfig = rl.getProperties(file);
            String amconf = this.getUserAuthConfigFile();
            this.isConfig = rl.getProperties(amconf);
            try {
                this.sraConfig = rl.getProperties("SRAConfig.properties");
            }
            catch (FileNotFoundException fnfe) {
                // empty catch block
            }
            String portalVersionFile = this.getPSBaseDir() + FS + "lib" + FS + "PSversion.properties";
            this.portalVersion = rl.getProperties(portalVersionFile);
        }
    }

    public String getPathSeparator() {
        return FS.equals("/") ? ":" : ";";
    }

    public String getAMVersion() {
        String version = this.isConfig.getProperty("com.iplanet.am.version").trim();
        String AMVer6Regex = ".*6\\s.*";
        String AMVer7Regex = ".*7\\s.*";
        if (version.matches(AMVer6Regex)) {
            return "6";
        }
        if (version.matches(AMVer7Regex)) {
            return "7";
        }
        return "invalid";
    }

    public String getJavaHome() {
        return this.psConfig.getProperty("java.home");
    }

    public String getPSBaseDir() {
        return this.psConfig.getProperty("ps.product.location");
    }

    public String getPSDataDir() {
        return this.psConfig.getProperty("ps.data.location");
    }

    public String getPSConfigDir() {
        return this.psConfig.getProperty("ps.config.location");
    }

    public String getISBaseDir() {
        return this.psConfig.getProperty("am.product.location");
    }

    public String getISConfigDir() {
        return this.psConfig.getProperty("am.config.location");
    }

    public String getISDataDir() {
        return this.psConfig.getProperty("am.data.location");
    }

    public String getCacaoBaseDir() {
        return this.psConfig.getProperty("cacao.product.location");
    }

    public String getCacaoConfigDir() {
        return this.psConfig.getProperty("cacao.config.location");
    }

    public String getSharedLibsDir() {
        return this.psConfig.getProperty("shared.lib.location");
    }

    public String getPrivateSharedLibsDir() {
        return this.psConfig.getProperty("private.lib.location");
    }

    public String getJSSNSSLibDir() {
        return this.psConfig.getProperty("jss.nss.lib.location");
    }

    public String getJSSJARDir() {
        return this.psConfig.getProperty("jss.jar.location");
    }

    public String getJDMKLibDir() {
        return this.psConfig.getProperty("jdmk.lib.location");
    }

    public String getDerbyLibDir() {
        return this.psConfig.getProperty("derby.lib.location");
    }

    public String getAntHomeDir() {
        return this.psConfig.getProperty("ant.home.location");
    }

    public String getAntLibDir() {
        return this.psConfig.getProperty("ant.lib.location");
    }

    public String getRegistryLibDir() {
        return this.psConfig.getProperty("registry.lib.location");
    }

    public String getOrgNamingAttribute() {
        return this.psConfig.getProperty("org.naming.attribute");
    }

    public String getRoleNamingAttribute() {
        return this.psConfig.getProperty("role.naming.attribute");
    }

    public String getUserNamingAttribute() {
        return this.psConfig.getProperty("user.naming.attribute");
    }

    public String getPeopleContainerNamingAttribute() {
        return this.psConfig.getProperty("peoplecontainer.naming.attribute");
    }

    public String getUserAuthConfigFile() {
        return this.domainConfig.getProperty("domain.users.auth.configuration");
    }

    public String getUserDataStoreManager() {
        return this.domainConfig.getProperty("domain.users.datastore.manager");
    }

    public String getUserDataStoreManagerCredentials() {
        String cred = this.domainConfig.getProperty("domain.users.datastore.manager.password");
        try {
            return new String(this.decoder.decodeBuffer(cred), "8859_1");
        }
        catch (Exception e) {
            return cred;
        }
    }

    public String getDomainDataClass() {
        return this.domainConfig.getProperty("domain.data.class");
    }

    public String getDomainDataHost() {
        return this.domainConfig.getProperty("domain.data.host");
    }

    public String getDomainDataPort() {
        return this.domainConfig.getProperty("domain.data.port");
    }

    public boolean isDomainDataSecure() {
        String isSecure = this.domainConfig.getProperty("domain.data.secure");
        if (isSecure == null || isSecure.trim().length() == 0) {
            isSecure = this.isConfig.getProperty("com.iplanet.am.directory.ssl.enabled");
        }
        return Boolean.valueOf(isSecure);
    }

    public String getDomainDataRootSuffix() {
        return this.domainConfig.getProperty("domain.data.rootsuffix");
    }

    public String getDomainDataPrincipal() {
        return this.domainConfig.getProperty("domain.data.principal");
    }

    public String getDomainDataCredentials() {
        String cred = this.domainConfig.getProperty("domain.data.credentials");
        try {
            return new String(this.decoder.decodeBuffer(cred), "8859_1");
        }
        catch (Exception e) {
            return cred;
        }
    }

    public String getSessionServiceProtocol() {
        return this.isConfig.getProperty("com.iplanet.am.server.protocol");
    }

    public String getSessionServiceHost() {
        return this.isConfig.getProperty("com.iplanet.am.server.host");
    }

    public String getSessionServicePort() {
        return this.isConfig.getProperty("com.iplanet.am.server.port");
    }

    public String getDefaultOrganization() {
        String amRootSuffix;
        String amDefaultOrg = this.isConfig.getProperty("com.iplanet.am.defaultOrg");
        if (amDefaultOrg.equalsIgnoreCase(amRootSuffix = this.getRootSuffix())) {
            return amDefaultOrg;
        }
        return amDefaultOrg + "," + amRootSuffix;
    }

    public String getRootSuffix() {
        return this.isConfig.getProperty("com.iplanet.am.rootsuffix");
    }

    public String getDefaultPeopleDN() {
        return this.getPeopleContainerNamingAttribute() + "=People," + this.getDefaultOrganization();
    }

    public String getDomainComponent() {
        return this.isConfig.getProperty("com.iplanet.am.domaincomponent");
    }

    public String getEncryptionKey() {
        return this.isConfig.getProperty("am.encryption.pwd");
    }

    public String getDirectoryServerHost() {
        return this.isConfig.getProperty("com.iplanet.am.directory.host");
    }

    public String getDirectoryServerPort() {
        return this.isConfig.getProperty("com.iplanet.am.directory.port");
    }

    public String getAdminUserDN() {
        return this.isConfig.getProperty("com.sun.identity.authentication.super.user");
    }

    public String getAMSpecialUsersDN() {
        String userDNs = this.isConfig.getProperty("com.sun.identity.authentication.special.users");
        int index = userDNs.indexOf("|");
        return index < 0 ? userDNs : userDNs.substring(0, index);
    }

    public String getAMLDAPUserDN() {
        return this.psConfig.getProperty("amldap.user.dn").replaceAll("\\=", "=");
    }

    public String getISConsoleURI() {
        return this.isConfig.getProperty("com.iplanet.am.console.deploymentDescriptor");
    }

    public String getISServerURI() {
        return this.isConfig.getProperty("com.iplanet.am.services.deploymentDescriptor");
    }

    public String getAttributeHandlerName(String component) {
        return this.domainConfig.getProperty("attribute.handler." + component);
    }

    public String getSRAServerDomain() {
        return this.sraConfig.getProperty("portal.server.domain");
    }

    public String getSRAGatewayProfile() {
        return this.sraConfig.getProperty("sra.gateway.profile");
    }

    public String getGWProtocol() {
        return this.sraConfig.getProperty("gateway.protocol");
    }

    public String getGWPort() {
        return this.sraConfig.getProperty("gateway.port");
    }

    public String getSRALogUserPassword() {
        return this.sraConfig.getProperty("sra.log.user.credentials");
    }

    public String getPortalProductName() {
        return this.portalVersion.getProperty("productname");
    }

    public String getPortalVersion() {
        return this.portalVersion.getProperty("productversion");
    }
}

