/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.common;

public class BackupVersion {
    public static final String DELIMITER = ";";
    public static final String BACKUP_VERSION = "V1.0";

    public static String generateBackupVersion(String domain, String portal, String type) {
        StringBuffer backupVersion = new StringBuffer();
        backupVersion.append(domain).append(DELIMITER).append(portal).append(DELIMITER).append(type).append(DELIMITER).append(BACKUP_VERSION);
        return backupVersion.toString();
    }

    public static String getDomain(String backupVersion) {
        String domain = null;
        if (BackupVersion.checkBackupVersion(backupVersion)) {
            domain = backupVersion.substring(0, backupVersion.indexOf(DELIMITER));
        }
        return domain;
    }

    public static String getPortal(String backupVersion) {
        String portal = null;
        if (BackupVersion.checkBackupVersion(backupVersion)) {
            String domain = backupVersion.substring(0, backupVersion.indexOf(DELIMITER));
            String rem = backupVersion.substring(domain.length() + 1, backupVersion.length());
            portal = rem.substring(0, rem.indexOf(DELIMITER));
        }
        return portal;
    }

    public static String getType(String backupVersion) {
        String type = null;
        if (BackupVersion.checkBackupVersion(backupVersion)) {
            String str = backupVersion.substring(0, backupVersion.lastIndexOf(DELIMITER));
            type = str.substring(str.lastIndexOf(DELIMITER) + 1, str.length());
        }
        return type;
    }

    private static boolean checkBackupVersion(String backupVersion) {
        boolean valid = true;
        String version = backupVersion.substring(backupVersion.lastIndexOf(DELIMITER) + 1, backupVersion.length());
        if (!version.equals(BACKUP_VERSION)) {
            valid = false;
        }
        return valid;
    }
}

