/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.log.monitor;

import com.sun.portal.log.monitor.FileChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;

public class FileMonitor {
    private static final FileMonitor instance = new FileMonitor();
    private Timer timer = new Timer(true);
    private Hashtable timerEntries = new Hashtable();
    private FileMonitorTask task;

    public static FileMonitor getInstance() {
        return instance;
    }

    protected FileMonitor() {
    }

    public void addFileChangeListener(FileChangeListener listener, String fileName, long period) throws FileNotFoundException {
        String monitoredFileName = FileMonitor.getMonitoredConfigFile(fileName);
        this.removeFileChangeListener(listener, monitoredFileName);
        this.task = new FileMonitorTask(listener, fileName);
        this.timerEntries.put(monitoredFileName + listener.hashCode(), this.task);
        this.timer.schedule((TimerTask)this.task, period, period);
    }

    public void removeFileChangeListener(FileChangeListener listener, String fileName) {
        FileMonitorTask task = (FileMonitorTask)this.timerEntries.remove(fileName + listener.hashCode());
        if (task != null) {
            task.cancel();
        }
    }

    protected void fireFileChangeEvent(FileChangeListener listener, String fileName) {
        listener.fileChanged(fileName);
    }

    public static String getMonitoredConfigFile(String logConfigFileName) {
        int index = logConfigFileName.lastIndexOf(File.separator) + 1;
        return logConfigFileName.substring(0, index) + "." + logConfigFileName.substring(index);
    }

    class FileMonitorTask
    extends TimerTask {
        FileChangeListener listener;
        String fileName;
        File monitoredFile;
        long lastModified;

        public FileMonitorTask(FileChangeListener listener, String fileName) {
            URL fileURL;
            this.listener = listener;
            this.fileName = fileName;
            this.lastModified = 0L;
            String monitoredFileName = FileMonitor.getMonitoredConfigFile(fileName);
            this.monitoredFile = new File(monitoredFileName);
            if (!this.monitoredFile.exists() && (fileURL = listener.getClass().getClassLoader().getResource(monitoredFileName)) != null) {
                this.monitoredFile = new File(fileURL.getFile());
            }
            this.lastModified = this.monitoredFile.lastModified();
        }

        public void run() {
            long lastModified = this.monitoredFile.lastModified();
            if (lastModified != this.lastModified) {
                this.lastModified = lastModified;
                FileMonitor.this.fireFileChangeEvent(this.listener, this.fileName);
            }
        }
    }
}

