/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.log.common;

import java.util.logging.Handler;
import java.util.logging.Level;

public class PortalLoggerDetail {
    static final String DELIMITER = "\t";
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String loggerName;
    private Level level;
    private boolean logToParent;
    private String stackTraceValue;
    private String pattern;
    private Handler[] handlers;

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public boolean isLogToParent() {
        return this.logToParent;
    }

    public void setLogToParent(boolean logToParent) {
        this.logToParent = logToParent;
    }

    public String getStackTraceValue() {
        return this.stackTraceValue;
    }

    public void setStackTraceValue(String stackTraceValue) {
        this.stackTraceValue = stackTraceValue;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Handler[] getHandlers() {
        return this.handlers;
    }

    public void setHandlers(Handler[] handlers) {
        this.handlers = handlers;
    }

    public String format(boolean fileInfo, boolean useServerLogs) {
        StringBuffer loggerDetail = new StringBuffer();
        if (this.getLoggerName() != null) {
            loggerDetail.append(this.getLoggerName());
            loggerDetail.append(LINE_SEPARATOR);
        }
        if (this.getLevel() != null) {
            loggerDetail.append("Level=");
            loggerDetail.append(this.getLevel().toString());
        }
        if (fileInfo) {
            loggerDetail.append(DELIMITER);
            loggerDetail.append("Use Parent Handler=");
            loggerDetail.append(this.isLogToParent());
            boolean fileHandlerInUse = false;
            Handler[] handlers = this.getHandlers();
            if (!useServerLogs && handlers != null && handlers.length != 0) {
                loggerDetail.append(DELIMITER);
                loggerDetail.append("Handler=");
                StringBuffer handlersValue = new StringBuffer();
                for (int j = 0; j < handlers.length; ++j) {
                    String handlerName = handlers[j].getClass().getName();
                    if (handlerName.equals("java.util.logging.FileHandler")) {
                        fileHandlerInUse = true;
                    }
                    handlersValue.append(handlerName);
                    if (j + 1 == handlers.length) continue;
                    handlersValue.append(",");
                }
                loggerDetail.append(handlersValue);
            }
            loggerDetail.append(DELIMITER);
            if (this.getPattern() != null && fileHandlerInUse) {
                loggerDetail.append("Logs to File=");
                loggerDetail.append(this.getPattern());
            }
            loggerDetail.append(DELIMITER);
            if (this.getStackTraceValue() != null && fileHandlerInUse) {
                loggerDetail.append("Print Stacktrace=");
                loggerDetail.append(this.getStackTraceValue());
            }
        }
        return loggerDetail.toString();
    }
}

