/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.log.common;

import com.sun.portal.log.common.LoggersList;
import com.sun.portal.log.common.PortalLogManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Logger;

public class PortalLogger {
    static String DEBUG_NAME = "debug";
    static Set loggerSet = Collections.synchronizedSet(new HashSet());
    static PortalLogManager manager = new PortalLogManager();

    protected static void addRootLogger(String rootLoggerName) {
        loggerSet.add(rootLoggerName);
        LoggersList.add(rootLoggerName);
    }

    private static Logger config(Logger logger) {
        String loggerName = logger.getName();
        if (!loggerSet.contains(loggerName)) {
            if (!manager.useServerLogs(loggerName)) {
                logger.setUseParentHandlers(true);
                logger.setLevel(manager.getLevel(loggerName));
                Handler[] handlers = logger.getHandlers();
                for (int i = 0; i < handlers.length; ++i) {
                    logger.removeHandler(handlers[i]);
                }
            }
            loggerSet.add(loggerName);
        }
        LoggersList.add(loggerName);
        return logger;
    }

    public static Logger getLogger(Class cls) {
        return PortalLogger.config(Logger.getLogger(PortalLogger.getName(cls)));
    }

    public static Logger getLogger(String name) {
        return PortalLogger.config(Logger.getLogger(PortalLogger.getName(name)));
    }

    private static String getName(Class cls) {
        Package pkg = cls.getPackage();
        String packageName = pkg == null ? PortalLogger.getDefaultPkgName(cls) : pkg.getName();
        String correctName = PortalLogger.correct(packageName);
        return correctName;
    }

    private static String getDefaultPkgName(Class cls) {
        String className = cls.getName();
        String pkgName = DEBUG_NAME;
        int index = -1;
        if (className != null) {
            index = className.lastIndexOf(".");
        }
        if (index != -1) {
            pkgName = className.substring(0, index);
        }
        return pkgName;
    }

    private static String getName(String name) {
        String correctName = PortalLogger.correct(name);
        return correctName;
    }

    private static String correct(String name) {
        if (name.indexOf(DEBUG_NAME) != 0) {
            StringBuffer csuffix = new StringBuffer();
            csuffix.append(DEBUG_NAME);
            csuffix.append(".");
            csuffix.append(name);
            return csuffix.toString();
        }
        return name;
    }
}

