/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.log.common;

import com.sun.portal.log.common.LoggersList;
import com.sun.portal.log.common.PortalLogErrorManager;
import com.sun.portal.log.common.PortalLogFormatter;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.log.common.PortalLoggerDetail;
import com.sun.portal.log.monitor.FileChangeListener;
import com.sun.portal.log.monitor.FileMonitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class PortalLogManager
implements FileChangeListener {
    static Map rootLoggerMap = Collections.synchronizedMap(new HashMap());
    static Map loggerDetailMap = Collections.synchronizedMap(new HashMap());
    static Properties configProperties;
    static Map configPropertiesMap;
    public static final String LOG_CONFIG_FILENAME = "PSLogConfig.properties";
    public static final String SEARCH_LOG_CONFIG_FILENAME = "SearchLogConfig.properties";
    public static final String DEFAULT_LOG_CONFIG_FILE = "PSLogConfigDefault.properties";
    public static final String LOG_MSG_FILE = "PortalLogMessages.properties";
    public static final String SRA_LOG_CONFIG_FILENAME_PREFIX = "platform.conf.";
    public static final String ADMIN_LOG_CONFIG_FILENAME = "PSAdminLogConfig.properties";
    public static final String LOG_CONFIG_FILENAME_PROPERTY = "com.sun.portal.log.config.file";
    public static final String INSTANCE_ID_PROPERTY = "com.sun.portal.instance.id";
    public static final String PORTAL_ID_PROPERTY = "com.sun.portal.portal.id";
    public static final String SRA_COMPONENT_TYPE_PROPERTY = "com.sun.portal.sra.component.type";
    public static final String DEBUG_ROOT_LOGGER = "debug.com.sun.portal";
    public static final String DEBUG_ROOT_LOGGER_SEARCH = "debug.com.sun.portal.search";
    public static final String DEBUG_COM_SUN_PREFIX = "debug.com.sun.";
    public static final String LOG_LEVEL_ATTRIBUTE = ".level";
    public static final String LOG_HANDLER_ATTRIBUTE = ".handler";
    public static final String LOG_SEPARATE_FILE_ATTRIBUTE = ".separatefile";
    public static final String LOG_TO_SERVER_ATTRIBUTE = ".setserverlogs";
    public static final String LOG_USE_PARENT_HANDLER = ".useparenthandler";
    public static final String LOG_STACK_TRACE_ATTRIBUTE = ".stacktrace";
    public static final String DEFAULT_LOG_HANDLER = "java.util.logging.FileHandler";
    public static final String LOG_HANDLER_PATTERN_ATTRIBUTE = ".pattern";
    public static final String LOG_HANDLER_LIMIT_ATTRIBUTE = ".limit";
    public static final String LOG_HANDLER_COUNT_ATTRIBUTE = ".count";
    public static final String LOG_HANDLER_APPEND_ATTRIBUTE = ".append";
    public static final String LOG_HANDLER_FILTER_ATTRIBUTE = ".filter";
    public static final String LOG_HANDLER_FORMATTER_ATTRIBUTE = ".formatter";
    public static final String DEFAULT_LOG_FORMATTER = "com.sun.portal.log.common.PortalLogFormatter";
    public static final String STACK_TRACE_UNKNOWN = "unknown";
    public static final String LOGGER_PATTERN = "%logger";
    public static final String INSTANCE_ID_PATTERN = "%instanceID";
    public static final String PORTAL_ID_PATTERN = "%portalID";
    public static final String SRA_COMPONENT_TYPE_PATTERN = "%sraComponentType";
    public static final String LOG_CONFIG_CHECK_PERIOD_KEY = "log.config.check.period";
    private static Object syncObject;

    public void init(String rootLoggerName) {
        String fullPathConfigFile = System.getProperty(LOG_CONFIG_FILENAME_PROPERTY);
        if (fullPathConfigFile != null) {
            this.readConfigFile(fullPathConfigFile);
            this.initLoggersList(rootLoggerName, fullPathConfigFile, false);
        }
        this.loadConfigFiles();
        this.configure(rootLoggerName);
        if (fullPathConfigFile != null && this.addRootLogger(fullPathConfigFile, rootLoggerName)) {
            this.configureFileMonitor(fullPathConfigFile);
        }
    }

    public void init(String rootLoggerName, String fullPathConfigFile) {
        this.initLoggersList(rootLoggerName, fullPathConfigFile, true);
        this.readConfigFile(fullPathConfigFile);
        this.loadConfigFiles();
        this.configure(rootLoggerName);
        if (this.addRootLogger(fullPathConfigFile, rootLoggerName)) {
            this.configureFileMonitor(fullPathConfigFile);
        }
    }

    boolean useServerLogs(String loggerName) {
        String value = this.getProperty(loggerName, LOG_TO_SERVER_ATTRIBUTE);
        return "true".equals(value);
    }

    private boolean addRootLogger(String fullPathConfigFile, String rootLoggerName) {
        boolean isNewEntry;
        Vector<String> rootLoggerNames = (Vector<String>)rootLoggerMap.get(fullPathConfigFile);
        if (rootLoggerNames == null) {
            rootLoggerNames = new Vector<String>();
            rootLoggerNames.add(rootLoggerName);
            isNewEntry = true;
        } else {
            rootLoggerNames.add(rootLoggerName);
            isNewEntry = false;
        }
        rootLoggerMap.put(fullPathConfigFile, rootLoggerNames);
        return isNewEntry;
    }

    private PortalLoggerDetail getPortalLoggerDetail(String loggerName) {
        PortalLoggerDetail portalLoggerDetail = (PortalLoggerDetail)loggerDetailMap.get(loggerName);
        if (portalLoggerDetail == null) {
            portalLoggerDetail = new PortalLoggerDetail();
            loggerDetailMap.put(loggerName, portalLoggerDetail);
        }
        return portalLoggerDetail;
    }

    private void configure(String rootLoggerName) {
        if (this.useServerLogs(rootLoggerName)) {
            Logger rootLogger = this.getLogger(rootLoggerName);
            return;
        }
        this.configureLogger(rootLoggerName);
        this.configureLoggers(rootLoggerName);
    }

    private void configureLoggers(String rootLoggerName) {
        Set<String> separateFiles = Collections.synchronizedSet(new TreeSet());
        Map<String, String> levels = Collections.synchronizedMap(new TreeMap());
        Set<String> handlers = Collections.synchronizedSet(new TreeSet());
        Enumeration<?> e = configProperties.propertyNames();
        while (e.hasMoreElements()) {
            int index;
            String loggerName;
            String propertyName = (String)e.nextElement();
            if (propertyName.endsWith(LOG_SEPARATE_FILE_ATTRIBUTE)) {
                if (!this.getProperty(propertyName).equals("true") || !(loggerName = propertyName.substring(0, index = propertyName.indexOf(LOG_SEPARATE_FILE_ATTRIBUTE))).startsWith(DEBUG_ROOT_LOGGER) || loggerName.equals(rootLoggerName)) continue;
                separateFiles.add(loggerName);
                continue;
            }
            if (propertyName.endsWith(LOG_LEVEL_ATTRIBUTE)) {
                index = propertyName.indexOf(LOG_LEVEL_ATTRIBUTE);
                loggerName = propertyName.substring(0, index);
                if (!loggerName.startsWith(DEBUG_ROOT_LOGGER)) continue;
                levels.put(loggerName, this.getProperty(propertyName));
                continue;
            }
            if (!propertyName.endsWith(LOG_HANDLER_ATTRIBUTE) || !(loggerName = propertyName.substring(0, index = propertyName.indexOf(LOG_HANDLER_ATTRIBUTE))).startsWith(DEBUG_ROOT_LOGGER) || loggerName.equals(rootLoggerName)) continue;
            handlers.add(loggerName);
        }
        Iterator<Object> itr = null;
        itr = separateFiles.iterator();
        while (itr.hasNext()) {
            try {
                this.configureLogger((String)itr.next());
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
        Set mappings = levels.entrySet();
        itr = mappings.iterator();
        while (itr.hasNext()) {
            Map.Entry mapEntry = (Map.Entry)itr.next();
            this.setLogLevel((String)mapEntry.getKey(), (String)mapEntry.getValue());
        }
    }

    private String getProperty(String key) {
        String value = configProperties.getProperty(key);
        return value;
    }

    private String getDefaultProperty(String key) {
        return this.getProperty(key);
    }

    private String getDefaultProperty(String loggerName, String attribute) {
        String value = this.getProperty(loggerName, attribute);
        return value;
    }

    private long getDefaultLogConfigCheckPeriodValue() {
        long configCheckPeriod;
        String value = this.getDefaultProperty(LOG_CONFIG_CHECK_PERIOD_KEY);
        try {
            configCheckPeriod = Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            configCheckPeriod = 2000L;
            nfe.printStackTrace();
        }
        return configCheckPeriod;
    }

    private String getProperty(String loggerName, String attribute) {
        String value = this.getProperty(loggerName + attribute);
        while (value == null && !loggerName.equals(DEBUG_ROOT_LOGGER)) {
            loggerName = this.getParent(loggerName);
            value = this.getProperty(loggerName + attribute);
        }
        return value;
    }

    private String getProperty(String loggerName, String attribute, String defaultValue) {
        String value = this.getProperty(loggerName, attribute);
        return value == null ? defaultValue : value;
    }

    private String getParent(String loggerName) {
        int lastIndex = loggerName.lastIndexOf(".");
        if (lastIndex == -1) {
            return DEBUG_ROOT_LOGGER;
        }
        return loggerName.substring(0, lastIndex);
    }

    public Level getLevel(String loggerName) {
        String levelValue = this.getProperty(loggerName, LOG_LEVEL_ATTRIBUTE);
        return this.parseLevel(levelValue);
    }

    private String getUseParentHandler(String loggerName) {
        return this.getProperty(loggerName, LOG_USE_PARENT_HANDLER, "false");
    }

    private void configureFileMonitor(String fullPathConfigFile) {
        long periodicity = 0L;
        String val = this.getProperty(LOG_CONFIG_CHECK_PERIOD_KEY);
        try {
            if (val != null) {
                periodicity = Long.parseLong(val);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (periodicity <= 0L) {
            periodicity = this.getDefaultLogConfigCheckPeriodValue();
        }
        try {
            FileMonitor.getInstance().addFileChangeListener(this, fullPathConfigFile, periodicity);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void readConfigFile(String fullPathConfigFile) {
        block14: {
            tmpConfigProperties = new Properties();
            in = null;
            try {
                in = new FileInputStream(fullPathConfigFile);
                tmpConfigProperties.load(in);
                var6_4 = null;
                ** if (in == null) goto lbl-1000
            }
            catch (Throwable var5_14) {
                var6_7 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                throw var5_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
lbl-1000:
            // 2 sources

            {
                break block14;
                catch (FileNotFoundException e) {
                    System.err.println(e.getMessage());
                    var6_5 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ignored) {}
                    }
                    break block14;
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                    var6_6 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
        }
        PortalLogManager.configPropertiesMap.put(fullPathConfigFile, tmpConfigProperties);
    }

    private void loadConfigFiles() {
        this.loadDefaultConfigFile();
        Set mappings = configPropertiesMap.entrySet();
        Iterator itr = mappings.iterator();
        while (itr.hasNext()) {
            Map.Entry mapEntry = itr.next();
            Properties tmpConfigProperties = (Properties)mapEntry.getValue();
            this.loadConfigProperties(tmpConfigProperties);
        }
    }

    private void loadConfigProperties(Properties tmpConfigProperties) {
        Enumeration<?> e = tmpConfigProperties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            configProperties.setProperty(key, tmpConfigProperties.getProperty(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void loadDefaultConfigFile() {
        block11: {
            defaultConfigBundle = null;
            defaultProperties = new Properties();
            try {
                defaultConfigBundle = this.getClass().getClassLoader().getResourceAsStream("PSLogConfigDefault.properties");
                defaultProperties.load(defaultConfigBundle);
                var5_3 = null;
                ** if (defaultConfigBundle == null) goto lbl-1000
            }
            catch (Throwable var4_10) {
                var5_5 = null;
                if (defaultConfigBundle != null) {
                    try {
                        defaultConfigBundle.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var4_10;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    defaultConfigBundle.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block11;
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    var5_4 = null;
                    if (defaultConfigBundle != null) {
                        try {
                            defaultConfigBundle.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        PortalLogManager.configProperties = new Properties(defaultProperties);
    }

    private void configureLogger(String rootLoggerName) {
        Logger rootLogger = this.getLogger(rootLoggerName);
        rootLogger.setUseParentHandlers(Boolean.valueOf(this.getUseParentHandler(rootLoggerName)));
        try {
            rootLogger.setLevel(this.getLevel(rootLoggerName));
        }
        catch (Exception ex) {
            System.err.println("Can't set level for " + rootLoggerName + LOG_LEVEL_ATTRIBUTE);
        }
        this.removeHandlers(rootLoggerName);
        this.addHandlers(rootLoggerName);
        PortalLogger.addRootLogger(rootLoggerName);
    }

    private Logger getLogger(String rootLoggerName) {
        Logger rootLogger = null;
        try {
            rootLogger = Logger.getLogger(rootLoggerName, LOG_MSG_FILE.substring(0, LOG_MSG_FILE.indexOf(".")));
        }
        catch (Exception e) {
            System.out.println("Can't get resource bundle corresponding to PortalLogMessages.properties " + e.getMessage());
        }
        return rootLogger;
    }

    private void addHandlers(String rootLoggerName) {
        Logger rootLogger = Logger.getLogger(rootLoggerName);
        rootLogger.setUseParentHandlers(false);
        String[] handlerNames = this.parseClassNames(this.getProperty(rootLoggerName, LOG_HANDLER_ATTRIBUTE));
        for (int i = 0; i < handlerNames.length; ++i) {
            String handlerName = handlerNames[i].trim();
            Handler handler = null;
            if (handlerName.equals(DEFAULT_LOG_HANDLER)) {
                try {
                    handler = this.getDefaultHandler(rootLoggerName);
                }
                catch (Exception e) {
                    handler = new ConsoleHandler();
                    System.out.println("Could not add file handler to PS logger...adding ConsoleHandler." + e.getMessage());
                }
            } else {
                try {
                    handler = (Handler)this.getClassInstance(handlerName);
                }
                catch (Exception ex) {
                    System.err.println(ex.getMessage());
                }
            }
            if (handler == null) continue;
            this.addFilterFormatter(rootLoggerName, handler);
            rootLogger.addHandler(handler);
        }
        if (rootLogger.getHandlers().length == 0) {
            this.addDefaultHandler(DEBUG_ROOT_LOGGER);
        }
    }

    private void addFilterFormatter(String loggerName, Handler handler) {
        String suffix = ".handler.java.util.logging.FileHandler";
        handler.setLevel(Level.FINEST);
        Filter filter = this.getFilter(loggerName, suffix + LOG_HANDLER_FILTER_ATTRIBUTE, null);
        handler.setFilter(filter);
        Formatter formatter = this.getFormatter(loggerName, suffix + LOG_HANDLER_FORMATTER_ATTRIBUTE, new PortalLogFormatter());
        handler.setFormatter(formatter);
        if (formatter instanceof PortalLogFormatter) {
            String stacktraceValue;
            Logger rootLogger = Logger.getLogger(DEBUG_ROOT_LOGGER);
            ((PortalLogFormatter)formatter).setResourceBundle(rootLogger.getResourceBundle());
            ((PortalLogFormatter)formatter).setResourceBundleName(rootLogger.getResourceBundleName());
            if (Logger.getLogger(loggerName).getLevel().intValue() >= Level.WARNING.intValue()) {
                stacktraceValue = "true";
            } else {
                stacktraceValue = this.getProperty(loggerName, LOG_STACK_TRACE_ATTRIBUTE, "false");
                if (this.getUseParentHandler(loggerName).equals("true")) {
                    stacktraceValue = "false";
                }
            }
            ((PortalLogFormatter)formatter).setPrintStackTrace(Boolean.valueOf(stacktraceValue));
            this.getPortalLoggerDetail(loggerName).setStackTraceValue(stacktraceValue);
        } else {
            this.getPortalLoggerDetail(loggerName).setStackTraceValue(STACK_TRACE_UNKNOWN);
        }
    }

    private void addDefaultHandler(String loggerName) {
        Logger logger = Logger.getLogger(loggerName);
        logger.setUseParentHandlers(false);
        Handler handler = null;
        try {
            handler = this.getDefaultHandler(loggerName);
        }
        catch (Exception e) {
            handler = new ConsoleHandler();
            System.out.println("Could not add file handler to PS logger...adding ConsoleHandler." + e.getMessage());
        }
        if (handler != null) {
            this.addFilterFormatter(loggerName, handler);
            if (logger.getHandlers().length == 0) {
                logger.addHandler(handler);
            }
        }
    }

    private Handler getDefaultHandler(String loggerName) throws Exception {
        String logDir;
        FileHandler fileHandler = null;
        String suffix = ".handler.java.util.logging.FileHandler";
        String pattern = this.getProperty(loggerName, suffix + LOG_HANDLER_PATTERN_ATTRIBUTE);
        if (pattern == null || pattern.equals("")) {
            throw new Exception("Pattern is either null or empty");
        }
        StringBuffer buffer = new StringBuffer(pattern);
        this.replaceInstanceId(buffer);
        this.replacePortalId(buffer);
        this.replaceSRAComponentType(buffer);
        this.replaceLoggerPattern(buffer, loggerName);
        this.replacePrefix(buffer);
        int limit = 0;
        int count = 2;
        try {
            limit = Integer.parseInt(this.getProperty(loggerName, suffix + LOG_HANDLER_LIMIT_ATTRIBUTE));
            count = Integer.parseInt(this.getProperty(loggerName, suffix + LOG_HANDLER_COUNT_ATTRIBUTE));
        }
        catch (Exception e) {
            System.err.println("Could not get the property .limit and .count");
        }
        int lastIndex = buffer.lastIndexOf(File.separator);
        if (lastIndex != -1 && !PortalLogManager.makeDir(logDir = buffer.substring(0, lastIndex))) {
            throw new Exception("Cannot create the directory: " + logDir);
        }
        boolean append = Boolean.valueOf(this.getProperty(loggerName, suffix + LOG_HANDLER_APPEND_ATTRIBUTE, "true"));
        fileHandler = limit != 0 ? new FileHandler(buffer.toString(), limit, count, append) : new FileHandler(buffer.toString(), append);
        if (fileHandler == null) {
            throw new Exception("FileHandler is null");
        }
        fileHandler.setErrorManager(new PortalLogErrorManager());
        this.getPortalLoggerDetail(loggerName).setPattern(buffer.toString());
        return fileHandler;
    }

    private void replaceInstanceId(StringBuffer buffer) {
        int index;
        String instanceId = this.getInstanceId();
        if (instanceId == null) {
            instanceId = "";
        }
        if ((index = buffer.indexOf(INSTANCE_ID_PATTERN)) != -1) {
            buffer.replace(index, index + INSTANCE_ID_PATTERN.length(), instanceId);
        }
    }

    private void replacePortalId(StringBuffer buffer) {
        String portalId = this.getPortalId();
        int index = buffer.indexOf(PORTAL_ID_PATTERN);
        if (index != -1) {
            if (portalId == null) {
                buffer.replace(index, index + PORTAL_ID_PATTERN.length() + 1, "");
            } else {
                buffer.replace(index, index + PORTAL_ID_PATTERN.length(), portalId);
            }
        }
    }

    private void replaceSRAComponentType(StringBuffer buffer) {
        String sraComponentType = this.getSRAComponentType();
        int index = buffer.indexOf(SRA_COMPONENT_TYPE_PATTERN);
        if (index != -1) {
            if (sraComponentType == null) {
                buffer.replace(index, index + SRA_COMPONENT_TYPE_PATTERN.length() + 1, "");
            } else {
                buffer.replace(index, index + SRA_COMPONENT_TYPE_PATTERN.length(), sraComponentType);
            }
        }
    }

    private void replaceLoggerPattern(StringBuffer buffer, String loggerName) {
        int index = buffer.indexOf(LOGGER_PATTERN);
        if (index != -1) {
            buffer.replace(index, index + LOGGER_PATTERN.length(), loggerName);
        }
    }

    private void replacePrefix(StringBuffer buffer) {
        int index = buffer.indexOf(DEBUG_COM_SUN_PREFIX);
        if (index != -1) {
            buffer.replace(index, index + DEBUG_COM_SUN_PREFIX.length(), "");
        }
    }

    private String getInstanceId() {
        return System.getProperty(INSTANCE_ID_PROPERTY);
    }

    private String getPortalId() {
        return System.getProperty(PORTAL_ID_PROPERTY);
    }

    private String getSRAComponentType() {
        return System.getProperty(SRA_COMPONENT_TYPE_PROPERTY);
    }

    private Filter getFilter(String loggerName, String attribute, Filter defaultValue) {
        String value = this.getProperty(loggerName, attribute);
        try {
            if (value != null) {
                return (Filter)this.getClassInstance(value);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return defaultValue;
    }

    private Object getClassInstance(String value) throws Exception {
        ClassLoader clsLoader = this.getClass().getClassLoader();
        Class<?> cls = clsLoader == null ? ClassLoader.getSystemClassLoader().loadClass(value) : clsLoader.loadClass(value);
        return cls.newInstance();
    }

    private Formatter getFormatter(String loggerName, String attribute, Formatter defaultValue) {
        String value = this.getProperty(loggerName, attribute);
        try {
            if (value != null) {
                return (Formatter)this.getClassInstance(value);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return defaultValue;
    }

    private String[] parseClassNames(String names) {
        StringTokenizer tokens = new StringTokenizer(names, " \t,");
        String[] tokenValues = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            tokenValues[i++] = tokens.nextToken();
        }
        return tokenValues;
    }

    private Vector listPSLoggers() {
        Enumeration<String> e = LogManager.getLogManager().getLoggerNames();
        Vector<String> loggerNames = new Vector<String>();
        while (e.hasMoreElements()) {
            String loggerName = e.nextElement();
            if (!loggerName.startsWith(DEBUG_ROOT_LOGGER)) continue;
            loggerNames.add(loggerName);
        }
        return loggerNames;
    }

    private Vector getChildLoggers(String loggerName) {
        Vector loggerNames = this.listPSLoggers();
        return this.getChildLoggers(loggerName, loggerNames);
    }

    private Vector getChildLoggers(String loggerName, Vector loggerNames) {
        String loggerNamespace = loggerName + ".";
        int numberOfLoggers = loggerNames.size();
        Vector<String> childLoggers = new Vector<String>();
        for (int i = 0; i < numberOfLoggers; ++i) {
            String childLoggerName = (String)loggerNames.get(i);
            if (!childLoggerName.equals(loggerName) && !childLoggerName.startsWith(loggerNamespace)) continue;
            childLoggers.add(childLoggerName);
        }
        return childLoggers;
    }

    private void setLogLevel(String loggerName, String level) {
        if (level != null) {
            Vector childLoggers = this.getChildLoggers(loggerName);
            int numberOfLoggers = childLoggers.size();
            for (int i = 0; i < numberOfLoggers; ++i) {
                String childLoggerName = (String)childLoggers.get(i);
                Logger.getLogger(childLoggerName).setLevel(this.parseLevel(level));
            }
        }
    }

    private void removeHandlers(String loggerName) {
        Vector childLoggers = this.getChildLoggers(loggerName);
        int numberOfLoggers = childLoggers.size();
        for (int i = 0; i < numberOfLoggers; ++i) {
            String childLoggerName = (String)childLoggers.get(i);
            if (loggerName.equals(DEBUG_ROOT_LOGGER) && childLoggerName.startsWith(DEBUG_ROOT_LOGGER_SEARCH)) continue;
            Logger tempLogger = Logger.getLogger(childLoggerName);
            Handler[] handlers = tempLogger.getHandlers();
            for (int j = 0; j < handlers.length; ++j) {
                handlers[j].close();
                tempLogger.removeHandler(handlers[j]);
            }
        }
    }

    private Level parseLevel(String value) {
        Level level;
        try {
            level = Level.parse(value);
        }
        catch (IllegalArgumentException iae) {
            String levelValue = this.getDefaultProperty(DEBUG_ROOT_LOGGER, LOG_LEVEL_ATTRIBUTE);
            level = Level.parse(levelValue);
        }
        return level;
    }

    public void reloadConfiguration(String fileName) {
        Vector rootLoggerNames = (Vector)rootLoggerMap.get(fileName);
        this.readConfigFile(fileName);
        this.loadConfigFiles();
        int size = rootLoggerNames.size();
        for (int i = 0; i < size; ++i) {
            this.configure((String)rootLoggerNames.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileChanged(String fileName) {
        Object object = syncObject;
        synchronized (object) {
            this.reloadConfiguration(fileName);
        }
    }

    private static boolean makeDir(String dirName) {
        File dir = new File(dirName);
        if (dir.exists()) {
            return true;
        }
        return dir.mkdirs();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(configProperties);
        return sb.toString();
    }

    private void initLoggersList(String loggerName, String fileName, boolean special) {
        LoggersList.init(fileName, special);
        if (!special) {
            LoggersList.add(loggerName);
        }
    }

    public String getLogFileName(String loggerName, String logConfigFileName) throws FileNotFoundException, IOException {
        String loggerNameBak = loggerName;
        String logFileName = null;
        Properties props = new Properties();
        BufferedInputStream iStream = new BufferedInputStream(new FileInputStream(new File(logConfigFileName)));
        props.load(iStream);
        iStream.close();
        StringBuffer attributeBuffer = new StringBuffer();
        attributeBuffer.append(LOG_HANDLER_ATTRIBUTE).append(".");
        String handlerName = loggerName.indexOf(".search.") != -1 ? (String)props.get("debug.com.sun.portal.search.handler") : (String)props.get("debug.com.sun.portal.handler");
        attributeBuffer.append(handlerName).append(LOG_HANDLER_PATTERN_ATTRIBUTE);
        String attribute = attributeBuffer.toString();
        String value = props.getProperty(loggerName + attribute);
        while (value == null && !loggerName.equals(DEBUG_ROOT_LOGGER)) {
            loggerName = this.getParent(loggerName);
            value = props.getProperty(loggerName + attribute);
        }
        logFileName = value;
        if (props.containsKey(loggerName + LOG_SEPARATE_FILE_ATTRIBUTE)) {
            attribute = ".handler.java.util.logging.FileHandler.pattern";
            value = props.getProperty(loggerName + attribute);
            while (value == null && !loggerName.equals(DEBUG_ROOT_LOGGER)) {
                loggerName = this.getParent(loggerName);
                value = props.getProperty(loggerName + attribute);
            }
            logFileName = value;
        }
        StringBuffer buffer = new StringBuffer();
        if (logFileName != null) {
            buffer.append(logFileName);
            this.replaceInstanceId(buffer);
            this.replacePortalId(buffer);
            this.replaceSRAComponentType(buffer);
            this.replaceLoggerPattern(buffer, loggerNameBak);
            this.replacePrefix(buffer);
        }
        return buffer.toString();
    }

    public String getLogFileName(String loggerName) throws FileNotFoundException, IOException {
        String logConfigFileName = System.getProperty(LOG_CONFIG_FILENAME_PROPERTY);
        return this.getLogFileName(loggerName, logConfigFileName);
    }

    static {
        configPropertiesMap = Collections.synchronizedMap(new HashMap());
        PortalLogManager manager = new PortalLogManager();
        manager.init(DEBUG_ROOT_LOGGER);
        syncObject = new Object();
    }
}

