/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.log.common;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import sun.security.action.GetPropertyAction;

public class PortalLogFormatter
extends Formatter {
    private boolean printStackTrace = false;
    private ResourceBundle resourceBundle;
    private String resourceBundleName;
    private Date date = new Date();
    private static final String PRODUCT_VERSION = "SJS Portal Server";
    public static final String LINE_SEPARATOR = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    public static final String RECORD_BEGIN_MARKER = "[#|";
    public static final String RECORD_END_MARKER = "|#]";
    public static final String FIELD_SEPARATOR = "|";
    private static final String NV_PAIRS_SEPARATOR = "; ";
    public static final char DATE_TIME_DELIMITER = 'T';
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss.SSSZ";
    public static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    void setResourceBundleName(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
    }

    String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public synchronized String format(LogRecord record) {
        if (record.getResourceBundle() == null) {
            record.setResourceBundleName(this.getResourceBundleName());
            record.setResourceBundle(this.getResourceBundle());
        }
        StringBuffer recordBuffer = new StringBuffer(RECORD_BEGIN_MARKER);
        this.date.setTime(record.getMillis());
        dateFormatter.format(this.date, recordBuffer, new FieldPosition(0));
        recordBuffer.append(FIELD_SEPARATOR);
        recordBuffer.append(record.getLevel().getLocalizedName());
        recordBuffer.append(FIELD_SEPARATOR);
        recordBuffer.append(this.getProductId(record));
        recordBuffer.append(FIELD_SEPARATOR);
        recordBuffer.append(record.getLoggerName());
        recordBuffer.append(FIELD_SEPARATOR);
        recordBuffer.append(this.getNameValuePairs(record));
        recordBuffer.append(FIELD_SEPARATOR);
        recordBuffer.append(this.getMessage(record));
        recordBuffer.append(RECORD_END_MARKER);
        recordBuffer.append(LINE_SEPARATOR);
        recordBuffer.append(LINE_SEPARATOR);
        return recordBuffer.toString();
    }

    public synchronized void setPrintStackTrace(boolean value) {
        this.printStackTrace = value;
    }

    public synchronized boolean getPrintStackTrace() {
        return this.printStackTrace;
    }

    protected String getProductId(LogRecord record) {
        return PRODUCT_VERSION;
    }

    protected String getNameValuePairs(LogRecord record) {
        StringBuffer nvpairsBuffer = new StringBuffer("");
        nvpairsBuffer.append("ThreadID=" + record.getThreadID());
        nvpairsBuffer.append(NV_PAIRS_SEPARATOR);
        if (record.getSourceClassName() != null) {
            nvpairsBuffer.append("ClassName=" + record.getSourceClassName());
            nvpairsBuffer.append(NV_PAIRS_SEPARATOR);
        }
        if (record.getSourceMethodName() != null) {
            nvpairsBuffer.append("MethodName=" + record.getSourceMethodName());
            nvpairsBuffer.append(NV_PAIRS_SEPARATOR);
        }
        return nvpairsBuffer.toString();
    }

    protected String getMessage(LogRecord record) {
        String message = this.formatMessage(record);
        StringBuffer messageBuffer = new StringBuffer(message);
        Throwable throwable = record.getThrown();
        if (throwable != null && this.getPrintStackTrace()) {
            try {
                messageBuffer.append(LINE_SEPARATOR);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                throwable.printStackTrace(pw);
                pw.close();
                messageBuffer.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return messageBuffer.toString();
    }
}

