/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.log.common;

import com.sun.portal.log.common.ListLoggerFormatter;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class LoggersList {
    public static final String LOGGERS_LIST_FILE_PREFIX = ".loggersList.";
    public static final String LOGGERS_LIST_FILE_SUFFIX = ".%sraComponentType%instanceID";
    private static Hashtable fileToInstanceTable = new Hashtable();
    private String fileName;
    private static Logger listLogger;
    private String LOGGER_NAME = "com.sun.portal.loggers.list";
    private int LIMIT = 5000000;
    private int COUNT = 1;
    private static HashSet loggersSet;
    public static final String COMPONENT_PORTAL_INSTANCE = "portal";
    public static final String COMPONENT_GW_INSTANCE = "gateway";
    public static final String COMPONENT_NLP_INSTANCE = "nlproxy";
    public static final String COMPONENT_RWP_INSTANCE = "rwproxy";
    public static final String COMPONENT_SEARCH_INSTANCE = "search";
    public static final String COMPONENT_PAS_INSTANCE = "pas";
    public static final String COMPONENT_PSCONSOLE_INSTANCE = "psconsole";
    private static final String SRA_COMPONENT_TYPE_GATEWAY = "gateway";
    private static final String SRA_COMPONENT_TYPE_NLPROXY = "nlproxy";
    private static final String SRA_COMPONENT_TYPE_RWPROXY = "rwproxy";
    static /* synthetic */ Class class$com$sun$portal$log$common$ListLoggerFormatter;

    private LoggersList(String fileName, boolean special) {
        File configFile = new File(fileName);
        String folderName = configFile.getParent();
        this.fileName = folderName + File.separator + LOGGERS_LIST_FILE_PREFIX + configFile.getName() + (special ? "" : LoggersList.replaceToken(LOGGERS_LIST_FILE_SUFFIX));
        Logger tmpLogger = this.createLogger(this.fileName);
        this.configureLogger(this.fileName, tmpLogger, special);
        if (!special) {
            listLogger = tmpLogger;
        } else {
            this.addSearchLoggers(tmpLogger);
        }
    }

    private void addSearchLoggers(Logger tmpLogger) {
        tmpLogger.log(Level.CONFIG, "debug.com.sun.portal.search");
        tmpLogger.log(Level.CONFIG, "debug.com.sun.portal.search.rdm");
        tmpLogger.log(Level.CONFIG, "debug.com.sun.portal.search.rdmserver");
        tmpLogger.log(Level.CONFIG, "debug.com.sun.portal.search.rdmgr");
    }

    public static String getListLoggerFile(String componentName, String logConfigFileName, String instance) {
        StringBuffer loggerListFileName = new StringBuffer();
        File configFile = new File(logConfigFileName);
        String tempFileName = configFile.getParent();
        loggerListFileName.append(tempFileName);
        loggerListFileName.append(File.separator);
        loggerListFileName.append(LOGGERS_LIST_FILE_PREFIX);
        loggerListFileName.append(configFile.getName());
        if (COMPONENT_PORTAL_INSTANCE.equals(componentName)) {
            loggerListFileName.append(".");
            loggerListFileName.append(instance);
        } else if ("gateway".equals(componentName)) {
            loggerListFileName.append(".");
            loggerListFileName.append("gateway");
        } else if ("nlproxy".equals(componentName)) {
            loggerListFileName.append(".");
            loggerListFileName.append("nlproxy");
        } else if ("rwproxy".equals(componentName)) {
            loggerListFileName.append(".");
            loggerListFileName.append("rwproxy");
        } else if (!COMPONENT_SEARCH_INSTANCE.equals(componentName) && (COMPONENT_PAS_INSTANCE.equals(componentName) || COMPONENT_PSCONSOLE_INSTANCE.equals(componentName))) {
            loggerListFileName.append(".");
        }
        return loggerListFileName.toString();
    }

    private static String replaceToken(String srcString) {
        String dest = srcString;
        if (dest != null) {
            if (dest.indexOf("%instanceID") >= 0) {
                String instanceID = System.getProperty("com.sun.portal.instance.id", "");
                dest = Pattern.compile("%instanceID").matcher(dest).replaceAll(instanceID);
            }
            if (dest.indexOf("%sraComponentType") >= 0) {
                String sracomponentID = System.getProperty("com.sun.portal.sra.component.type", "");
                dest = Pattern.compile("%sraComponentType").matcher(dest).replaceAll(sracomponentID);
            }
        }
        return dest;
    }

    private void configureLogger(String filename, Logger tmpLogger, boolean special) {
        block9: {
            tmpLogger.setUseParentHandlers(false);
            tmpLogger.setLevel(Level.CONFIG);
            boolean ourHandler = false;
            try {
                Handler[] handlers = tmpLogger.getHandlers();
                if (handlers != null) {
                    StringBuffer buffer = new StringBuffer();
                    for (int i = 0; i < handlers.length; ++i) {
                        buffer.append(handlers[i].getClass().getName());
                        Formatter formatter = handlers[i].getFormatter();
                        String className = formatter.getClass().getName();
                        String tempClassName = (class$com$sun$portal$log$common$ListLoggerFormatter == null ? LoggersList.class$("com.sun.portal.log.common.ListLoggerFormatter") : class$com$sun$portal$log$common$ListLoggerFormatter).getName();
                        if (!className.equals(tempClassName)) {
                            try {
                                handlers[i].close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            tmpLogger.removeHandler(handlers[i]);
                            continue;
                        }
                        ourHandler = true;
                    }
                    if (!ourHandler) {
                        this.addHandler(filename, tmpLogger);
                    }
                    if (handlers.length > 1) {
                        System.err.println("More than one Handler:" + buffer);
                    }
                    break block9;
                }
                this.addHandler(filename, tmpLogger);
            }
            catch (IOException e) {
                System.err.println("Could not create loggers list. " + e.getMessage());
            }
        }
    }

    private void addHandler(String filename, Logger tmpLogger) throws IOException {
        boolean append = false;
        FileHandler fileHandler = new FileHandler(this.fileName, this.LIMIT, this.COUNT, append);
        fileHandler.setFormatter(new ListLoggerFormatter());
        fileHandler.setLevel(Level.CONFIG);
        tmpLogger.addHandler(fileHandler);
    }

    private Logger createLogger(String filename) {
        String loggerName = this.LOGGER_NAME + filename.replaceAll(File.separator, ".");
        return Logger.getLogger(loggerName);
    }

    public static LoggersList init(String fullPathConfigFileName, boolean special) {
        if (fileToInstanceTable.containsKey(fullPathConfigFileName)) {
            return (LoggersList)fileToInstanceTable.get(fullPathConfigFileName);
        }
        LoggersList instance = new LoggersList(fullPathConfigFileName, special);
        fileToInstanceTable.put(fullPathConfigFileName, instance);
        return instance;
    }

    public static LoggersList initSearch(String fullPathConfigFileName, boolean special) {
        if (fileToInstanceTable.containsKey(fullPathConfigFileName)) {
            return (LoggersList)fileToInstanceTable.get(fullPathConfigFileName);
        }
        LoggersList instance = new LoggersList(fullPathConfigFileName, special);
        fileToInstanceTable.put(fullPathConfigFileName, instance);
        return instance;
    }

    public static void add(String loggerName) {
        if (!loggersSet.contains(loggerName) && !loggerName.startsWith("debug.com.sun.portal.search")) {
            loggersSet.add(loggerName);
            if (listLogger != null) {
                listLogger.log(Level.CONFIG, loggerName);
            }
        }
    }

    public static void main(String[] args) {
        LoggersList.init("d://testconfig.properties", false);
        LoggersList.add("debug.com.sun.portal.log");
        LoggersList.add("debug.com.sun.portal.log");
        LoggersList.add("debug.com.sun.portal.log.common");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        loggersSet = new HashSet();
    }
}

