/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.log.common;

public class LoggerDetails {
    static final String DELIMITER = "\t";
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String[] handlers;
    private String loggerName;
    private String level;
    private String logToParent;
    private String stackTraceValue;
    private String pattern;

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public String[] getHandlers() {
        return this.handlers;
    }

    public void setHandlers(String[] handlers) {
        this.handlers = handlers;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String isLogToParent() {
        return this.logToParent;
    }

    public void setLogToParent(String logToParent) {
        this.logToParent = logToParent;
    }

    public String getStackTraceValue() {
        return this.stackTraceValue;
    }

    public void setStackTraceValue(String stackTraceValue) {
        this.stackTraceValue = stackTraceValue;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String format(boolean fileInfo, boolean useServerLogs) {
        StringBuffer loggerDetail = new StringBuffer();
        if (this.getLoggerName() != null) {
            loggerDetail.append(this.getLoggerName());
            loggerDetail.append(LINE_SEPARATOR);
        }
        if (this.getLevel() != null) {
            loggerDetail.append("Level=");
            loggerDetail.append(this.getLevel().toString());
        }
        if (fileInfo) {
            loggerDetail.append(DELIMITER);
            loggerDetail.append("Use Parent Handler=");
            loggerDetail.append(this.isLogToParent());
            StringBuffer handlersValue = new StringBuffer();
            boolean fileHandlerInUse = false;
            String[] handlers = this.getHandlers();
            if (!useServerLogs && handlers != null && handlers.length != 0) {
                for (int j = 0; j < handlers.length; ++j) {
                    if (handlers[j].equals("java.util.logging.FileHandler")) {
                        fileHandlerInUse = true;
                    }
                    handlersValue.append(handlers[j]);
                    if (j + 1 == handlers.length) continue;
                    handlersValue.append(",");
                }
            }
            loggerDetail.append(DELIMITER);
            if (this.getPattern() != null && fileHandlerInUse) {
                loggerDetail.append("Handler=");
                loggerDetail.append(handlersValue);
                loggerDetail.append(DELIMITER);
                loggerDetail.append("Logs to File=");
                loggerDetail.append(this.getPattern());
                if (this.getStackTraceValue() != null) {
                    loggerDetail.append(DELIMITER);
                    loggerDetail.append("Print Stacktrace=");
                    loggerDetail.append(this.getStackTraceValue());
                }
            }
        }
        return loggerDetail.toString();
    }
}

