/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.log.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class EnhancedProperties
extends Properties {
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private Hashtable keyToCommentsTable = new Hashtable();
    private Vector keySequence = new Vector();
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public EnhancedProperties() {
    }

    public EnhancedProperties(Properties props) {
        super(props);
    }

    public synchronized void load(InputStream inStream) throws IOException {
        inStream.mark(Integer.MAX_VALUE);
        super.load(inStream);
        inStream.reset();
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream, "8859_1"));
        StringBuffer prevComments = new StringBuffer();
        boolean SOF = true;
        boolean SOFReady = false;
        while (true) {
            String line;
            if ((line = in.readLine()) == null) {
                this.keyToCommentsTable.put("EOF", prevComments.toString());
                return;
            }
            if (line.length() > 0) {
                int valueIndex;
                int separatorIndex;
                int keyStart;
                int len = line.length();
                for (keyStart = 0; keyStart < len && whiteSpaceChars.indexOf(line.charAt(keyStart)) != -1; ++keyStart) {
                }
                if (keyStart == len) {
                    prevComments.append(line);
                    if (!SOF) continue;
                    SOFReady = true;
                    SOF = false;
                    continue;
                }
                char firstChar = line.charAt(keyStart);
                if (firstChar == '#' || firstChar == '!') {
                    if (SOFReady) {
                        this.keyToCommentsTable.put("SOF", prevComments.toString());
                        prevComments = new StringBuffer();
                        SOFReady = false;
                    }
                    prevComments.append(line).append("\n");
                }
                if (firstChar == '#' || firstChar == '!') continue;
                while (this.continueLine(line)) {
                    int startIndex;
                    String nextLine = in.readLine();
                    if (nextLine == null) {
                        nextLine = "";
                    }
                    String loppedLine = line.substring(0, len - 1);
                    for (startIndex = 0; startIndex < nextLine.length() && whiteSpaceChars.indexOf(nextLine.charAt(startIndex)) != -1; ++startIndex) {
                    }
                    nextLine = nextLine.substring(startIndex, nextLine.length());
                    line = new String(loppedLine + nextLine);
                    len = line.length();
                }
                for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
                    char currentChar = line.charAt(separatorIndex);
                    if (currentChar == '\\') {
                        ++separatorIndex;
                        continue;
                    }
                    if (keyValueSeparators.indexOf(currentChar) != -1) break;
                }
                for (valueIndex = separatorIndex; valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1; ++valueIndex) {
                }
                if (valueIndex < len && strictKeyValueSeparators.indexOf(line.charAt(valueIndex)) != -1) {
                    ++valueIndex;
                }
                while (valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1) {
                    ++valueIndex;
                }
                String key = line.substring(keyStart, separatorIndex);
                String value = separatorIndex < len ? line.substring(valueIndex, len) : "";
                key = this.loadConvert(key);
                value = this.loadConvert(value);
                this.put(key, value);
                this.keySequence.add(key);
                this.keyToCommentsTable.put(key, prevComments.toString());
                prevComments = new StringBuffer();
                continue;
            }
            prevComments.append(line).append("\n");
            if (!SOF) continue;
            SOF = false;
            SOFReady = true;
        }
    }

    public synchronized void store(OutputStream out, String header) throws IOException {
        String key;
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header != null) {
            EnhancedProperties.writeln(awriter, "#" + header);
        }
        if (this.keyToCommentsTable.containsKey("SOF")) {
            EnhancedProperties.writeComment(awriter, (String)this.keyToCommentsTable.get("SOF"));
        }
        for (int i = 0; i < this.keySequence.size(); ++i) {
            key = (String)this.keySequence.get(i);
            this.saveKeyValueWithComment(key, awriter);
        }
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (this.keySequence.contains(key)) continue;
            this.saveKeyValueWithComment(key, awriter);
        }
        EnhancedProperties.writeComment(awriter, (String)this.keyToCommentsTable.get("EOF"));
        awriter.flush();
    }

    private void saveKeyValueWithComment(String key, BufferedWriter awriter) throws IOException {
        String val = (String)this.get(key);
        if (val != null) {
            key = this.saveConvert(key, true);
            val = this.saveConvert(val, false);
            if (this.keyToCommentsTable.containsKey(key)) {
                EnhancedProperties.writeComment(awriter, (String)this.keyToCommentsTable.get(key));
            }
            EnhancedProperties.writeln(awriter, key + "=" + val);
        }
    }

    private static void writeComment(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(EnhancedProperties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(EnhancedProperties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(EnhancedProperties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(EnhancedProperties.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    private String loadConvert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    public static void main(String[] args) throws IOException {
        EnhancedProperties enProp = new EnhancedProperties();
        enProp.load(new BufferedInputStream(new FileInputStream(new File("e://sandhya//logging//platform1.conf"))));
        enProp.put("debug.com.sun.portal.kkkk", "gggg");
        enProp.put("debug.ttt.kkkk", "gggg");
        enProp.store(new BufferedOutputStream(new FileOutputStream(new File("e://sandhya//logging//platform1.conf"))), null);
    }
}

