<%
%><%@ page contentType="text/plain" %><%
%><%@taglib uri="/WEB-INF/jato.tld" prefix="jato"%><%
%><jato:useViewBean className="com.sun.identity.authentication.UI.LoginViewBean"><%

%><?xml version="1.0"?>
<%@ include file="docTypeDeclaration.jsp" %>
<vxml version="2.0">
  <link next="#goodBye">
    <grammar>
      [
        ( goodbye )
        ( exit )
        ( quit )
      ]
    </grammar>
  </link>

  <link next="#cancel">
    <grammar>
      [
        ( cancel )
      ]
    </grammar>
  </link>

<%
  String ServiceURI = (String) viewBean.getDisplayFieldValue(viewBean.SERVICE_URI);
%>
  <var name="promptRoot"        expr="'<%= ServiceURI %>/'"/>
  <var name="voice_root"        expr="'voice'" />
  <var name="locale"            expr="'en_US'" />
  <var name="prompts_directory" expr="'prompts'" />
  <var name="persona"           expr="'gary'" />
  <var name="promptPath"        expr="promptRoot + voice_root + '/' + locale + '/' + prompts_directory + '/' +  persona + '/'"/>
                    
  <var name="count"             expr="0"/>
  <var name="accountNumber"     expr="null"/>
  <var name="pinNumber"         expr="null"/>

  <%-- 2.1 Welcome --%>
  <form id="welcome">
    <block>
      <if cond="count &lt;= 2">
        <prompt bargein="false" cond="count == 0">
          <audio expr="promptPath + 'this_is_voice_portal_by_sun.wav'" />
        </prompt>

        <goto next="#getAccountNumber" />
      <else/>
        <goto next="#tooManyAttempts"/>
      </if>
    </block>
  </form>

  <%-- 2.2 Get Account Number --%>
  <form id="getAccountNumber">
    <field name="digits" type="digits?length=10">

      <%-- Ideally this link shouldn't be here, but to work around one Nuance bug we have this --%>
      <link event="help">
        <grammar>
          [
            ( help )
          ]
        </grammar>
      </link>

      <prompt cond="count == 0">
        <audio expr="promptPath + 'please_say_or_key_in_your_account_number.wav'" />
      </prompt>

      <prompt cond="count == 1">
        <audio expr="promptPath + 'sorry_but_the_the_pin.wav'"/>
        <audio>
          <say-as type="number:digits">		    
            <value expr="pinNumber"/>
	  </say-as>
        </audio>
        <audio expr="promptPath + 'doesnt_match_the_account_number.wav'"/>
        <audio>
          <say-as type="number:digits">		    
            <value expr="accountNumber"/>
	  </say-as>
        </audio>
        <audio expr="promptPath + 'if_i_got_that_wrong_please_say_or_key_in_the_corre.wav'"/>
      </prompt>

      <prompt cond="count == 2">
        <audio expr="promptPath + 'sorry_but_the_the_pin.wav'"/>
        <audio>
          <say-as type="number:digits">		    
            <value expr="pinNumber"/>
	  </say-as>
        </audio>
        <audio expr="promptPath + 'doesnt_match_the_account_number.wav'"/>
        <audio>
          <say-as type="number:digits">		    
            <value expr="accountNumber"/>
	  </say-as>
        </audio>
        <audio expr="promptPath + 'if_i_got_that_wrong_again_please_say_or_key_in_the.wav'" />
      </prompt>

      <noinput count="1">
        <audio expr="promptPath + 'sorry_i_didnt_hear_anything.wav'" />
        <audio expr="promptPath + 'please_say_or_key_in_your_account_number.wav'" />
      </noinput>

      <noinput count="2">
        <audio expr="promptPath + 'sorry_i_still_didnt_hear_anything.wav'" />
        <audio expr="promptPath + 'i_need_to_get_your_account_number_that_was_used_to.wav'" />
      </noinput>

      <noinput count="3">
        <goto next="#tooManyAttempts" />
      </noinput>

      <nomatch count="1">
        <audio expr="promptPath + 'sorry_i_didnt_get_that.wav'" />
        <audio expr="promptPath + 'please_say_or_key_in_your_account_number.wav'" />
      </nomatch>

      <nomatch count="2">
        <audio expr="promptPath + 'sorry_i_still_didnt_get_that.wav'" />
        <audio expr="promptPath + 'i_need_to_get_your_account_number_that_was_used_to.wav'" />
      </nomatch>

      <nomatch count="3">
        <goto next="#tooManyAttempts" />
      </nomatch>

      <help>
        <audio expr="promptPath + 'ok_heres_some_help.wav'" />
        <audio expr="promptPath + 'i_need_to_get_your_account_number_its_the_number_t.wav'" />
        <audio expr="promptPath + 'if_you_dont_remember_it_contact_the_system_adminis.wav'" />
      </help>

      <filled>
        <if cond="digits.length != 10">
          <clear namelist="digits"/>
        <else/>
          <assign name="accountNumber" expr="digits"/>
          <goto next="#getPinNumber" />
        </if>
      </filled>
    </field>
  </form>

  <%-- 2.2 Get Pin Number --%>
  <form id="getPinNumber">
    <block>
      <prompt count="1">
        <audio expr="promptPath + 'got_it.wav'" />
      </prompt>
    </block>

    <field name="digits" type="digits?length=4">
      <prompt count="1">
        <audio expr="promptPath + 'and_whats_your_pin.wav'" />
      </prompt>

      <prompt count="2">
        <audio expr="promptPath + 'and_what_was_your_pin.wav'" />
      </prompt>

      <noinput count="1">
        <audio expr="promptPath + 'sorry_i_didnt_hear_anything.wav'" />
        <audio expr="promptPath + 'please_say_or_key_in_your_pin.wav'" />
      </noinput>

      <noinput count="2">
        <audio expr="promptPath + 'sorry_i_still_didnt_hear_anything.wav'" />
        <audio expr="promptPath + 'please_enter_your_pin_or_for_more_information_say_.wav'" />
      </noinput>

      <noinput count="3">
        <goto next="#tooManyAttempts" />
      </noinput>

      <nomatch count="1">
        <audio expr="promptPath + 'sorry_i_didnt_get_that.wav'" />
        <audio expr="promptPath + 'please_say_or_key_in_your_pin.wav'" />
      </nomatch>

      <nomatch count="2">
        <audio expr="promptPath + 'sorry_i_still_didnt_get_that.wav'" />
        <audio expr="promptPath + 'again_please_enter_your_pin_or_for_more_informatio.wav'" />
      </nomatch>

      <nomatch count="3">
        <goto next="#tooManyAttempts" />
      </nomatch>

      <help>
        <audio expr="promptPath + 'ok_heres_some_help.wav'" />
        <audio expr="promptPath + 'to_sign_you_in_i_need_to_get_the_pin_assigned_to_y.wav'" />
        <audio expr="promptPath + 'if_you_dont_remember_it_contact_the_system_adminis.wav'" />
      </help>

      <filled>
        <if cond="digits.length != 4">
          <clear namelist="digits"/>
        <else/>
          <assign name="pinNumber" expr="digits"/>
          <goto next="#validateAccountAndPin" />
        </if>
      </filled>
    </field>
  </form>

  <%-- 2.4 Validate Account Number and PIN --%>
  <form id="validateAccountAndPin">
    <jato:tiledView name="tiledCallbacks"
      type="com.sun.identity.authentication.UI.CallBackTiledView">
      <jato:content name="textBox">
        <var name="IDToken<jato:text name="txtIndex"/>" expr="accountNumber"/>
      </jato:content>
      <jato:content name="password">
        <var name="IDToken<jato:text name="txtIndex"/>" expr="pinNumber"/>
      </jato:content>
    </jato:tiledView>

    <%-- take the user to the desktop now --%>
    <subdialog name="status" src="<jato:getDisplayFieldValue name="DefaultLoginURL" defaultValue="/amserver/UI/Login" fireDisplayEvents="true"/>" method="post"        namelist="<jato:tiledView name="tiledCallbacks" type="com.sun.identity.authentication.UI.CallBackTiledView"><jato:content name="textBox"> IDToken<jato:text name="txtIndex"/></jato:content><jato:content name="password"> IDToken<jato:text name="txtIndex"/></jato:content></jato:tiledView>">
      <param name="sPromptPath" expr="promptPath"/>

      <catch event="loginFailed">
        <assign name="count" expr="count+1"/>
        <goto next="#welcome"/>
      </catch>

      <catch event="exit">
        <goto next="#goodBye"/>
      </catch>

      <catch event="errors">
        <goto next="#tooManyErrors"/>
      </catch>

    </subdialog>
  </form>

  <%-- 2.6 Too many attempts --%>
  <form id="tooManyAttempts">
    <block>
      <prompt bargein="false">
        <audio expr="promptPath + 'sorry_but_i_wasnt_able_to_log_you_in_please_hang_u.wav'" />
      </prompt>

      <goto next="#goodBye" />
    </block>
  </form>

  <%-- 2.7 Canceled --%>
  <form id="cancel">
    <block>
      <prompt>
        <audio expr="promptPath + 'ok_canceled.wav'" />
      </prompt>

      <goto next="#welcome" />
    </block>
  </form>

  <%-- 2.8 Start Over --%>
  <form id="startOver">
    <block>
      <prompt>
        <audio expr="promptPath + 'ok_lets_start_over.wav'" />
      </prompt>

      <goto next="#welcome" />
    </block>
  </form>

  <%-- 2.9 Goodbye --%>
  <form id="goodBye">
    <block>
      <prompt>
        <audio expr="promptPath + 'thanks_for_calling_voice_portal_gbye.wav'" />
      </prompt>

      <goto next="#disconnect" />
    </block>
  </form>

  <%-- 2.10 Too many errors --%>
  <form id="tooManyErrors">
    <block>
      <prompt bargein="false">
        <audio expr="promptPath + 'sorry_but_i_wasnt_able_to_log_you_in_please_hang_u.wav'" />
      </prompt>

      <goto next="#goodBye" />
    </block>
  </form>

  <%-- 2.11 System Errors --%>
  <form id="recoverableSystemError">
    <block>
      <prompt bargein="false">
        <audio expr="promptPath + 'sorry_but_something_went_wrong_and_ill_need_to_sta.wav'" />
      </prompt>

      <goto next="#welcome"/>
    </block>
  </form>

  <%-- 2.11 System Errors --%>
  <form id="nonRecoverableSystemError">
    <block>
      <prompt bargein="false">
        <audio expr="promptPath + 'sorry_but_theres_a_problem_with_the_system_right_n.wav'" />
      </prompt>

      <goto next="#goodBye"/>
    </block>
  </form>

  <%-- 2.13 Disconnect --%>
  <form id="disconnect">
    <block>
      <exit/>
    </block>
  </form>
</vxml>    
</jato:useViewBean>
