/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.util;

import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.wizard.util.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class I18N {
    private static final String BASE_DIR = "i18n/";
    private static final String BASE_NAME = "i18n/wizardStrings";
    private static final String XML_BASE_NAME = "i18n/xmlValueStrings";
    private static final String ASSET_BASE_NAME = "i18n/assetStrings";
    private static final String COUNTRY_BASE_NAME = "i18n/countryStrings";
    private static final String LANGUAGE_BASE_NAME = "i18n/languageStrings";
    private static final String UNKNOWN_DEFAULT = "?unknown";
    private static final String EMPTY_DEFAULT = "";
    private static ResourceBundle resourceBundle;
    private static ResourceBundle xmlResourceBundle;
    private static ResourceBundle assetResourceBundle;
    private static ResourceBundle countryResourceBundle;
    private static ResourceBundle languageResourceBundle;
    private static Logger LOG;
    private static String i18nCompleteAssetInfoHtml;
    private static String i18nLimitedAssetInfoHtml;
    static /* synthetic */ Class class$com$sun$cns$basicreg$wizard$util$I18N;

    public static void setLocaleResources(Locale locale) {
        try {
            resourceBundle = ResourceBundle.getBundle(BASE_NAME, locale);
            xmlResourceBundle = ResourceBundle.getBundle(XML_BASE_NAME, locale);
            assetResourceBundle = ResourceBundle.getBundle(ASSET_BASE_NAME, locale);
            countryResourceBundle = ResourceBundle.getBundle(COUNTRY_BASE_NAME, locale);
            languageResourceBundle = ResourceBundle.getBundle(LANGUAGE_BASE_NAME, locale);
        }
        catch (Exception ex) {
            LOG.severe("ERROR - unable to get resource bundle");
        }
    }

    public static String getString(String key) {
        return I18N.getString(key, UNKNOWN_DEFAULT);
    }

    public static String getString(String key, String aDefault) {
        String i18nString = I18N.getBundleValue(resourceBundle, key);
        if (i18nString == null) {
            LOG.severe("ERROR - missing I18N key: " + key);
            return aDefault;
        }
        return i18nString;
    }

    public static String getFormattedString(String key, Object[] arguments) {
        String i18nString = I18N.getBundleValue(resourceBundle, key);
        if (i18nString == null) {
            LOG.severe("ERROR - missing I18N key: " + key);
            return UNKNOWN_DEFAULT;
        }
        return MessageFormat.format(i18nString, arguments);
    }

    public static Icon getIcon(String iconFileNameKey) {
        String i18nFileName = I18N.getString(iconFileNameKey, null);
        if (i18nFileName == null) {
            LOG.severe("ERROR - missing I18N file name key: " + iconFileNameKey);
            return null;
        }
        String i18nDescription = I18N.getString(iconFileNameKey + ".txt", EMPTY_DEFAULT);
        return I18N.getIcon(i18nFileName, i18nDescription);
    }

    public static Icon getIcon(String i18nFileName, String i18nDescription) {
        URL i18nImageURL = (class$com$sun$cns$basicreg$wizard$util$I18N == null ? (class$com$sun$cns$basicreg$wizard$util$I18N = I18N.class$("com.sun.cns.basicreg.wizard.util.I18N")) : class$com$sun$cns$basicreg$wizard$util$I18N).getResource(i18nFileName);
        if (i18nImageURL == null) {
            LOG.severe("ERROR - missing I18N gif file: " + i18nFileName);
            return null;
        }
        return new ImageIcon(i18nImageURL, i18nDescription);
    }

    public static String getXMLValueString(String key) {
        String i18nXMLValueString = null;
        if (key.equals("_i18n.common.license.legal.text.file.name") || key.equals("_i18n.common.privacy.text.file.name")) {
            String i18nFileName = I18N.getBundleValue(xmlResourceBundle, key);
            try {
                return Util.readEncodedResourceFile(i18nFileName, "UTF-8");
            }
            catch (FileNotFoundException ex) {
                LOG.severe("TOU file not found: " + i18nFileName);
                return EMPTY_DEFAULT;
            }
            catch (IOException ex) {
                LOG.severe("error reading TOU file: " + i18nFileName);
                return EMPTY_DEFAULT;
            }
            catch (Exception ex) {
                LOG.severe("unknown error accessing/reading TOU file: " + i18nFileName);
                return EMPTY_DEFAULT;
            }
        }
        i18nXMLValueString = I18N.getBundleValue(xmlResourceBundle, key);
        if (i18nXMLValueString == null) {
            LOG.severe("ERROR - missing I18N xml value key: " + key);
            return EMPTY_DEFAULT;
        }
        return i18nXMLValueString;
    }

    public static String getAssetValueString(String key) {
        String i18nAssetValueString = I18N.getBundleValue(assetResourceBundle, key);
        if (i18nAssetValueString == null) {
            LOG.severe("ERROR - missing I18N asset value key: " + key);
            return EMPTY_DEFAULT;
        }
        return i18nAssetValueString;
    }

    public static String getCountryValueString(String key, String defaultValue) {
        String i18nCountryValueString = I18N.getBundleValue(countryResourceBundle, key);
        if (i18nCountryValueString == null) {
            LOG.severe(" - missing I18N country value key: " + key);
            return defaultValue;
        }
        return i18nCountryValueString;
    }

    public static String getLanguageValueString(String key, String defaultValue) {
        String i18nLanguageValueString = I18N.getBundleValue(languageResourceBundle, key);
        if (i18nLanguageValueString == null) {
            LOG.severe("ERROR - missing I18N language value key: " + key);
            return defaultValue;
        }
        return i18nLanguageValueString;
    }

    public static String getI18NAssetInfoHTML(String htmlText, boolean isLimited) {
        LOG.info("is limited ? " + isLimited);
        if (isLimited && i18nLimitedAssetInfoHtml != null) {
            LOG.info("Returning cached limited asset info i18n html");
            return i18nLimitedAssetInfoHtml;
        }
        if (!isLimited && i18nCompleteAssetInfoHtml != null) {
            LOG.info("Returning cached complete asset info i18n html");
            return i18nCompleteAssetInfoHtml;
        }
        LOG.finest("HTML TEXT: " + htmlText);
        String i18nString = new String(htmlText);
        String[] assetLabels = isLimited ? CommonUtil.LIMITED_LBLS : CommonUtil.COMPLETE_LBLS;
        for (int i = 0; i < assetLabels.length; ++i) {
            LOG.finest(" **** TO REPLACE: " + assetLabels[i]);
            String assetLblRegExpr = assetLabels[i].replaceAll("\\.", "\\\\.");
            LOG.finest(" **** REG EXPR: " + assetLblRegExpr);
            String i18nAssetLbl = I18N.getAssetValueString(assetLabels[i]);
            LOG.finest(" **** I18N VALUE: " + i18nAssetLbl);
            i18nString = i18nString.replaceAll(assetLblRegExpr, i18nAssetLbl);
        }
        if (isLimited) {
            i18nLimitedAssetInfoHtml = i18nString;
        } else {
            i18nCompleteAssetInfoHtml = i18nString;
        }
        LOG.finest("I18N HTML: " + i18nString);
        return i18nString;
    }

    private static String getBundleValue(ResourceBundle resourceBundle, String key) {
        try {
            String value = resourceBundle.getString(key);
            return value;
        }
        catch (Exception ex) {
            LOG.severe("ERROR - missing value for key " + key);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        i18nCompleteAssetInfoHtml = null;
        i18nLimitedAssetInfoHtml = null;
        LOG = Logger.getLogger((class$com$sun$cns$basicreg$wizard$util$I18N == null ? (class$com$sun$cns$basicreg$wizard$util$I18N = I18N.class$("com.sun.cns.basicreg.wizard.util.I18N")) : class$com$sun$cns$basicreg$wizard$util$I18N).getName());
        Locale locale = Locale.getDefault();
        I18N.setLocaleResources(locale);
    }
}

