/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.swing;

import com.sun.cns.basicreg.wizard.swing.Utils;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioBoxPanel
extends JPanel {
    protected String m_currentValueStr;
    protected int m_numberButtons;
    protected String[] m_buttonLabels;
    protected JRadioButton[] m_radioButtons;
    protected ActionListener m_secondaryActionListener;
    protected boolean m_isVerticalOrientation;

    public RadioBoxPanel() {
        this(false);
    }

    public RadioBoxPanel(boolean isVerticalOrientation) {
        this.m_isVerticalOrientation = isVerticalOrientation;
        this.m_currentValueStr = "";
        this.m_secondaryActionListener = null;
    }

    public void addSecondaryActionListener(ActionListener secondaryActionListener) {
        this.m_secondaryActionListener = secondaryActionListener;
    }

    public void removeSecondaryActionListener() {
        this.m_secondaryActionListener = null;
    }

    public void addButtons(String[] buttonLabels) {
        this.m_numberButtons = buttonLabels.length;
        this.m_buttonLabels = new String[this.m_numberButtons];
        this.m_radioButtons = new JRadioButton[this.m_numberButtons];
        ButtonGroup buttonGroup = new ButtonGroup();
        if (this.m_isVerticalOrientation) {
            this.setLayout(new BoxLayout(this, 1));
        } else {
            this.setLayout(new FlowLayout(0));
        }
        for (int i = 0; i < this.m_numberButtons; ++i) {
            this.m_buttonLabels[i] = new String(buttonLabels[i]);
            this.m_radioButtons[i] = new JRadioButton(Utils.makeMultiLineLabel(buttonLabels[i]));
            this.m_radioButtons[i].setVerticalTextPosition(1);
            this.add(this.m_radioButtons[i]);
            buttonGroup.add(this.m_radioButtons[i]);
            this.m_radioButtons[i].addActionListener(new RadioBoxPanelButtonActionListener());
        }
    }

    public String getSelectedItem() {
        return this.m_currentValueStr;
    }

    public void setSelectedItem(String valueStr) {
        for (int i = 0; i < this.m_numberButtons; ++i) {
            if (!this.m_buttonLabels[i].equals(valueStr)) continue;
            this.m_radioButtons[i].doClick();
            break;
        }
    }

    public void setEnabled(boolean enabled) {
        for (int i = 0; i < this.m_numberButtons; ++i) {
            this.m_radioButtons[i].setEnabled(enabled);
        }
    }

    class RadioBoxPanelButtonActionListener
    implements ActionListener {
        RadioBoxPanelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            RadioBoxPanel.this.m_currentValueStr = Utils.undoMultiLineLabel(evt.getActionCommand());
            if (RadioBoxPanel.this.m_secondaryActionListener != null) {
                RadioBoxPanel.this.m_secondaryActionListener.actionPerformed(evt);
            }
        }
    }
}

