/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.swing;

import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.common.ProxyManager;
import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.Wizard;
import com.sun.cns.basicreg.wizard.swing.FormPanel;
import com.sun.cns.basicreg.wizard.swing.WizardFrame;
import com.sun.cns.basicreg.wizard.swing.WizardPanel;
import com.sun.cns.basicreg.wizard.util.I18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PopupDialog
extends JDialog {
    private static final String OK_BTN_LBL = I18N.getString("ok.btn");
    private static final String CANCEL_BTN_LBL = I18N.getString("cancel.btn");
    private static final String PROXY_ERROR_MESSAGE = I18N.getString("proxy.error.dialog.message");
    private static final String PROXY_ERROR_TITLE = I18N.getString("proxy.error.dialog.title");
    private WizardFrame ownerWizardFrame;
    private WizardPanel wizardPanel;
    private Form form;
    private static final Logger LOG = Logger.getLogger((class$com$sun$cns$basicreg$wizard$swing$PopupDialog == null ? (class$com$sun$cns$basicreg$wizard$swing$PopupDialog = PopupDialog.class$("com.sun.cns.basicreg.wizard.swing.PopupDialog")) : class$com$sun$cns$basicreg$wizard$swing$PopupDialog).getName());
    static /* synthetic */ Class class$com$sun$cns$basicreg$wizard$swing$PopupDialog;

    public PopupDialog(Dialog parentDialog, WizardFrame ownerWizardFrame, Wizard wizard, Form form, int formIndex) {
        super(parentDialog, wizard.getTitle(), false);
        this.ownerWizardFrame = ownerWizardFrame;
        this.form = form;
        this.getAccessibleContext().setAccessibleName(form.getTitle());
        this.getAccessibleContext().setAccessibleDescription(form.getTitle());
        this.buildMe(wizard, formIndex);
    }

    public boolean isNetworkErrorPopup() {
        String formIdentifier = this.form.getFormIdentifier();
        if (formIdentifier == null) {
            return false;
        }
        return formIdentifier.equals("network");
    }

    public boolean isProxyPopup() {
        String formIdentifier = this.form.getFormIdentifier();
        if (formIdentifier == null) {
            return false;
        }
        return formIdentifier.equals("proxy");
    }

    private void buildMe(Wizard wizard, int formIndex) {
        JPanel leftPanel = new JPanel();
        leftPanel.add(new JLabel("        "));
        this.getContentPane().add((Component)leftPanel, "West");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        this.wizardPanel = new WizardPanel(this, wizard, this.form, formIndex, this.ownerWizardFrame.getWizardDialog());
        centerPanel.add((Component)this.wizardPanel, "Center");
        if (this.isProxyPopup()) {
            this.restoreDisplayValues();
        }
        centerPanel.add((Component)this.buildButtonPanel(), "South");
        this.getContentPane().add((Component)centerPanel, "Center");
        JPanel rightPanel = new JPanel();
        rightPanel.add(new JLabel("        "));
        this.getContentPane().add((Component)rightPanel, "East");
        this.pack();
        Dimension sizeDimension = this.getSize();
        String formIdentifier = this.form.getFormIdentifier();
        if (formIdentifier.equalsIgnoreCase("assetinfo") || formIdentifier.equalsIgnoreCase("assetinfosubscription") || formIdentifier.equalsIgnoreCase("assetinfoenablePortal")) {
            this.setSize(600, 500);
        } else if (formIdentifier.equalsIgnoreCase("limitedassetinfo")) {
            this.setSize(450, 400);
        } else if (formIdentifier.equalsIgnoreCase("network")) {
            this.setSize(500, 350);
        } else {
            this.setSize(600, 500);
        }
        this.setLocation(new Point(300, 300));
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        String formIdentifier = this.form.getFormIdentifier();
        if (formIdentifier.equalsIgnoreCase("assetinfo") || formIdentifier.equalsIgnoreCase("assetinfosubscription") || formIdentifier.equalsIgnoreCase("assetinfoenablePortal") || formIdentifier.equalsIgnoreCase("limitedassetinfo") || formIdentifier.equalsIgnoreCase("autoreg")) {
            JButton okButton = new JButton(OK_BTN_LBL);
            okButton.addActionListener(new CancelButtonActionListener());
            okButton.setAlignmentY(0.0f);
            okButton.getAccessibleContext().setAccessibleName(OK_BTN_LBL);
            okButton.getAccessibleContext().setAccessibleDescription(OK_BTN_LBL);
            okButton.setMnemonic(75);
            buttonPanel.add(okButton);
            buttonPanel.add(Box.createHorizontalStrut(12));
        } else if (formIdentifier.equalsIgnoreCase("proxy")) {
            JButton okButton = new JButton(OK_BTN_LBL);
            okButton.addActionListener(new ProxyOkButtonActionListener());
            okButton.setAlignmentY(0.0f);
            okButton.getAccessibleContext().setAccessibleName("Apply my changes");
            okButton.getAccessibleContext().setAccessibleDescription(OK_BTN_LBL);
            okButton.setMnemonic(75);
            buttonPanel.add(okButton);
            buttonPanel.add(Box.createHorizontalStrut(12));
            JButton cancelButton = new JButton(CANCEL_BTN_LBL);
            cancelButton.addActionListener(new ProxyCancelButtonActionListener());
            cancelButton.setAlignmentY(0.0f);
            cancelButton.getAccessibleContext().setAccessibleName(CANCEL_BTN_LBL);
            cancelButton.getAccessibleContext().setAccessibleDescription(CANCEL_BTN_LBL);
            cancelButton.setMnemonic(67);
            buttonPanel.add(cancelButton);
            buttonPanel.add(Box.createHorizontalStrut(12));
        } else if (formIdentifier.equalsIgnoreCase("network")) {
            JButton cancelButton = new JButton(CANCEL_BTN_LBL);
            cancelButton.addActionListener(new CancelButtonActionListener());
            cancelButton.setAlignmentY(0.0f);
            cancelButton.getAccessibleContext().setAccessibleName(CANCEL_BTN_LBL);
            cancelButton.getAccessibleContext().setAccessibleDescription(CANCEL_BTN_LBL);
            cancelButton.setMnemonic(67);
            buttonPanel.add(cancelButton);
            buttonPanel.add(Box.createHorizontalStrut(12));
        }
        return buttonPanel;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201 && this.isProxyPopup()) {
            this.restoreDisplayValues();
        }
        super.processWindowEvent(windowEvent);
    }

    private void storeProxyInCCR(String key, String value) {
        block2: {
            try {
                Class<?> wizardClazz = Class.forName("com.sun.cns.basicreg.adapter.CCRAdapter");
                Object[] initArgs = new Object[]{key, value};
                Method setMethod = wizardClazz.getMethod("setValueThroughCSMAuth", Class.forName("java.lang.String"), Class.forName("java.lang.String"));
                setMethod.invoke(null, initArgs);
            }
            catch (Exception e) {
                LOG.severe(e.toString());
                LOG.severe(CommonUtil.getStackTrace((Throwable)e));
                if (!(e instanceof InvocationTargetException)) break block2;
                LOG.severe("Wrapped Target Exception:\n");
                Throwable targetThrowable = e.getCause();
                LOG.severe(targetThrowable != null ? CommonUtil.getStackTrace((Throwable)targetThrowable) : "?");
            }
        }
    }

    private void restoreDisplayValues() {
        FormPanel formPanel = this.wizardPanel.getFormPanel();
        ProxyManager proxyManager = ProxyManager.getInstance();
        Properties props = proxyManager.getProxySettings();
        if (props.getProperty("http.proxySet") != null && props.getProperty("http.proxySet").equals("true")) {
            formPanel.setFieldValue("enable", "true");
        } else {
            formPanel.setFieldValue("enable", "false");
        }
        formPanel.setFieldValue("server", props.getProperty("http.proxyHost"));
        formPanel.setFieldValue("port", props.getProperty("http.proxyPort"));
        String proxyUser = props.getProperty("http.proxyUser");
        if (proxyUser != null && proxyUser.trim().length() > 0) {
            formPanel.setFieldValue("proxyAuth", "true");
        } else {
            formPanel.setFieldValue("proxyAuth", "false");
        }
        formPanel.setFieldValue("proxyUser", props.getProperty("http.proxyUser"));
        formPanel.setFieldValue("proxyPass", props.getProperty("http.proxyPassword"));
        this.wizardPanel.validateResponses();
        formPanel.layoutLabelsAndComponents();
    }

    public WizardPanel getWizardPanel() {
        return this.wizardPanel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ProxyOkButtonActionListener
    implements ActionListener {
        ProxyOkButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info("  ++++  POPUP PROXY OK BUTTON");
            boolean validResponses = PopupDialog.this.wizardPanel.validateResponses();
            FormPanel formPanel = PopupDialog.this.wizardPanel.getFormPanel();
            formPanel.layoutLabelsAndComponents();
            if (!validResponses) {
                PopupDialog.this.wizardPanel.refreshMe();
                return;
            }
            String proxyEnableValue = formPanel.getFieldValue("enable");
            String proxyAuthValue = formPanel.getFieldValue("proxyAuth");
            Properties proxyProperties = new Properties();
            proxyProperties.setProperty("http.proxySet", proxyEnableValue.equals("true") ? "true" : "false");
            proxyProperties.setProperty("http.proxyHost", formPanel.getFieldValue("server"));
            proxyProperties.setProperty("http.proxyPort", formPanel.getFieldValue("port"));
            proxyProperties.setProperty("http.proxyUser", formPanel.getFieldValue("proxyUser"));
            proxyProperties.setProperty("http.proxyPassword", formPanel.getFieldValue("proxyPass"));
            proxyProperties.setProperty("https.proxySet", proxyEnableValue.equals("true") ? "true" : "false");
            proxyProperties.setProperty("https.proxyHost", formPanel.getFieldValue("server"));
            proxyProperties.setProperty("https.proxyPort", formPanel.getFieldValue("port"));
            proxyProperties.setProperty("https.proxyUser", formPanel.getFieldValue("proxyUser"));
            proxyProperties.setProperty("https.proxyPassword", formPanel.getFieldValue("proxyPass"));
            ProxyManager proxyManager = ProxyManager.getInstance();
            boolean isProxyOk = proxyManager.setProxySettings(proxyProperties);
            if (isProxyOk) {
                PopupDialog.this.wizardPanel.setResponses();
                PopupDialog.this.setVisible(false);
                PopupDialog.this.ownerWizardFrame.refreshWizardDialog();
                PopupDialog.this.storeProxyInCCR("cns.httpproxy.ipaddr", formPanel.getFieldValue("server"));
                PopupDialog.this.storeProxyInCCR("cns.httpproxy.port", formPanel.getFieldValue("port"));
                if (formPanel.getFieldValue("proxyUser") != null && !formPanel.getFieldValue("proxyUser").trim().equals("")) {
                    PopupDialog.this.storeProxyInCCR("cns.httpproxy.auth", formPanel.getFieldValue("proxyUser") + ":" + formPanel.getFieldValue("proxyPass"));
                } else {
                    PopupDialog.this.storeProxyInCCR("cns.httpproxy.auth", "");
                }
                return;
            }
            LOG.info(" PROXY CONNECTION FAILED");
            JOptionPane.showMessageDialog(PopupDialog.this, PROXY_ERROR_MESSAGE, PROXY_ERROR_TITLE, 0);
            PopupDialog.this.wizardPanel.refreshMe();
        }
    }

    class ProxyCancelButtonActionListener
    implements ActionListener {
        ProxyCancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info("  ++++  PROXY POPUP CANCEL BUTTON");
            PopupDialog.this.restoreDisplayValues();
            PopupDialog.this.setVisible(false);
            PopupDialog.this.ownerWizardFrame.refreshWizardDialog();
        }
    }

    class CancelButtonActionListener
    implements ActionListener {
        CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info("  ++++  POPUP CANCEL BUTTON");
            PopupDialog.this.setVisible(false);
            PopupDialog.this.ownerWizardFrame.refreshWizardDialog();
        }
    }
}

