/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.cli;

import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.SelectWidget;
import com.sun.cns.basicreg.wizard.Widget;
import com.sun.cns.basicreg.wizard.WidgetType;
import com.sun.cns.basicreg.wizard.cli.CmdLineWidget;

public class CmdLineSelectWidget
extends CmdLineWidget
implements Widget,
SelectWidget {
    protected boolean selected;
    private String selectType;
    private String groupId;
    private static final int numberOfTimes = 4;
    private boolean onClickNext;
    private String slaveId;
    private String slaveValue;
    private String nextFormIdIfSelected = null;
    private boolean continueCheck = false;

    public CmdLineSelectWidget() {
        this.text = "";
        this.selected = false;
        this.onClickNext = false;
    }

    public CmdLineSelectWidget(String text) {
        this.text = text;
        this.selected = false;
        this.onClickNext = false;
    }

    public CmdLineSelectWidget(Form form, String text, String reload, String id, String required, String editable, String validPattern, String patternError, String validMatch, String matchError, String note, String fontSize, String fontStyle, String newRow, String fontColor, String slaveId, String slaveValue, String continueCheck, String selectType, String groupId, String selected, String nextFormIdIfSelected, String s508Name, String s508Desc, String mnemonic) {
        this.form = form;
        this.text = text;
        this.reload = reload != null && reload.equalsIgnoreCase("yes");
        this.id = id;
        this.required = required != null && required.equalsIgnoreCase("yes");
        this.editable = editable == null || editable.equalsIgnoreCase("yes");
        this.validPattern = validPattern;
        this.patternError = patternError;
        this.validMatch = validMatch;
        this.matchError = matchError;
        this.note = note;
        this.fontStyle = fontStyle;
        this.fontSize = fontSize != null ? Integer.parseInt(fontSize) : 0;
        this.newRow = newRow == null || !newRow.equalsIgnoreCase("no");
        this.fontColor = fontColor;
        this.slaveId = slaveId;
        this.slaveValue = slaveValue;
        boolean bl = this.continueCheck = continueCheck != null && continueCheck.equalsIgnoreCase("yes");
        this.selectType = selectType != null ? (selectType.equalsIgnoreCase("radio") ? "radio" : "check") : "check";
        this.groupId = groupId;
        this.selected = selected != null && selected.equalsIgnoreCase("yes");
        this.nextFormIdIfSelected = nextFormIdIfSelected;
        this.s508Name = s508Name;
        this.s508Desc = s508Desc;
        this.mnemonic = mnemonic;
    }

    public WidgetType getType() {
        return WidgetType.SELECT;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getSelectType() {
        return this.selectType;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getSlaveId() {
        return this.slaveId;
    }

    public String getSlaveValue() {
        if (this.slaveValue == null) {
            return null;
        }
        int widFlagIndex = this.slaveValue.indexOf("$WID:");
        if (widFlagIndex == -1) {
            return this.slaveValue;
        }
        if (widFlagIndex + "$WID:".length() >= this.slaveValue.length()) {
            return null;
        }
        String widgetId = this.slaveValue.substring(widFlagIndex + "$WID:".length());
        Widget widget = this.form.getWidgetById(widgetId);
        return widget.getText();
    }

    public String getNextFormIdIfSelected() {
        return this.nextFormIdIfSelected;
    }

    public boolean isContinueCheck() {
        return this.continueCheck;
    }

    public void draw() {
        this.draw(4);
    }

    public void draw(int times) {
        StringBuffer output = new StringBuffer();
        output = this.repeat(output, times);
        if (this.required) {
            output.append("*");
        }
        output.append("[");
        if (this.isSelected()) {
            output.append("x");
        } else {
            output.append(" ");
        }
        output.append("]");
        output.append(" ");
        output.append(this.getText());
        output.append("\n");
        System.out.print(output.toString());
    }

    private StringBuffer repeat(StringBuffer output, int times) {
        for (int i = 0; i < times; ++i) {
            output.append(" ");
        }
        return output;
    }
}

