/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util;

import com.sun.management.viperimpl.util.UnixDomainSocketInputStream;
import com.sun.management.viperimpl.util.UnixDomainSocketOutputStream;
import com.sun.management.viperimpl.util.UnixUtilities;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;

public class UnixDomainSocket {
    protected File file;
    protected FileDescriptor fd = new FileDescriptor();

    private native void createSocket();

    private native void doBind();

    private native void doAccept(UnixDomainSocket var1);

    private native void doConnect();

    private native void doClose();

    private native int doAvailable();

    public UnixDomainSocket() throws IOException {
        this.createSocket();
    }

    public UnixDomainSocket(File file) throws IOException {
        this();
        this.file = file;
    }

    public void connect() throws IOException {
        this.doConnect();
    }

    public void bind() throws IOException {
        this.doBind();
    }

    public UnixDomainSocket accept() throws IOException {
        UnixDomainSocket newsock = new UnixDomainSocket();
        newsock.close();
        this.doAccept(newsock);
        return newsock;
    }

    public InputStream getInputStream() throws IOException {
        return new UnixDomainSocketInputStream(this);
    }

    public OutputStream getOutputStream() throws IOException {
        return new UnixDomainSocketOutputStream(this);
    }

    public FileDescriptor getFileDescriptor() {
        return this.fd;
    }

    public int available() throws IOException {
        return this.doAvailable();
    }

    public void close() throws IOException {
        this.doClose();
    }

    public static void main(String[] argv) {
        if (argv.length < 1) {
            System.out.println("Require at least a filename argument.");
            System.exit(1);
        }
        String filename = argv[0];
        try {
            boolean num = false;
            File file = new File(filename);
            UnixDomainSocket master = new UnixDomainSocket(file);
            master.bind();
            System.out.println("Bound to file.  Becoming server.");
            boolean done = false;
            while (!done) {
                UnixDomainSocket client = master.accept();
                InputStream in = client.getInputStream();
                int avail = 0;
                while ((avail = in.available()) <= 0) {
                }
                byte[] b = new byte[avail];
                in.read(b);
                String str = new String(b);
                if (str.equals("quit")) {
                    System.out.println("Terminating server");
                    done = true;
                } else {
                    System.out.println(new String(b));
                }
                client.close();
            }
            master.close();
            file.delete();
            System.exit(0);
        }
        catch (BindException e) {
            System.out.println("Can't bind to file.  Becoming client.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        try {
            UnixDomainSocket client = new UnixDomainSocket(new File(filename));
            client.connect();
            OutputStream out = client.getOutputStream();
            if (argv.length > 1) {
                out.write(argv[1].getBytes());
            } else {
                out.write("hello".getBytes());
            }
            client.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        UnixUtilities.isLoaded();
    }
}

