/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util;

import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viper.util.VConstraints;
import com.sun.management.viperimpl.util.FileChooser;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class TextLogger {
    private LogScrollPane logScrollPane;
    protected JLabel logViewerCaption;
    protected JButton clearButton;
    protected JButton copyButton;
    protected JButton selectAllButton;
    protected JCheckBox loggingCheckBox;
    protected JTextField logFilename;
    protected JLabel logFileStatusLabel;
    protected JButton browseButton;
    private FileChooser fileChooser = null;
    private String loggerTitle;
    private String fileBrowserExtension;
    private String fileBrowserDescription;
    private String fileBrowserTitle;
    private String fileBrowserSelectButtonText;
    private int fileBrowserSelectButtonMnemonic;
    private static String selectedFilename;
    private boolean loggingOn = false;
    private Component parent;
    private Object[] buttonText;
    private Object[] buttonText2;
    private Object[] buttonText3;
    private String appendText;
    private String overwriteText;
    private String cancelText;
    private String tryagainText;
    private String selectanotherfileText;
    private String overwriteConfirm;
    private String cantWriteConfirm;
    private String invalidFileConfirm;
    private String fileNotFoundConfirm;
    private String cantWriteToFileConfirm;
    private String fileErrorTitle;

    public TextLogger(Component parent, JPanel textLoggerPanel) {
        this.parent = parent;
        this.appendText = ImplResourceManager.getString("APPEND_BUTTON");
        this.overwriteText = ImplResourceManager.getString("OVERWRITE_BUTTON");
        this.cancelText = ImplResourceManager.getString("CANCEL_BUTTON");
        this.tryagainText = ImplResourceManager.getString("TRY_AGAIN_BUTTON");
        this.selectanotherfileText = ImplResourceManager.getString("SELECT_ANOTHER_FILE_BUTTON");
        this.buttonText = new Object[3];
        this.buttonText[0] = this.appendText;
        this.buttonText[1] = this.overwriteText;
        this.buttonText[2] = this.cancelText;
        this.buttonText2 = new Object[2];
        this.buttonText2[0] = this.tryagainText;
        this.buttonText2[1] = this.cancelText;
        this.buttonText3 = new Object[3];
        this.buttonText3[0] = this.tryagainText;
        this.buttonText3[1] = this.selectanotherfileText;
        this.buttonText3[2] = this.cancelText;
        this.overwriteConfirm = ImplResourceManager.getString("OverwriteConfirm");
        this.cantWriteConfirm = ImplResourceManager.getString("CantwriteConfirm");
        this.invalidFileConfirm = ImplResourceManager.getString("InvalidfileConfirm");
        this.fileNotFoundConfirm = ImplResourceManager.getString("FilenotfoundConfirm");
        this.cantWriteToFileConfirm = ImplResourceManager.getString("CantwritetofileConfirm");
        this.fileErrorTitle = ImplResourceManager.getString("FileerrorTitle");
        this.logViewerCaption = new JLabel(this.loggerTitle);
        this.logScrollPane = new LogScrollPane();
        this.logScrollPane.setPreferredSize(new Dimension(400, 250));
        this.selectAllButton = new JButton();
        this.selectAllButton.setText(ImplResourceManager.getString("SELECTALL_BUTTON"));
        this.selectAllButton.setMnemonic(ImplResourceManager.getString("SELECTALL_BUTTON_mnemonic").charAt(0));
        this.selectAllButton.setMargin(new Insets(1, 4, 1, 4));
        this.selectAllButton.setEnabled(false);
        Dimension d1 = this.selectAllButton.getPreferredSize();
        this.selectAllButton.setPreferredSize(d1);
        this.selectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLogger.this.logScrollPane.selectAll();
            }
        });
        this.copyButton = new JButton();
        this.copyButton.setText(ImplResourceManager.getString("COPY_BUTTON"));
        this.copyButton.setMnemonic(ImplResourceManager.getString("COPY_BUTTON_mnemonic").charAt(0));
        this.copyButton.setMargin(new Insets(1, 4, 1, 4));
        this.copyButton.setEnabled(false);
        d1 = this.copyButton.getPreferredSize();
        this.copyButton.setPreferredSize(d1);
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLogger.this.logScrollPane.copy();
            }
        });
        this.clearButton = new JButton();
        this.clearButton.setText(ImplResourceManager.getString("CLEAR_BUTTON"));
        this.clearButton.setMnemonic(ImplResourceManager.getString("CLEAR_BUTTON_mnemonic").charAt(0));
        this.clearButton.setMargin(new Insets(1, 4, 1, 4));
        d1 = this.clearButton.getPreferredSize();
        this.clearButton.setPreferredSize(d1);
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLogger.this.clearText();
            }
        });
        JPanel buttonSubPanel = new JPanel();
        buttonSubPanel.setLayout(new GridBagLayout());
        VConstraints.constrain((Container)buttonSubPanel, (Component)this.selectAllButton, (int)-1, (int)0, (int)1, (int)1, (int)0, (int)5, (int)0, (int)0);
        VConstraints.constrain((Container)buttonSubPanel, (Component)this.copyButton, (int)-1, (int)0, (int)1, (int)1, (int)0, (int)5, (int)0, (int)0);
        VConstraints.constrain((Container)buttonSubPanel, (Component)this.clearButton, (int)-1, (int)0, (int)1, (int)1, (int)0, (int)5, (int)0, (int)0);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        VConstraints.constrain((Container)buttonPanel, (Component)buttonSubPanel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (int)0, (int)0, (int)5, (int)0);
        separatorPanel separatorLine = new separatorPanel();
        separatorLine.setBorder(new EmptyBorder(2, 2, 2, 2));
        JPanel logFilePanel = new JPanel();
        logFilePanel.setLayout(new GridBagLayout());
        this.loggingCheckBox = new JCheckBox();
        this.loggingCheckBox.setMargin(new Insets(1, 1, 1, 1));
        this.loggingCheckBox.setText(ImplResourceManager.getString("LogtofileText"));
        this.loggingCheckBox.setMnemonic(ImplResourceManager.getString("LogtofileText_mnemonic").charAt(0));
        this.loggingCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLogger.this.loggingOn();
                if (TextLogger.this.loggingOn && !TextLogger.this.checkLogFile(TextLogger.this.logFilename.getText())) {
                    TextLogger.this.loggingCheckBox.setSelected(false);
                    TextLogger.this.loggingOn();
                }
            }
        });
        VConstraints.constrain((Container)logFilePanel, (Component)this.loggingCheckBox, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)5, (int)0, (int)0, (int)0);
        this.logFilename = new JTextField();
        this.logFilename.setText(ImplResourceManager.getString("DefaultFilename"));
        this.logFilename.setMargin(new Insets(2, 2, 2, 2));
        this.logFilename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (TextLogger.this.checkLogFile(TextLogger.this.logFilename.getText())) {
                    TextLogger.this.loggingCheckBox.setSelected(true);
                    TextLogger.this.loggingOn();
                } else {
                    TextLogger.this.loggingCheckBox.setSelected(false);
                    TextLogger.this.loggingOn();
                }
            }
        });
        VConstraints.constrain((Container)logFilePanel, (Component)this.logFilename, (int)1, (int)0, (int)2, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)5, (int)0, (int)0, (int)0);
        this.logFileStatusLabel = new JLabel();
        this.logFileStatusLabel.setText(ImplResourceManager.getString("NotLoggingStatusLabel"));
        VConstraints.constrain((Container)logFilePanel, (Component)this.logFileStatusLabel, (int)0, (int)1, (int)2, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)5, (int)0, (int)0, (int)0);
        this.browseButton = new JButton();
        this.browseButton.setText(ImplResourceManager.getString("BROWSE_BUTTON"));
        this.browseButton.setMnemonic(ImplResourceManager.getString("BROWSE_BUTTON_mnemonic").charAt(0));
        this.browseButton.setMargin(new Insets(1, 4, 1, 4));
        Dimension d2 = this.browseButton.getPreferredSize();
        this.browseButton.setPreferredSize(d2);
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextLogger.this.doShowFileBrowser();
            }
        });
        VConstraints.constrain((Container)logFilePanel, (Component)this.browseButton, (int)1, (int)1, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (int)5, (int)0, (int)0, (int)0);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridBagLayout());
        VConstraints.constrain((Container)controlPanel, (Component)buttonPanel, (int)0, (int)-1, (int)1, (int)1, (int)1, (int)10, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        VConstraints.constrain((Container)controlPanel, (Component)separatorLine, (int)0, (int)-1, (int)1, (int)1, (int)1, (int)10, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        VConstraints.constrain((Container)controlPanel, (Component)logFilePanel, (int)0, (int)-1, (int)1, (int)1, (int)1, (int)10, (double)1.0, (double)1.0, (int)5, (int)0, (int)0, (int)0);
        textLoggerPanel.add((Component)this.logViewerCaption, "North");
        textLoggerPanel.add((Component)this.logScrollPane, "Center");
        textLoggerPanel.add((Component)controlPanel, "South");
    }

    public void loggingOn() {
        if (this.getLogFile().equals("")) {
            this.logFileStatusLabel.setText(ImplResourceManager.getString("NotLoggingStatusLabel"));
            this.loggingCheckBox.setSelected(false);
            this.doShowFileBrowser();
        } else if (this.loggingCheckBox.isSelected()) {
            this.logFileStatusLabel.setText(ImplResourceManager.getString("LoggingStatusLabel"));
            this.loggingOn = true;
        } else {
            this.logFileStatusLabel.setText(ImplResourceManager.getString("NotLoggingStatusLabel"));
            this.loggingOn = false;
        }
    }

    public void setText(String text) {
        this.clearText();
        this.appendText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void appendText(String text) {
        LogScrollPane logScrollPane = this.logScrollPane;
        synchronized (logScrollPane) {
            this.logScrollPane.writeText(text);
        }
        this.logToFile(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearText() {
        LogScrollPane logScrollPane = this.logScrollPane;
        synchronized (logScrollPane) {
            this.logScrollPane.writeText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        LogScrollPane logScrollPane = this.logScrollPane;
        synchronized (logScrollPane) {
            return this.logScrollPane.getText();
        }
    }

    public void doShowFileBrowser() {
        int returnVal;
        if (this.fileChooser == null) {
            this.fileChooser = new FileChooser();
            this.fileChooser.addExtension(this.fileBrowserExtension);
            this.fileChooser.setDescription(this.fileBrowserDescription);
            this.fileChooser.setTitle(this.fileBrowserTitle);
            this.fileChooser.setApproveButtonText(this.fileBrowserSelectButtonText);
            this.fileChooser.setApproveButtonMnemonic(this.fileBrowserSelectButtonMnemonic);
        }
        if ((returnVal = this.fileChooser.showDialog(this.parent, null)) == 0 && this.fileChooser.getSelectedFile() != null && this.fileChooser.getSelectedFile().getName() != null) {
            String sFileName = this.fileChooser.getCurrentDirectory() + "/" + this.fileChooser.getSelectedFile().getName();
            if (this.checkLogFile(sFileName)) {
                this.loggingCheckBox.setSelected(true);
                this.loggingOn();
            } else {
                this.loggingCheckBox.setSelected(false);
                this.loggingOn();
            }
        }
    }

    public void setLoggerTitle(String s) {
        this.loggerTitle = s;
        this.logViewerCaption.setText(this.loggerTitle);
    }

    public void setFileBrowserExtension(String s) {
        this.fileBrowserExtension = s;
    }

    public void setFileBrowserDescription(String s) {
        this.fileBrowserDescription = s;
    }

    public void setFileBrowserTitle(String s) {
        this.fileBrowserTitle = s;
    }

    public void setFileBrowserSelectButton(String s, int mnemonic) {
        this.fileBrowserSelectButtonText = s;
        this.fileBrowserSelectButtonMnemonic = mnemonic;
    }

    public void setDefaultFileName(String s) {
        this.setLogFile(s);
    }

    public void setLogFile(String sFile) {
        this.logFilename.setText(sFile);
        selectedFilename = sFile;
    }

    public String getLogFile() {
        return this.logFilename.getText();
    }

    public boolean checkLogFile(String sFile) {
        boolean goodfile = false;
        File file = new File(sFile);
        if (file.exists() && file.isFile()) {
            int d = JOptionPane.showOptionDialog(this.parent, sFile + "\n" + this.overwriteConfirm, this.fileErrorTitle, 1, 3, null, this.buttonText, this.buttonText[0]);
            if (d == 0) {
                goodfile = true;
            } else if (d == 1) {
                file.delete();
                goodfile = true;
            } else {
                goodfile = d == 2 ? false : false;
            }
        } else if (file.exists() && !file.isFile()) {
            int dd = JOptionPane.showOptionDialog(this.parent, sFile + "\n" + this.invalidFileConfirm, this.fileErrorTitle, 0, 3, null, this.buttonText2, this.buttonText2[0]);
            if (dd == 0) {
                goodfile = false;
                this.checkLogFile(sFile);
            } else {
                goodfile = dd == 1 ? false : false;
            }
        } else {
            goodfile = true;
        }
        if (goodfile) {
            this.setLogFile(sFile);
        }
        return goodfile;
    }

    private void logToFile(String text) {
        block5: {
            if (this.loggingOn && selectedFilename != null && !selectedFilename.equals("")) {
                try {
                    FileWriter writer = new FileWriter(selectedFilename, true);
                    writer.write(text);
                    writer.flush();
                    writer.close();
                }
                catch (Exception e) {
                    int ddd = JOptionPane.showOptionDialog(this.parent, selectedFilename + "\n" + this.cantWriteToFileConfirm, this.fileErrorTitle, 1, 3, null, this.buttonText3, this.buttonText3[0]);
                    if (ddd == 0) {
                        this.logToFile(text);
                    }
                    if (ddd == 1) {
                        this.loggingCheckBox.setSelected(false);
                        this.doShowFileBrowser();
                    }
                    if (ddd != 2) break block5;
                    this.loggingCheckBox.setSelected(false);
                }
            }
        }
    }

    private class LogScrollPane
    extends JScrollPane {
        private JTextArea logPane;
        private String textLog;

        public LogScrollPane() {
            super(20, 30);
            this.textLog = "";
            this.logPane = new JTextArea();
            this.logPane.setEditable(false);
            this.setViewportView(this.logPane);
            this.logPane.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    String s = LogScrollPane.this.logPane.getSelectedText();
                    if (s != null && s.length() > 0) {
                        TextLogger.this.copyButton.setEnabled(true);
                    } else {
                        TextLogger.this.copyButton.setEnabled(false);
                    }
                }
            });
        }

        public JScrollBar createVerticalScrollBar() {
            return new LogScrollBar(1);
        }

        public void writeText(String text) {
            this.textLog = text != null && text.length() > 0 ? this.textLog + text : "";
            this.logPane.setText(this.textLog);
            TextLogger.this.selectAllButton.setEnabled(this.textLog.length() != 0);
        }

        public String getText() {
            return this.logPane.getText();
        }

        public void selectAll() {
            this.logPane.selectAll();
        }

        public void copy() {
            this.logPane.copy();
        }

        private class LogScrollBar
        extends JScrollBar {
            private int lastMax;

            public LogScrollBar(int orientation) {
                super(orientation);
                this.lastMax = 0;
            }

            public void setValues(int newValue, int newExtent, int newMin, int newMax) {
                super.setValues(newValue, newExtent, newMin, newMax);
                if (newMax != this.lastMax) {
                    this.setValue(newMax);
                    this.lastMax = newMax;
                }
            }
        }
    }

    private class separatorPanel
    extends JPanel {
        private separatorPanel() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(ResourceManager.sunBlue);
            Dimension d = this.getSize();
            g.drawLine(4, d.height - 1, d.width - 4, d.height - 1);
        }
    }
}

