/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.servlet;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.console.config.ConfigManagement;
import com.sun.management.viperimpl.console.config.ConfigurationException;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ToolBoxServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path != null && path.startsWith("/")) {
            path = path.substring(1).trim();
        }
        Debug.trace((String)"Toolbox Servlet", (int)Debug.INFORMATION, (String)("Request: " + path), null);
        if (path.indexOf("..") >= 0) {
            this.sendNotFoundError(res, path);
            return;
        }
        Locale locale = this.parseLocale(req.getHeader("Locale"));
        if (path.equals("")) {
            this.listConfigs(res, locale);
        } else if (path.endsWith(".tbx")) {
            this.readToolbox(res, path, locale);
        } else if (path.endsWith(".gif")) {
            this.readImage(res, path);
        } else {
            this.readFile(res, path);
        }
    }

    protected void readFile(HttpServletResponse res, String path) {
        byte[] buffer = null;
        path = ConfigManagement.getFilePath(path);
        try {
            FileInputStream fis = new FileInputStream(path);
            buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            long mtime = new File(path).lastModified();
            res.setDateHeader("Last-Modified", mtime);
            res.setContentType("text/plain");
            res.setContentLength(buffer.length);
            ServletOutputStream out = res.getOutputStream();
            out.write(buffer);
            out.close();
        }
        catch (FileNotFoundException e) {
            this.sendNotFoundError(res, path);
        }
        catch (IOException e) {
            this.sendInternalError(res, e.getMessage());
        }
    }

    protected void readImage(HttpServletResponse res, String path) {
        byte[] buffer = null;
        path = ConfigManagement.getFilePath(path);
        try {
            FileInputStream fis = new FileInputStream(path);
            buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            long mtime = new File(path).lastModified();
            res.setDateHeader("Last-Modified", mtime);
            res.setContentType("image/gif");
            ServletOutputStream out = res.getOutputStream();
            out.write(buffer);
            out.close();
        }
        catch (FileNotFoundException e) {
            this.sendNotFoundError(res, path);
        }
        catch (IOException e) {
            this.sendInternalError(res, e.getMessage());
        }
    }

    protected void readToolbox(HttpServletResponse res, String name, Locale locale) {
        byte[] buffer = null;
        name = ConfigManagement.aliasifyPath(name);
        name = name.substring(0, name.lastIndexOf(".tbx"));
        String path = ConfigManagement.getConfigPath(name, locale);
        try {
            FileInputStream fis = new FileInputStream(path);
            buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            long mtime = new File(path).lastModified();
            res.setDateHeader("Last-Modified", mtime);
            res.setContentType("text/plain");
            ServletOutputStream out = res.getOutputStream();
            out.write(buffer);
            out.close();
        }
        catch (FileNotFoundException e) {
            this.sendNotFoundError(res, name);
        }
        catch (IOException e) {
            this.sendInternalError(res, e.getMessage());
        }
    }

    protected void listConfigs(HttpServletResponse res, Locale locale) {
        try {
            VConfigurationInfo[] configs = ConfigManagement.list(locale, true);
            ServletOutputStream sos = res.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)sos);
            oos.writeObject(configs);
            oos.close();
        }
        catch (ConfigurationException e) {
            String m = "Could not process toolbox list request: " + e.getMessage();
            this.sendInternalError(res, m);
        }
        catch (IOException e) {
            this.sendInternalError(res, e.getMessage());
        }
    }

    protected Locale parseLocale(String loc) {
        if (loc == null) {
            return null;
        }
        String country = "";
        String language = "";
        String variant = "";
        int _index = loc.indexOf(95);
        if (_index > 0) {
            country = loc.substring(0, _index);
            if ((_index = (loc = loc.substring(_index + 1)).indexOf(95)) > 0) {
                language = loc.substring(0, _index);
                variant = loc.substring(_index + 1);
            } else {
                language = loc;
            }
        } else {
            country = loc;
        }
        return new Locale(country, language, variant);
    }

    private void sendInternalError(HttpServletResponse res, String message) {
        if (message == null) {
            message = new String("Toolbox servlet internal error");
        }
        int error = 500;
        try {
            res.sendError(error, message);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private void sendNotFoundError(HttpServletResponse res, String file) {
        int error = 404;
        try {
            res.sendError(error, "Toolbox " + file + " not found.");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void log(String msg) {
    }

    public void log(String message, Throwable t) {
    }
}

