/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.servlet;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.server.ViperServer;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteRegistryServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path == null || path.length() <= 1) {
            this.sendInternalError(res, path);
            return;
        }
        path = path.substring(1).trim();
        Debug.trace((String)"RemoteRegistryServlet", (int)Debug.INFORMATION, (String)("Request: " + path), null);
        if (path.indexOf("..") >= 0) {
            this.sendInternalError(res, path);
            return;
        }
        if (path.endsWith("_vstub")) {
            this.getViperStub(res);
        }
    }

    private void getViperStub(HttpServletResponse res) throws ServletException, IOException {
        try {
            ServletOutputStream sos = res.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)sos);
            oos.writeObject(ViperServer.viperRemote);
            oos.flush();
            oos.close();
            sos.close();
        }
        catch (IOException e) {
            this.sendInternalError(res, e.getMessage());
        }
    }

    private void sendInternalError(HttpServletResponse res, String file) throws IOException {
        res.sendError(404, "File " + file + " is NOT used for ViperStub.");
    }

    public void log(String message) {
    }

    public void log(String message, Throwable t) {
    }
}

