/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.servlet;

import com.sun.management.viper.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HelpServlet
extends HttpServlet {
    protected static String docRoot = "/usr/lib/help/";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path != null && path.startsWith("/")) {
            path = path.substring(1).trim();
        }
        Debug.trace((String)"Help Servlet", (int)Debug.INFORMATION, (String)("Help Servlet: request: " + path), null);
        if (path.indexOf("..") >= 0) {
            this.sendNotFoundError(res, path);
            return;
        }
        this.readFile(res, path);
    }

    protected static String computePath(String path) {
        String newpath;
        int loci = path.indexOf("/locale/");
        if (loci < 0) {
            if (path.startsWith("auths/")) {
                return docRoot + "auths/locale/C/" + path.substring("auths/".length());
            }
            if (path.startsWith("profiles/")) {
                return docRoot + "profiles/locale/C/" + path.substring("profiles/".length());
            }
            return docRoot + path;
        }
        String prefix = path.substring(0, loci) + "/locale/";
        String loc = path.substring(loci += 8, path.indexOf(47, loci));
        String suffix = path.substring(path.indexOf(47, loci));
        boolean found = false;
        loc = loc + "_";
        do {
            loc = loc.substring(0, loc.lastIndexOf(95));
            newpath = docRoot + prefix + loc + suffix;
            if (!new File(newpath).exists()) continue;
            found = true;
        } while (!found && loc.indexOf(95) >= 0);
        if (!found && !new File(newpath = docRoot + prefix + Locale.getDefault() + suffix).exists()) {
            newpath = docRoot + prefix + "C" + suffix;
        }
        return newpath;
    }

    protected void readFile(HttpServletResponse res, String path) {
        String reqpath = path;
        try {
            path = HelpServlet.computePath(path);
            byte[] buffer = null;
            FileInputStream fis = new FileInputStream(path);
            buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            long mtime = new File(path).lastModified();
            res.setDateHeader("Last-Modified", mtime);
            if (path.endsWith(".html")) {
                res.setContentType("text/html");
            } else if (path.endsWith(".gif")) {
                res.setContentType("image/gif");
            } else {
                res.setContentType("text/plain");
            }
            res.setContentLength(buffer.length);
            ServletOutputStream out = res.getOutputStream();
            out.write(buffer);
            out.close();
        }
        catch (FileNotFoundException e) {
            this.sendNotFoundError(res, reqpath);
        }
        catch (IOException e) {
            this.sendInternalError(res, e.getMessage());
        }
    }

    private void sendInternalError(HttpServletResponse res, String message) {
        if (message == null) {
            message = new String("Help servlet internal error");
        }
        int error = 500;
        try {
            res.sendError(error, message);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private void sendNotFoundError(HttpServletResponse res, String file) {
        int error = 404;
        try {
            res.sendError(error, "Help file <code>" + file + "</code> not found.");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void log(String msg) {
    }

    public void log(String message, Throwable t) {
    }
}

