/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConsoleServlet
extends HttpServlet {
    private Hashtable cache;
    private String docRoot = null;
    private String codebase = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.cache = new Hashtable();
        this.docRoot = config.getServletContext().getRealPath("/");
        try {
            this.docRoot = new File(this.docRoot).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.codebase = System.getProperty("java.rmi.server.codebase");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getPathInfo();
        if (path != null && path.indexOf("..") >= 0) {
            response.sendError(403, "Cannot serve request.");
            return;
        }
        try {
            if (path == null || path.equals("")) {
                String url = "http://" + request.getServerName() + ":" + request.getServerPort() + request.getServletPath() + "/";
                response.sendRedirect(url);
            } else if (path.equals("/") || path.equals("//")) {
                this.sendFile(response, "text/html", "/console.html");
            } else if (path.endsWith(".html")) {
                this.sendFile(response, "text/html", path);
            } else if (path.endsWith(".gif")) {
                this.sendFile(response, "image/gif", path);
            } else if (path.endsWith(".js")) {
                this.sendFile(response, "application/x-javascript", path);
            } else {
                response.sendError(403, "Cannot serve request.");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + path);
            response.sendError(404, "File " + path + " not found (webconsole).");
        }
    }

    private void sendFile(HttpServletResponse response, String mimetype, String path) throws FileNotFoundException {
        byte[] buffer;
        if (!this.cache.containsKey(path)) {
            buffer = this.readFile(this.docRoot + path);
            if (mimetype.equals("text/html")) {
                buffer = this.parseBuffer(buffer);
            }
            this.cache.put(path, buffer);
        } else {
            buffer = (byte[])this.cache.get(path);
        }
        try {
            if (buffer != null) {
                File f = new File(this.docRoot + path);
                long mtime = f.lastModified();
                response.setDateHeader("Last-Modified", mtime);
                response.setContentType(mimetype);
                response.setContentLength(buffer.length);
                ServletOutputStream out = response.getOutputStream();
                out.write(buffer);
                out.close();
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private byte[] readFile(String filename) throws FileNotFoundException {
        byte[] buffer = null;
        FileInputStream fis = new FileInputStream(filename);
        try {
            buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return buffer;
    }

    private byte[] parseBuffer(byte[] buffer) {
        String s1 = new String(buffer);
        String s2 = new String();
        int index = 0;
        int oldindex = 0;
        while ((index = s1.indexOf("<#", index)) != -1) {
            int index2 = s1.indexOf("#>", index);
            if (index2 == -1) continue;
            s2 = s2 + s1.substring(oldindex, index);
            String directive = s1.substring(index + 2, index2);
            if (directive.equals("CODEBASEURL")) {
                s2 = s2 + this.codebase;
                index += 4 + directive.length();
            }
            oldindex = index;
        }
        s2 = s2 + s1.substring(oldindex, s1.length());
        return s2.getBytes();
    }

    public String getServletInfo() {
        return "SMC Web Console Servlet, v1.0";
    }

    public void log(String msg) {
    }

    public void log(String message, Throwable t) {
    }
}

