/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.servlet;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.server.repository.VRegistry;
import com.sun.management.viperimpl.servlet.Reads;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CodebaseServlet
extends HttpServlet {
    private String codebase = null;
    private static Hashtable classList = null;
    private static ZipFile jarCacheFile = null;
    private static Vector jarCacheEntries = new Vector(10);
    private static String jarCacheName = "";
    private static long jarCacheTimeStamp = 0L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.codebase = VRegistry.getCodebase();
    }

    protected static void reloadClassList() {
        classList = VRegistry.getClassList();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path == null || path.length() <= 1) {
            this.sendNotFoundError(res, path);
            return;
        }
        path = path.substring(1).trim();
        Debug.trace((String)"Codebase Servlet", (int)Debug.INFORMATION, (String)("Codebase Servlet: request: " + path), null);
        if (path.indexOf("..") >= 0) {
            this.sendNotFoundError(res, path);
            return;
        }
        String source = null;
        byte[] buffer = null;
        if (classList == null) {
            CodebaseServlet.reloadClassList();
        }
        if ((source = (String)classList.get(path)) == null) {
            source = this.codebase + path;
            buffer = this.getBitsFromFile(source);
            if (buffer == null) {
                this.sendNotFoundError(res, path);
                return;
            }
        } else if (source.endsWith(".jar") || source.endsWith(".zip")) {
            buffer = this.getBitsFromJar(source, path);
        } else if (source.endsWith(".class")) {
            buffer = this.getBitsFromFile(source);
        }
        if (buffer == null) {
            buffer = this.getBitsFromFile(this.codebase + path);
        }
        if (buffer != null) {
            long mtime = new File(source).lastModified();
            res.setDateHeader("Last-Modified", mtime);
            res.setContentType(this.getContentType(path));
            res.setContentLength(buffer.length);
            ServletOutputStream out = res.getOutputStream();
            out.write(buffer);
            out.close();
            Debug.trace((String)"Codebase Servlet", (int)Debug.INFORMATION, (String)("Servlet loaded: " + path), null);
        } else {
            this.sendNotFoundError(res, path);
        }
    }

    private byte[] getBitsFromFile(String filename) {
        byte[] buffer = null;
        try {
            FileInputStream file = new FileInputStream(filename);
            buffer = new byte[file.available()];
            file.read(buffer);
            file.close();
        }
        catch (IOException ioe) {
            Debug.trace((String)"Codebase Servlet", (int)Debug.WARNING, (String)("Codebase Servlet direct loading:" + ioe.getMessage()), (Throwable)ioe);
        }
        return buffer;
    }

    private synchronized byte[] getBitsFromJar(String jarfile, String classname) {
        byte[] buffer = null;
        try {
            InputStream in = null;
            boolean size = false;
            File file = new File(jarfile);
            if (jarCacheTimeStamp != file.lastModified() || !jarCacheName.equals(jarfile)) {
                ZipFile zipFile = new ZipFile(jarfile);
                jarCacheTimeStamp = file.lastModified();
                jarCacheFile = zipFile;
                jarCacheEntries.removeAllElements();
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                while (e.hasMoreElements()) {
                    jarCacheEntries.add(e.nextElement());
                }
                jarCacheName = jarfile;
            }
            ZipEntry ze = null;
            for (int i = 0; i < jarCacheEntries.size(); ++i) {
                ze = (ZipEntry)jarCacheEntries.elementAt(i);
                if (!ze.getName().equals(classname)) continue;
                in = jarCacheFile.getInputStream(ze);
                buffer = Reads.read(in);
                break;
            }
        }
        catch (IOException ioe) {
            jarCacheName = "";
            jarCacheTimeStamp = 0L;
            Debug.trace((String)"Codebase Servlet", (int)Debug.WARNING, (String)("VCodebase Servlet: " + ioe.getMessage()), (Throwable)ioe);
        }
        return buffer;
    }

    private String getContentType(String file) {
        String name = file.toLowerCase();
        String type = "text/plain";
        if (name.endsWith(".class") || name.endsWith(".ser")) {
            type = "application/java";
        } else if (name.endsWith(".gif")) {
            type = "image/gif";
        } else if (name.endsWith(".jpg") || name.endsWith(".jpeg")) {
            type = "image/jpeg";
        } else if (name.endsWith(".html") || name.endsWith(".htm")) {
            type = "text/html";
        } else if (name.endsWith(".jar")) {
            type = "application/java-archive";
        } else if (name.endsWith(".js")) {
            type = "application/x-javascript";
        }
        return type;
    }

    private void sendNotFoundError(HttpServletResponse res, String file) throws IOException {
        res.sendError(404, "File " + file + " is NOT found in SMC codebase.");
    }

    public void log(String msg) {
    }

    public void log(String message, Throwable t) {
    }
}

