/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.server;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.services.authentication.DigestAuthFlavor;
import com.sun.management.viperimpl.services.authentication.DigestSecurityUtil;
import com.sun.management.viperimpl.services.authentication.server.DigestServerSecurityContext;
import com.sun.management.viperimpl.services.authentication.server.ServerSecurityContext;
import com.sun.management.viperimpl.services.authentication.server.ServerSecurityFactory;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;

public class DigestServerSecurityFactory
implements ServerSecurityFactory {
    private DigestAuthFlavor initDaf;
    private DigestServerSecurityContext initSsc;

    public void init(Properties props) throws AuthenticationException {
        Provider sp;
        DigestAuthFlavor daf = new DigestAuthFlavor();
        String provider = "SUN";
        int retries = 0;
        long htbtPeriod = -1L;
        boolean verify = false;
        boolean integrity = false;
        if (props != null) {
            String value = props.getProperty("auth.digest.provider");
            if (value != null) {
                provider = value;
            }
            if ((value = props.getProperty("auth.digest.digest.algo")) != null) {
                daf.setDigestAlgorithm(value);
            }
            if ((value = props.getProperty("auth.digest.sign.algo")) != null) {
                daf.setSignatureAlgorithm(value);
            }
            if ((value = props.getProperty("auth.digest.key.algo")) != null) {
                daf.setKeyGenerationAlgorithm(value);
            }
            if ((value = props.getProperty("auth.digest.key.strength")) != null) {
                int size = 0;
                try {
                    size = new Integer(value);
                }
                catch (Exception ex) {
                    size = 0;
                }
                if (size > 0) {
                    daf.setKeyStrength(size);
                }
            }
            if ((value = props.getProperty("auth.retry.max")) != null) {
                try {
                    retries = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((value = props.getProperty("auth.heartbeat.period")) != null) {
                try {
                    htbtPeriod = Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((value = props.getProperty("auth.msg.verify")) != null && value.equalsIgnoreCase("on")) {
                verify = true;
            }
            if ((value = props.getProperty("auth.digest.msg.integrity")) != null && value.equalsIgnoreCase("on")) {
                integrity = true;
            }
        }
        if ((sp = Security.getProvider(provider)) == (Provider)null) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("Security provider not installed: " + provider), null);
            throw new AuthenticationException("Security provider not installed: ", (Object)provider);
        }
        DigestSecurityUtil.initialize(sp, daf.getDigestAlgorithm(), daf.getSignatureAlgorithm(), daf.getKeyGenerationAlgorithm(), daf.getKeyStrength());
        this.initDaf = daf;
        this.initSsc = new DigestServerSecurityContext(daf);
        this.initSsc.setVerify(verify);
        if (integrity) {
            this.initSsc.setIntegrity();
        }
        if (retries > 0) {
            this.initSsc.setMaxRetries(retries);
        }
        if (htbtPeriod > 0L) {
            this.initSsc.setHeartbeatPeriod(htbtPeriod);
        }
    }

    public AuthenticationFlavor getAuthFlavor() throws AuthenticationException {
        AuthenticationFlavor af = null;
        if (this.initDaf != null) {
            af = this.initDaf.newCopy();
        }
        return af;
    }

    public ServerSecurityContext getServerSecurityContext() throws AuthenticationException {
        ServerSecurityContext ssc = null;
        if (this.initSsc != null) {
            ssc = this.initSsc.newCopy();
        }
        return ssc;
    }
}

