/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.server;

import com.sun.management.viper.VException;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viper.services.Log;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.services.authentication.AuthenticationLoginException;
import com.sun.management.viperimpl.services.authentication.AuthenticationPrincipal;
import com.sun.management.viperimpl.services.authentication.AuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.CloseSecurityToken;
import com.sun.management.viperimpl.services.authentication.ConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.NoSecureSessionException;
import com.sun.management.viperimpl.services.authentication.RequestSecurityToken;
import com.sun.management.viperimpl.services.authentication.ResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.RetryLimitExceededException;
import com.sun.management.viperimpl.services.authentication.SecurityToken;
import com.sun.management.viperimpl.services.authentication.server.ServerSecurityContext;
import com.sun.management.viperimpl.services.authentication.server.ServerSecurityFactory;
import com.sun.management.viperimpl.util.Timer;
import com.sun.management.viperimpl.util.TimerTask;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class AuthenticationService {
    private static final String AUTH_PACKAGE = AuthenticationService.class.getPackage().getName();
    private static final String AUTH_FACTORY_CLASSNAME = "ServerSecurityFactory";
    private static final String AUTH_SERVICE_RESOURCES = "AuthenticationServiceResources";
    private static final long AUTH_FAILURE_DELAY = 2000L;
    private static int dfltType;
    private static Hashtable factTable;
    private static Hashtable sessTable;
    private static Log logsvc;
    private static long htbtPeriod;
    private static int maxRetries;
    private static long penalty_ms;
    private static Vector failedAttempts;

    public static void init(Properties props, Log log) throws AuthenticationException {
        String dflt_flavor;
        ServerSecurityFactory sf;
        logsvc = log;
        String[] flavors = AuthenticationFlavor.getAuthFlavors();
        if (flavors.length < 1) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)"No authentication flavors configured", null);
            throw new AuthenticationException("NoFlavorConfiged");
        }
        String basename = AUTH_PACKAGE + ".";
        factTable = new Hashtable();
        for (int i = 0; i < flavors.length; ++i) {
            String classname = basename + flavors[i] + AUTH_FACTORY_CLASSNAME;
            try {
                Class<?> cl = Class.forName(classname);
                sf = (ServerSecurityFactory)cl.newInstance();
            }
            catch (Exception ex) {
                Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("Cannot create new instance of security factory " + classname), (Throwable)ex);
                throw new AuthenticationException("Cannot create new instance of security factory ", (Object)classname, ex);
            }
            sf.init(props);
            factTable.put(new Integer(i), sf);
        }
        int dflt_type = -1;
        if (props != null && (dflt_flavor = props.getProperty("auth.flavor.default")) != null) {
            dflt_type = AuthenticationFlavor.checkAuthFlavor((String)dflt_flavor);
        }
        if (dflt_type < 0) {
            dflt_type = AuthenticationFlavor.getDefaultAuthType();
        }
        if ((sf = (ServerSecurityFactory)factTable.get(new Integer(dflt_type))) == null) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)"No default authentication flavor is configured", null);
            throw new AuthenticationException("No default authentication flavor is configured");
        }
        dfltType = dflt_type;
        String retryProp = null;
        if (props != null) {
            retryProp = props.getProperty("auth.retry.max");
        }
        if (retryProp == null) {
            retryProp = "5";
        }
        try {
            maxRetries = Integer.parseInt(retryProp);
        }
        catch (NumberFormatException e) {
            maxRetries = 5;
        }
        retryProp = null;
        if (props != null) {
            retryProp = props.getProperty("auth.retry.delay");
        }
        if (retryProp == null) {
            retryProp = "30";
        }
        try {
            penalty_ms = Long.parseLong(retryProp) * 1000L;
        }
        catch (NumberFormatException e) {
            penalty_ms = 30000L;
        }
        retryProp = null;
        if (props != null) {
            retryProp = props.getProperty("auth.heartbeat.period");
        }
        if (retryProp == null) {
            retryProp = "900";
        }
        try {
            htbtPeriod = Long.parseLong(retryProp) * 1000L;
        }
        catch (NumberFormatException e) {
            htbtPeriod = 900000L;
        }
        failedAttempts = new Vector();
        sessTable = new Hashtable();
        if (htbtPeriod >= 0L) {
            Timer heartbeater = new Timer(true);
            TimerTask doctor = new TimerTask(){

                public void run() {
                    long now = System.currentTimeMillis();
                    Enumeration e = sessTable.elements();
                    while (e.hasMoreElements()) {
                        ServerSecurityContext ssc = (ServerSecurityContext)e.nextElement();
                        if (now - ssc.getHeartbeatTime() < 2L * htbtPeriod) continue;
                        Long id = new Long(ssc.getSecurityId());
                        sessTable.remove(id);
                        AuthenticationService.writeLog(ssc, 300, "LMS_SessionClosed", "LMD_SessionTimeout", null);
                    }
                }
            };
            heartbeater.schedule(doctor, htbtPeriod, htbtPeriod / 10L);
        }
    }

    public static ServerSecurityContext getSecurityContext() throws AuthenticationException {
        return AuthenticationService.createSecurityContext(dfltType);
    }

    public static ServerSecurityContext getSecurityContext(AuthenticationFlavor authFlavor) throws AuthenticationException {
        return AuthenticationService.createSecurityContext(authFlavor.getAuthType());
    }

    public static ServerSecurityContext lookupSecurityContext(SecurityToken token) throws AuthenticationException {
        long sid = token.getSecurityId();
        return AuthenticationService.findSecurityContext(sid);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecurityToken authRequest(String type, SecurityToken token) throws AuthenticationException {
        void var2_7;
        Object var2_2 = null;
        if (type == null) throw new AuthenticationException("Invalid remote request type");
        if (type.equals("negotiate")) {
            ResponseSecurityToken responseSecurityToken = AuthenticationService.negotiate(token);
            return var2_7;
        } else if (type.equals("authenticate")) {
            ConfirmSecurityToken confirmSecurityToken = AuthenticationService.authenticate(token);
            return var2_7;
        } else if (type.equals("heartbeat")) {
            SecurityToken securityToken = AuthenticationService.heartbeat(token);
            return var2_7;
        } else {
            if (!type.equals("close")) throw new AuthenticationException("Invalid remote request type");
            SecurityToken securityToken = AuthenticationService.close(token);
        }
        return var2_7;
    }

    private static ResponseSecurityToken negotiate(SecurityToken token) throws AuthenticationException {
        RequestSecurityToken itok;
        try {
            itok = (RequestSecurityToken)token;
        }
        catch (Exception ex) {
            throw new AuthenticationException("Invalid input security token type");
        }
        String username = "";
        String hostname = "";
        AuthenticationPrincipal cap = itok.getAuthPrincipal();
        if (cap != null) {
            username = cap.getUserName();
            if (cap.getRoleName() != null) {
                username = username + " (in role " + cap.getRoleName() + ")";
            }
        }
        hostname = itok.getClientHost();
        int vers = itok.getVersionNumber();
        if (vers != 1) {
            String str1 = new Integer(vers).toString();
            String str2 = new Integer(1).toString();
            String[] v = new String[]{username, hostname, str1, str2};
            AuthenticationService.writeLog(400, "LMS_SvcError", "LMD_VersionMismatch", v);
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("Incompatible token version numbers: " + str1 + " " + str2), null);
            throw new AuthenticationException("Incompatible token version numbers", (Object)str1, (Object)str2);
        }
        boolean bool = false;
        ServerSecurityContext ssc = null;
        AuthenticationFlavor caf = itok.getAuthFlavor();
        try {
            ssc = AuthenticationService.getSecurityContext(caf);
            bool = ssc.verifyAuthFlavor(caf);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            bool = false;
        }
        if (!bool) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)"Incompatible authentication flavors", null);
            throw new AuthenticationException("Incompatible flavors");
        }
        long sid = 0L;
        try {
            sid = AuthenticationService.genSecurityId();
        }
        catch (VException ex) {
            AuthenticationService.writeLog(ssc, 400, "LMS_SvcError", "LMD_NoSessionId", null);
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)"Session connect: Unable to generate sesion identifier", (Throwable)ex);
            throw new AuthenticationException("Cannot generate session identifier");
        }
        ssc.setSecurityId(sid);
        ssc.setClientVersion(vers);
        ssc.setClientVMID(itok.getClientVMID());
        ResponseSecurityToken rtok = null;
        try {
            rtok = ssc.verifyRequestToken(itok);
        }
        catch (AuthenticationException ax) {
            AuthenticationService.checkRetriesOnFail(ssc);
            throw ax;
        }
        catch (VException ex) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("Session connect: Exception verifying request: " + ex.getMessage()), (Throwable)ex);
            throw new AuthenticationException("Unexpected error verifying response", (Exception)((Object)ex));
        }
        AuthenticationService.addSecurityContext(sid, ssc);
        return rtok;
    }

    private static ConfirmSecurityToken authenticate(SecurityToken token) throws AuthenticationException {
        ConfirmSecurityToken rtok;
        AuthenticatorSecurityToken itok;
        try {
            itok = (AuthenticatorSecurityToken)token;
        }
        catch (Exception ex) {
            throw new AuthenticationException("Invalid input security token type");
        }
        long sid = itok.getSecurityId();
        ServerSecurityContext ssc = AuthenticationService.findSecurityContext(sid);
        if (ssc == (ServerSecurityContext)null) {
            String[] args = new String[]{new Long(sid).toString()};
            AuthenticationService.writeLog(400, "LMS_SessionOpened", "LMD_BadSecondStep", args);
            throw new NoSecureSessionException();
        }
        try {
            rtok = ssc.verifyAuthenticatorToken(itok);
        }
        catch (AuthenticationLoginException alx) {
            AuthenticationService.checkRetriesOnFail(ssc);
            throw alx;
        }
        catch (AuthenticationException ax) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("Unexpected error verifying authenticator: " + ax.getMessage()), (Throwable)ax);
            AuthenticationService.checkRetriesOnFail(ssc);
            throw new AuthenticationException("Error authenticating user", (Exception)((Object)ax));
        }
        ssc.setHeartbeatTime();
        String username = ssc.getAuthPrincipal().getUserName();
        if (ssc.getAuthPrincipal().getRoleName() != null) {
            username = username + " (in role " + ssc.getAuthPrincipal().getRoleName() + ")";
        }
        AuthenticationService.writeLog(ssc, 100, "LMS_SessionOpened", "LMD_LoginSuccessful", null);
        return rtok;
    }

    private static void checkRetriesOnFail(ServerSecurityContext ssc) throws RetryLimitExceededException {
        long delay = 2000L;
        boolean overlimit = false;
        long now = System.currentTimeMillis();
        AttemptRecord ar = null;
        for (int i = failedAttempts.size() - 1; i >= 0; --i) {
            AttemptRecord r = (AttemptRecord)failedAttempts.elementAt(i);
            if (now - r.lastFailedAt > 600000L) {
                failedAttempts.remove(i);
                continue;
            }
            if (!r.clientVMID.equals(ssc.getClientVMID())) continue;
            ar = r;
        }
        if (ar == null) {
            ar = new AttemptRecord(ssc.getClientVMID());
            failedAttempts.add(ar);
        }
        ar.lastFailedAt = now;
        ++ar.failCounter;
        if (ar.failCounter == maxRetries) {
            ssc.auditRetryLimitExceeded(ssc.getClientHost(), new VIdentity(ssc.getClientVMID()), null);
            overlimit = true;
        } else if (ar.failCounter > maxRetries) {
            overlimit = true;
            delay += penalty_ms;
        }
        AuthenticationService.removeSecurityContext(ssc.getSecurityId());
        try {
            Thread.currentThread();
            Thread.sleep(delay);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (overlimit) {
            throw new RetryLimitExceededException();
        }
    }

    private static SecurityToken heartbeat(SecurityToken token) throws AuthenticationException {
        long sid;
        ServerSecurityContext ssc;
        if (token != null && (ssc = AuthenticationService.findSecurityContext(sid = token.getSecurityId())) != null) {
            ssc.setHeartbeatTime();
        }
        return null;
    }

    private static SecurityToken close(SecurityToken token) throws AuthenticationException {
        int type;
        long sid;
        ServerSecurityContext ssc = null;
        if (token != null) {
            sid = token.getSecurityId();
            type = token.getAuthType();
            ssc = AuthenticationService.findSecurityContext(sid);
        } else {
            sid = 0L;
            type = AuthenticationFlavor.getDefaultAuthType();
        }
        if (ssc != null) {
            AuthenticationService.writeLog(ssc, 100, "LMS_SessionClosed", "LMD_LogoutSuccessful", null);
            AuthenticationService.removeSecurityContext(sid);
        }
        CloseSecurityToken rtok = new CloseSecurityToken(type, sid);
        return rtok;
    }

    private static synchronized ServerSecurityContext createSecurityContext(int type) throws AuthenticationException {
        ServerSecurityFactory sf = (ServerSecurityFactory)factTable.get(new Integer(type));
        if (sf == null) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("Request to create security context for non-existent flavor" + type), null);
            throw new AuthenticationException("Request to create security context for non-existent authentication type ", (Object)new Integer(type));
        }
        ServerSecurityContext csc = sf.getServerSecurityContext();
        if (csc != null) {
            csc.setLogService(logsvc);
        }
        return csc;
    }

    private static synchronized long genSecurityId() throws AuthenticationException {
        long nsid = System.currentTimeMillis();
        if (!sessTable.isEmpty()) {
            int i;
            for (i = 0; i < 5 && sessTable.contains(new Long(nsid)); ++i) {
                ++nsid;
            }
            if (i == 5) {
                throw new AuthenticationException("EXM_NID");
            }
        }
        return nsid;
    }

    private static synchronized ServerSecurityContext findSecurityContext(long sid) {
        ServerSecurityContext sctx = null;
        if (sid != 0L) {
            Long lid = new Long(sid);
            sctx = (ServerSecurityContext)sessTable.get(lid);
        }
        return sctx;
    }

    private static synchronized void addSecurityContext(long sid, ServerSecurityContext sctx) {
        if (sid != 0L) {
            Long lid = new Long(sid);
            sessTable.put(lid, sctx);
        }
    }

    private static synchronized void removeSecurityContext(long sid) {
        if (sid != 0L) {
            Long lid = new Long(sid);
            sessTable.remove(lid);
        }
    }

    private static void writeLog(ServerSecurityContext sctx, int severity, String sumMsg, String detMsg, String arg1) {
        String[] fargs;
        if (sctx == null) {
            return;
        }
        String user = null;
        AuthenticationPrincipal ap = sctx.getAuthPrincipal();
        if (ap != null) {
            user = ap.getUserName();
            if (ap.getRoleName() != null) {
                user = user + " (in role " + ap.getRoleName() + ")";
            }
        }
        String client = sctx.getClientHost();
        long sid = sctx.getSecurityId();
        if (arg1 == null) {
            fargs = new String[3];
        } else {
            fargs = new String[4];
            fargs[3] = arg1;
        }
        fargs[0] = user;
        fargs[1] = client;
        fargs[2] = Long.toString(sid);
        AuthenticationService.writeLog(severity, sumMsg, detMsg, fargs);
    }

    private static void writeLog(int severity, String sumMsg, String detMsg, String[] args) {
        if (logsvc != null) {
            try {
                logsvc.writeLog("LMS_AuthSvcName", "security", severity, sumMsg, detMsg, args, AUTH_PACKAGE + "." + AUTH_SERVICE_RESOURCES, null);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private static class AttemptRecord {
        static final long LIFE_TIME = 600000L;
        String clientVMID;
        int failCounter;
        long lastFailedAt;

        AttemptRecord(String cvm) {
            this.clientVMID = cvm;
            this.failCounter = 0;
            this.lastFailedAt = 0L;
        }
    }
}

