/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viper.VException;
import com.sun.management.viper.VService;
import com.sun.management.viperimpl.ConnectionInfo;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.SMCVersion;
import com.sun.management.viperimpl.ServiceInfoImpl;
import com.sun.management.viperimpl.ToolInfoImpl;
import com.sun.management.viperimpl.VCallerImpl;
import com.sun.management.viperimpl.server.ViperServer;
import com.sun.management.viperimpl.server.repository.VRegistry;
import com.sun.management.viperimpl.server.repository.ViperAdminInterface;
import java.rmi.RemoteException;
import java.util.Vector;

public class ViperAdminImpl
extends VService
implements ViperAdminInterface {
    private Vector serviceInfoList = null;
    private Vector toolInfoList = null;
    private Vector libraryInfoList = null;
    private Vector userInfoList = null;
    private Vector serverStatusInfo = null;

    public Vector getServerStatus() throws RemoteException, VException {
        this.serverStatusInfo = new Vector();
        String s = SMCVersion.getFullVersion();
        if (s == null) {
            s = "";
        }
        this.serverStatusInfo.addElement(s);
        s = System.getProperty("viper.servlet.port");
        if (s == null) {
            s = "";
        }
        this.serverStatusInfo.addElement(s);
        s = System.getProperty("os.version");
        if (s == null) {
            s = "";
        }
        this.serverStatusInfo.addElement(s);
        s = ViperServer.getServerStartDate().toString();
        if (s == null) {
            s = "";
        }
        this.serverStatusInfo.addElement(s);
        int len = this.getUsageInformation().size();
        this.serverStatusInfo.addElement(new Integer(len).toString());
        return this.serverStatusInfo;
    }

    public int getConnectionListSize() throws RemoteException, VException {
        int len = this.getUsageInformation().size();
        return len;
    }

    public Vector getUsageInformation() throws RemoteException, VException {
        ConnectionInfo[] c = ViperServer.getUsageInfo();
        if (c.length > 0) {
            this.userInfoList = new Vector(c.length);
            for (int i = 0; i < c.length; ++i) {
                int k;
                Vector<Object> newVector = new Vector<Object>(5);
                VCallerImpl vc = c[i].getUserId();
                String s = "";
                if (vc != null) {
                    s = vc.getPrimaryName() + " (" + vc.getUid() + ")";
                }
                newVector.addElement(s);
                if (vc != null) {
                    newVector.addElement(vc.getAuthenHost());
                } else {
                    newVector.addElement("Unknown");
                }
                newVector.addElement(c[i].getUserLogonTime());
                s = "";
                Vector v = c[i].getLoadedServices();
                for (k = 0; k < v.size(); ++k) {
                    s = k == v.size() - 1 ? s + (String)v.elementAt(k) : s + (String)v.elementAt(k) + ", ";
                }
                newVector.addElement(s.trim());
                s = "";
                v = c[i].getLoadedTools();
                for (k = 0; k < v.size(); ++k) {
                    s = k == v.size() - 1 ? s + (String)v.elementAt(k) : s + (String)v.elementAt(k) + ", ";
                }
                newVector.addElement(s.trim());
                this.userInfoList.addElement(newVector);
            }
        }
        return this.userInfoList;
    }

    public Vector getServiceList() throws RemoteException {
        return this.getViperServiceList();
    }

    public int getServiceListSize() throws RemoteException {
        int len = this.getViperServiceList().size();
        return len;
    }

    private Vector getViperServiceList() {
        boolean newVectorLen = false;
        ServiceInfoImpl[] allsi = VRegistry.readServices();
        if (allsi != null && allsi.length > 0) {
            this.serviceInfoList = new Vector(allsi.length);
            for (int i = 0; i < allsi.length; ++i) {
                Vector<Object> newVector = new Vector<Object>(8);
                newVector.addElement(allsi[i].getClassName());
                newVector.addElement(allsi[i].getVersion());
                newVector.addElement(allsi[i].getRegistrarDate());
                newVector.addElement(allsi[i].getResourceBaseName());
                String preReqs = "";
                String[] preReqNames = allsi[i].getLoadDependencies();
                if (preReqNames != null) {
                    for (int j = 0; j < preReqNames.length; ++j) {
                        preReqs = j == preReqNames.length ? preReqs + preReqNames[j] : preReqs + preReqNames[j] + ",";
                    }
                }
                newVector.addElement(preReqs);
                if (allsi[i].isDaemon()) {
                    newVector.addElement(new Boolean(true));
                } else {
                    newVector.addElement(new Boolean(false));
                }
                if (allsi[i].isSingleton()) {
                    newVector.addElement(new Boolean(true));
                } else {
                    newVector.addElement(new Boolean(false));
                }
                String nativeLibs = "";
                String[] names = allsi[i].getNativeLibs();
                if (names != null) {
                    for (int j = 0; j < names.length; ++j) {
                        nativeLibs = j == names.length - 1 ? nativeLibs + ViperAdminImpl.baseName(names[j]) : nativeLibs + ViperAdminImpl.baseName(names[j]) + ",";
                    }
                }
                newVector.addElement(nativeLibs);
                LibInfoImpl[] attachments = allsi[i].getAttachments();
                String serviceAttachments = "";
                for (int j = 0; j < attachments.length; ++j) {
                    serviceAttachments = j == attachments.length - 1 ? serviceAttachments + ViperAdminImpl.baseName(attachments[j].getJarName()) : serviceAttachments + ViperAdminImpl.baseName(attachments[j].getJarName()) + ",";
                }
                newVector.addElement(serviceAttachments);
                this.serviceInfoList.addElement(newVector);
            }
        }
        return this.serviceInfoList;
    }

    public Vector getToolList() throws RemoteException {
        return this.getViperToolList();
    }

    public int getToolListSize() throws RemoteException {
        int len = this.getViperToolList().size();
        return len;
    }

    private Vector getViperToolList() {
        ToolInfoImpl[] allti = VRegistry.readTools();
        if (allti != null && allti.length > 0) {
            this.toolInfoList = new Vector(allti.length);
            for (int i = 0; i < allti.length; ++i) {
                Vector<Object> newVector = new Vector<Object>(5);
                newVector.addElement(allti[i].getClassName());
                newVector.addElement(allti[i].getVersion());
                newVector.addElement(allti[i].getRegistrarDate());
                newVector.addElement(allti[i].getResourceBaseName());
                String[] names = allti[i].getNativeLibs();
                String nativeLibs = "";
                if (names != null) {
                    for (int j = 0; j < names.length; ++j) {
                        nativeLibs = j == names.length - 1 ? nativeLibs + ViperAdminImpl.baseName(names[j]) : nativeLibs + ViperAdminImpl.baseName(names[j]) + ",";
                    }
                }
                newVector.addElement(nativeLibs);
                LibInfoImpl[] attachments = allti[i].getAttachments();
                String toolAttachments = "";
                for (int j = 0; j < attachments.length; ++j) {
                    toolAttachments = j == attachments.length - 1 ? toolAttachments + ViperAdminImpl.baseName(attachments[j].getJarName()) : toolAttachments + ViperAdminImpl.baseName(attachments[j].getJarName()) + ",";
                }
                newVector.addElement(toolAttachments);
                this.toolInfoList.addElement(newVector);
            }
        }
        return this.toolInfoList;
    }

    public Vector getLibraryList() throws RemoteException {
        return this.getViperLibraryList();
    }

    public int getLibraryListSize() throws RemoteException {
        int len = this.getViperLibraryList().size();
        return len;
    }

    public Vector getViperLibraryList() {
        LibInfoImpl[] shared = VRegistry.readAllLibJars();
        if (shared != null && shared.length > 0 && shared.length > 0) {
            this.libraryInfoList = new Vector(shared.length);
            for (int j = 0; j < shared.length; ++j) {
                Vector<Object> newVector = new Vector<Object>(4);
                newVector.addElement(ViperAdminImpl.baseName(shared[j].getJarName()));
                newVector.addElement(ViperAdminImpl.pseudoBeanName(shared[j].getJarName()));
                newVector.addElement(shared[j].getRegistrarDate());
                String nativeLibs = "";
                String[] nativeLibNames = shared[j].getNativeLibs();
                for (int k = 0; k < nativeLibNames.length; ++k) {
                    nativeLibs = k == nativeLibNames.length - 1 ? nativeLibs + ViperAdminImpl.baseName(nativeLibNames[k]) : nativeLibs + ViperAdminImpl.baseName(nativeLibNames[k]) + ",";
                }
                newVector.addElement(nativeLibs);
                this.libraryInfoList.addElement(newVector);
            }
        }
        return this.libraryInfoList;
    }

    private static String baseName(String filename) {
        int i = filename.indexOf(64);
        if (i >= 0) {
            return filename.substring(i + 1);
        }
        return filename;
    }

    private static String pseudoBeanName(String filename) {
        int i = filename.indexOf(64);
        if (i > 0) {
            int j = filename.substring(0, i).indexOf(47);
            if (j < 0) {
                return filename.substring(0, i);
            }
            return filename.substring(0, i).substring(j + 1);
        }
        return filename;
    }
}

