/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.config.FolderNode;
import com.sun.management.viperimpl.console.config.ToolBoxNode;
import com.sun.management.viperimpl.console.config.ToolBoxURLNode;
import com.sun.management.viperimpl.console.config.ToolNode;
import com.sun.management.viperimpl.console.config.VBaseConfiguration;
import com.sun.management.viperimpl.console.config.VBaseNode;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class listtool {
    private static CommandOption listOption = new CommandOption("list", "List Legacy Tools", "l", 0, true, false, null, false);
    private static CommandOption fileinOption = new CommandOption("in-file", "Input file", "f", 1, false, false, null, false);

    public static void main(String[] args) {
        ResourceManager.seed((boolean)false);
        CommandParser cp = new CommandParser("listtool", "Tool to list legacy tools", true, System.in, System.out);
        cp.addOption(fileinOption);
        cp.addOption(listOption);
        if (!cp.parseArgs(args)) {
            System.out.println("Failed to parse args");
            System.exit(1);
        }
        String filein = (String)fileinOption.getValue();
        if (listOption.wasSet()) {
            listtool.listConfiguration(filein);
        }
        System.exit(0);
    }

    protected static void listConfiguration(String filein) {
        VBaseConfiguration conf = null;
        try {
            try {
                conf = VBaseConfiguration.createConfiguration(new URL(filein), true);
            }
            catch (MalformedURLException e) {
                conf = VBaseConfiguration.createConfiguration(new File(filein).toURL(), true);
            }
            VBaseNode root = (VBaseNode)conf.getRootNode();
            if (root == null) {
                return;
            }
            listtool.printTree(root, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected static void printTree(VBaseNode v, int indent) {
        System.out.println(listtool.indent(indent));
        listtool.printNode(v, indent);
        Enumeration e = v.children();
        while (e != null && e.hasMoreElements()) {
            listtool.printTree((VBaseNode)e.nextElement(), indent + 1);
        }
        String spacing = listtool.indent(indent);
        if (spacing.length() > 3) {
            spacing = spacing.substring(0, spacing.length() - 2);
            if ((spacing = spacing + "______________________________________________________").length() < 76) {
                int newLen = 76 - spacing.length();
                for (int i = 0; i < newLen; ++i) {
                    spacing = spacing + "_";
                }
            }
        }
        System.out.println(spacing);
    }

    protected static String indent(int indent) {
        String ret = "";
        for (int i = 0; i < indent; ++i) {
            ret = ret + "|  ";
        }
        return ret;
    }

    protected static void printNode(VBaseNode v, int indent) {
        if (v instanceof FolderNode) {
            String spacing = listtool.indent(indent);
            if (spacing.length() > 3) {
                spacing = spacing.substring(0, spacing.length() - 3);
                spacing = spacing + "+--";
            } else {
                spacing = "+--";
            }
            System.out.println(spacing + v.getNodeName() + ": " + v.getName() + " (scope = " + v.getScope() + ")");
        } else if (v instanceof ToolNode) {
            String spacing = listtool.indent(indent);
            spacing = spacing.substring(0, spacing.length() - 3);
            String className = ((ToolNode)v).getClassName();
            if (!className.equals("LegacyAppTool.client.LaunchLegacyAppTool")) {
                System.out.println(spacing + "+--" + v.getNodeName() + " (scope = " + v.getScope() + ")");
                System.out.println(spacing + "|\t" + "name  = " + className);
            } else {
                System.out.println(spacing + "+--" + "Legacy Tool" + " (scope = " + v.getScope() + ")");
                Properties p = ((ToolNode)v).getParameters();
                if (p != null) {
                    System.out.println(spacing + "|\t" + "name    = " + p.getProperty("Name").trim());
                    System.out.println(spacing + "|\t" + "command = " + p.getProperty("Command").trim());
                    System.out.println(spacing + "|\t" + "type    = " + p.getProperty("Type").trim());
                } else {
                    System.out.println(spacing + "|\t" + "No Properties");
                }
            }
        } else if (v instanceof ToolBoxURLNode) {
            String spacing = listtool.indent(indent);
            spacing = spacing.substring(0, spacing.length() - 3);
            String tbxURL = ((ToolBoxURLNode)v).getURL().toString().trim();
            System.out.println(spacing + "+--" + v.getNodeName() + " (scope = " + v.getScope() + ")");
            System.out.println(spacing + "|\t" + "tbxURL = " + tbxURL);
        } else if (v instanceof ToolBoxNode) {
            System.out.println(listtool.indent(indent) + v.getNodeName() + ": " + v.getName() + " (scope = " + v.getScope() + ")");
        }
    }
}

