/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viperimpl.console.config.BGImageNode;
import com.sun.management.viperimpl.console.config.ConfigurationException;
import com.sun.management.viperimpl.console.config.FolderNode;
import com.sun.management.viperimpl.console.config.PropertiesNode;
import com.sun.management.viperimpl.console.config.ToolBoxNode;
import com.sun.management.viperimpl.console.config.ToolBoxURLNode;
import com.sun.management.viperimpl.console.config.ToolNode;
import com.sun.management.viperimpl.console.config.VBaseNode;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import com.sun.management.viperimpl.console.config.myResolver;
import com.sun.management.viperimpl.console.config.myXmlDocumentBuilder;
import com.sun.xml.parser.Parser;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.ElementFactory;
import com.sun.xml.tree.SimpleElementFactory;
import com.sun.xml.tree.XmlDocument;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class VBaseConfiguration
extends XmlDocument {
    protected ToolBoxNode rootNode;
    protected static String viperPublicId = "-//Sun Microsystems, Inc.//Solaris Management Console Toolbox//EN";
    protected static String viperSystemId = "http://www.sun.com/solaris/management/toolbox.dtd";
    protected URL baseURL;
    protected boolean rawtext = false;
    protected static boolean defValidate = true;
    protected static boolean defRawtext = false;
    protected static Locale defLocale = null;
    protected Hashtable definedScopes = new Hashtable();

    protected VBaseConfiguration() {
    }

    public static VBaseConfiguration createConfiguration() {
        VBaseConfiguration vb = new VBaseConfiguration();
        vb.rawtext = true;
        vb.baseURL = null;
        myXmlDocumentBuilder builder = new myXmlDocumentBuilder(vb);
        Properties props = new Properties();
        SimpleElementFactory factory = new SimpleElementFactory();
        String pkg = ((Object)((Object)vb)).getClass().getPackage().getName();
        props.setProperty("Folder", pkg + ".FolderNode");
        props.setProperty("Tool", pkg + ".ToolNode");
        props.setProperty("Properties", pkg + ".PropertiesNode");
        props.setProperty("ToolBoxURL", pkg + ".ToolBoxURLNode");
        props.setProperty("BackgroundImage", pkg + ".BGImageNode");
        props.setProperty("ToolBox", pkg + ".ToolBoxNode");
        props.setProperty("*Element", pkg + ".GenericElement");
        factory.addMapping((Dictionary)props, ((Object)((Object)vb)).getClass().getClassLoader());
        vb.setElementFactory((ElementFactory)factory);
        vb.setDoctype(viperPublicId, viperSystemId, null);
        vb.rootNode = (ToolBoxNode)((Object)vb.getDocumentElement());
        return vb;
    }

    public static VBaseConfiguration createConfiguration(URL url) throws ConfigurationException {
        return VBaseConfiguration.createConfiguration(url, defLocale, defValidate, defRawtext);
    }

    public static VBaseConfiguration createConfiguration(URL url, Locale l) throws ConfigurationException {
        if (url == null) {
            return VBaseConfiguration.createConfiguration();
        }
        return VBaseConfiguration.createConfiguration(url, l, defValidate, defRawtext);
    }

    public static VBaseConfiguration createConfiguration(URL url, boolean validate) throws ConfigurationException {
        return VBaseConfiguration.createConfiguration(url, defLocale, validate, defRawtext);
    }

    public static VBaseConfiguration createConfiguration(URL url, boolean validate, boolean rawtext) throws ConfigurationException {
        return VBaseConfiguration.createConfiguration(url, defLocale, validate, rawtext);
    }

    public static VBaseConfiguration createConfiguration(URL url, Locale locale, boolean validate, boolean rawtext) throws ConfigurationException {
        try {
            Parser parser;
            VBaseConfiguration vb = new VBaseConfiguration();
            vb.rawtext = rawtext;
            vb.baseURL = url;
            myXmlDocumentBuilder builder = new myXmlDocumentBuilder(vb);
            InputSource input = VBaseConfiguration.createLocalizedInputSource(url, locale, false);
            Properties props = new Properties();
            SimpleElementFactory factory = new SimpleElementFactory();
            String pkg = "com.sun.management.viperimpl.console.config";
            if (validate) {
                parser = new ValidatingParser(true);
                props.setProperty("Folder", pkg + ".FolderNode");
                props.setProperty("Tool", pkg + ".ToolNode");
                props.setProperty("Properties", pkg + ".PropertiesNode");
                props.setProperty("ToolBoxURL", pkg + ".ToolBoxURLNode");
                props.setProperty("BackgroundImage", pkg + ".BGImageNode");
            } else {
                parser = new Parser();
            }
            props.setProperty("ToolBox", pkg + ".ToolBoxNode");
            props.setProperty("*Element", pkg + ".GenericElement");
            factory.addMapping((Dictionary)props, ((Object)((Object)vb)).getClass().getClassLoader());
            vb.setElementFactory((ElementFactory)factory);
            parser.setEntityResolver((EntityResolver)((Object)new myResolver(vb.baseURL)));
            parser.setDocumentHandler((DocumentHandler)((Object)builder));
            parser.parse(input);
            vb.setDoctype(viperPublicId, viperSystemId, null);
            vb.rootNode = (ToolBoxNode)((Object)vb.getDocumentElement());
            return vb;
        }
        catch (SAXParseException e) {
            String errString = "** Parsing error, line " + e.getLineNumber() + (e.getColumnNumber() >= 0 ? ", column " + e.getColumnNumber() : "") + ", uri " + e.getSystemId();
            System.out.println(errString);
            System.out.println("   " + e.getMessage());
            throw new ConfigurationException(errString, e);
        }
        catch (Exception e) {
            throw new ConfigurationException("", e);
        }
    }

    public static InputSource createLocalizedInputSource(URL uri, Locale locale, boolean checkType) throws IOException {
        InputSource retval;
        URLConnection uc = uri.openConnection();
        if (locale != null) {
            uc.setRequestProperty("Locale", locale.toString());
        }
        if (checkType) {
            String contentType = uc.getContentType();
            retval = Resolver.createInputSource((String)contentType, (InputStream)uc.getInputStream(), (boolean)false, (String)uri.getProtocol());
        } else {
            retval = Resolver.createInputSource(null, (InputStream)uc.getInputStream(), (boolean)false, (String)uri.getProtocol());
        }
        retval.setSystemId(uc.getURL().toString());
        return retval;
    }

    public String getID() {
        return this.rootNode.getName();
    }

    public VConfigurationNode getRootNode() {
        return this.rootNode;
    }

    boolean isRawText() {
        return this.rawtext;
    }

    public VConfigurationInfo getInfo() {
        return new VConfigurationInfo(null, this.baseURL, this.rootNode.getLocale(), this.rootNode.getName(), this.rootNode.getDescription(), this.rootNode.getType(), this.rootNode.getSmallIcon(), this.rootNode.getLargeIcon());
    }

    public Enumeration enumerateScopes() {
        return this.definedScopes.keys();
    }

    String getServerName() {
        String host = "";
        if (this.baseURL != null) {
            host = this.baseURL.getHost();
        }
        if (host.equals("")) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                host = "localhost";
            }
        }
        return host;
    }

    public ToolNode createToolNode(String serverName, int serverPort, String className, boolean autoLoad, boolean backgroundLoad, String scope, Properties properties, String name, String description, String smallIcon, String largeIcon) {
        ToolNode node = (ToolNode)this.createElementEx("Tool");
        node.setScope(scope);
        node.setClassName(className);
        node.setServerName(serverName);
        node.setServerPort(serverPort);
        node.setAutoLoad(autoLoad);
        node.setBackgroundLoad(backgroundLoad);
        node.setParameters(properties);
        node.setName(name);
        node.setDescription(description);
        node.setSmallIcon(smallIcon);
        node.setLargeIcon(largeIcon);
        return node;
    }

    public ToolNode createToolNode(String serverName, int serverPort, String className, boolean autoLoad, boolean backgroundLoad, String scope, Properties properties) {
        return this.createToolNode(serverName, serverPort, className, autoLoad, backgroundLoad, scope, properties, null, null, null, null);
    }

    public ToolNode createToolNode(String serverName, String className, boolean autoLoad, boolean backgroundLoad, String scope, Properties properties) {
        return this.createToolNode(serverName, -1, className, autoLoad, backgroundLoad, scope, properties);
    }

    public PropertiesNode createPropertiesNode(Properties properties) {
        PropertiesNode node = (PropertiesNode)this.createElementEx("Properties");
        node.setProperties(properties);
        return node;
    }

    public BGImageNode createBGImageNode(String url, String location) {
        BGImageNode node = (BGImageNode)this.createElementEx("BackgroundImage");
        node.setURL(url);
        node.setLocation(location);
        return node;
    }

    public FolderNode createFolderNode(String name, String description, String smallIcon, String largeIcon, String scope) {
        FolderNode node = (FolderNode)this.createElementEx("Folder");
        node.setName(name);
        node.setDescription(description);
        node.setSmallIcon(smallIcon);
        node.setLargeIcon(largeIcon);
        node.setScope(scope);
        return node;
    }

    public ToolBoxURLNode createToolBoxURLNode(String url) {
        ToolBoxURLNode node = (ToolBoxURLNode)this.createElementEx("ToolBoxURL");
        node.setURL(url);
        return node;
    }

    public ToolBoxNode createToolBoxNode(String name, String description, String information, String type, String smallIcon, String largeIcon, String scope, Properties properties) {
        ToolBoxNode node = (ToolBoxNode)this.createElementEx("ToolBox");
        node.setName(name);
        node.setDescription(description);
        node.setInformation(information);
        node.setSmallIcon(smallIcon);
        node.setLargeIcon(largeIcon);
        node.setScope(scope);
        return node;
    }

    public ToolBoxNode createToolBoxNode(String name, String description, String type, String smallIcon, String largeIcon, String scope, Properties properties) {
        return this.createToolBoxNode(name, description, null, type, smallIcon, largeIcon, scope, properties);
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length != 1) {
            System.err.println("Usage: $0 <config file>");
            System.exit(1);
        }
        try {
            VBaseConfiguration conf;
            try {
                conf = VBaseConfiguration.createConfiguration(new URL(argv[0]), true, true);
            }
            catch (MalformedURLException e) {
                conf = VBaseConfiguration.createConfiguration(new File(argv[0]).toURL(), true, true);
            }
            VBaseNode root = (VBaseNode)conf.getRootNode();
            System.out.println("\nPrinting Document");
            root.printTree(0);
            System.out.println("\nPrinting Document XML");
            conf.write(System.out);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

