/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.core;

import com.sun.web.core.ApplicationSession;
import com.sun.web.core.Context;
import com.sun.web.core.ServerSessionManager;
import java.util.Enumeration;
import java.util.Hashtable;

public class ServerSession {
    private Hashtable values = new Hashtable();
    private Hashtable appSessions = new Hashtable();
    private String id;
    private long creationTime;
    private long thisAccessTime = this.creationTime = System.currentTimeMillis();
    private long lastAccessed = this.creationTime;
    private int inactiveInterval = -1;

    ServerSession(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessed;
    }

    public ApplicationSession getApplicationSession(Context context, boolean bl) {
        ApplicationSession applicationSession = (ApplicationSession)this.appSessions.get(context);
        if (applicationSession == null && bl) {
            applicationSession = new ApplicationSession(this.id, this, context);
            this.appSessions.put(context, applicationSession);
        }
        return applicationSession;
    }

    void removeApplicationSession(Context context) {
        this.appSessions.remove(context);
    }

    void accessed() {
        this.lastAccessed = this.thisAccessTime;
        this.thisAccessTime = System.currentTimeMillis();
    }

    void validate() {
        int n;
        if (this.inactiveInterval != -1 && (n = (int)(System.currentTimeMillis() - this.lastAccessed) / 1000) > this.inactiveInterval) {
            this.invalidate();
            ServerSessionManager serverSessionManager = ServerSessionManager.getManager();
            serverSessionManager.removeSession(this);
        }
    }

    synchronized void invalidate() {
        Enumeration enumeration = this.appSessions.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            ApplicationSession applicationSession = (ApplicationSession)this.appSessions.get(k);
            applicationSession.invalidate();
        }
    }

    public void putValue(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException("putValue() called with a null value name");
        }
        this.removeValue(string);
        this.values.put(string, object);
    }

    public Object getValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("getValue() called with a null value name");
        }
        return this.values.get(string);
    }

    public Enumeration getValueNames() {
        return this.values.keys();
    }

    public void removeValue(String string) {
        this.values.remove(string);
    }

    public void setMaxInactiveInterval(int n) {
        this.inactiveInterval = n;
    }

    public int getMaxInactiveInterval() {
        return this.inactiveInterval;
    }

    synchronized void reap() {
        Enumeration enumeration = this.appSessions.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            ApplicationSession applicationSession = (ApplicationSession)this.appSessions.get(k);
            applicationSession.validate();
        }
    }
}

