/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.core;

import com.sun.web.core.Context;
import com.sun.web.core.ServerSession;
import com.sun.web.core.SessionContextImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

public class ApplicationSession
implements HttpSession {
    private Hashtable values = new Hashtable();
    private String id;
    private ServerSession serverSession;
    private Context context;
    private long creationTime;
    private long thisAccessTime = this.creationTime = System.currentTimeMillis();
    private long lastAccessed = this.creationTime;
    private int inactiveInterval = -1;
    private boolean valid = true;

    ApplicationSession(String string, ServerSession serverSession, Context context) {
        this.serverSession = serverSession;
        this.context = context;
        this.id = string;
    }

    void accessed() {
        this.lastAccessed = this.thisAccessTime;
        this.thisAccessTime = System.currentTimeMillis();
        this.validate();
    }

    void validate() {
        int n;
        if (this.inactiveInterval != -1 && (n = (int)(System.currentTimeMillis() - this.lastAccessed) / 1000) > this.inactiveInterval) {
            this.invalidate();
        }
    }

    public String getId() {
        if (this.valid) {
            return this.id;
        }
        String string = "getId() called on invalid session";
        throw new IllegalStateException(string);
    }

    public long getCreationTime() {
        if (this.valid) {
            return this.creationTime;
        }
        String string = "getCreationTime() called on invalid session";
        throw new IllegalStateException(string);
    }

    public HttpSessionContext getSessionContext() {
        return new SessionContextImpl();
    }

    public long getLastAccessedTime() {
        if (this.valid) {
            return this.lastAccessed;
        }
        String string = "getLastAccessedTime() called on invalid session";
        throw new IllegalStateException(string);
    }

    public void invalidate() {
        this.serverSession.removeApplicationSession(this.context);
        Enumeration enumeration = this.values.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.removeValue(string);
        }
        this.valid = false;
    }

    public boolean isNew() {
        if (!this.valid) {
            String string = "isNew() called on invalid session";
            throw new IllegalStateException(string);
        }
        return this.thisAccessTime == this.creationTime;
    }

    public void putValue(String string, Object object) {
        if (!this.valid) {
            String string2 = "putValue() called on invalid session";
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            throw new IllegalArgumentException("putValue() called with a null value name");
        }
        this.removeValue(string);
        if (object != null && object instanceof HttpSessionBindingListener) {
            HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent(this, string);
            ((HttpSessionBindingListener)object).valueBound(httpSessionBindingEvent);
        }
        this.values.put(string, object);
    }

    public Object getValue(String string) {
        if (!this.valid) {
            String string2 = "getValue() called on invalid session";
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            throw new IllegalArgumentException("getValue() called with a null value name");
        }
        return this.values.get(string);
    }

    public String[] getValueNames() {
        if (!this.valid) {
            String string = "getValueNames() called on invalid session";
            throw new IllegalStateException(string);
        }
        String[] stringArray = new String[this.values.size()];
        int n = 0;
        Enumeration enumeration = this.values.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public void removeValue(String string) {
        if (!this.valid) {
            String string2 = "removeValue() called on invalid session";
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            throw new IllegalArgumentException("removeValue() called with a null value name");
        }
        Object v = this.values.get(string);
        if (v instanceof HttpSessionBindingListener) {
            HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent(this, string);
            ((HttpSessionBindingListener)v).valueUnbound(httpSessionBindingEvent);
        }
        this.values.remove(string);
    }

    public void setMaxInactiveInterval(int n) {
        if (!this.valid) {
            String string = "setMaxInactiveInterval() called on invalid session";
            throw new IllegalStateException(string);
        }
        this.inactiveInterval = n;
    }

    public int getMaxInactiveInterval() {
        if (!this.valid) {
            String string = "getMaxInactiveInterval() called on invalid session";
            throw new IllegalStateException(string);
        }
        return this.inactiveInterval;
    }
}

