/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.client;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.services.authentication.DigestAuthFlavor;
import com.sun.management.viperimpl.services.authentication.DigestSecurityUtil;
import com.sun.management.viperimpl.services.authentication.client.ClientSecurityContext;
import com.sun.management.viperimpl.services.authentication.client.ClientSecurityFactory;
import com.sun.management.viperimpl.services.authentication.client.DigestClientSecurityContext;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;

public class DigestClientSecurityFactory
implements ClientSecurityFactory {
    private DigestAuthFlavor initDaf;
    private DigestClientSecurityContext initCsc;

    public void init(Properties props) throws AuthenticationException {
        Provider sp;
        DigestAuthFlavor daf = new DigestAuthFlavor();
        String provider = "SUN";
        if (props != null) {
            String value = props.getProperty("auth.digest.provider");
            if (value != null) {
                provider = value;
            }
            if ((value = props.getProperty("auth.digest.digest.algo")) != null) {
                daf.setDigestAlgorithm(value);
            }
            if ((value = props.getProperty("auth.digest.sign.algo")) != null) {
                daf.setSignatureAlgorithm(value);
            }
            if ((value = props.getProperty("auth.digest.key.algo")) != null) {
                daf.setKeyGenerationAlgorithm(value);
            }
            if ((value = props.getProperty("auth.digest.key.strength")) != null) {
                int size = 0;
                try {
                    size = new Integer(value);
                }
                catch (Exception ex) {
                    size = 0;
                }
                if (size > 0) {
                    daf.setKeyStrength(size);
                }
            }
        }
        if ((sp = Security.getProvider(provider)) == (Provider)null) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("Security provider not installed: " + provider), null);
            throw new AuthenticationException("Security provider not installed: ", (Object)provider);
        }
        DigestSecurityUtil.initialize(sp, daf.getDigestAlgorithm(), daf.getSignatureAlgorithm(), daf.getKeyGenerationAlgorithm(), daf.getKeyStrength());
        this.initDaf = daf;
        this.initCsc = new DigestClientSecurityContext(daf);
    }

    public AuthenticationFlavor getAuthFlavor() throws AuthenticationException {
        AuthenticationFlavor af = null;
        if (this.initDaf != null) {
            af = this.initDaf.newCopy();
        }
        return af;
    }

    public ClientSecurityContext getClientSecurityContext() throws AuthenticationException {
        ClientSecurityContext csc = null;
        if (this.initCsc != null) {
            csc = this.initCsc.newCopy();
        }
        return csc;
    }
}

