/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.client;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationMessageException;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.services.authentication.AuthenticationLoginException;
import com.sun.management.viperimpl.services.authentication.AuthenticationPrincipal;
import com.sun.management.viperimpl.services.authentication.AuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.ConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.Crypt;
import com.sun.management.viperimpl.services.authentication.DigestAuthFlavor;
import com.sun.management.viperimpl.services.authentication.DigestAuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestMessageSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestSecurityUtil;
import com.sun.management.viperimpl.services.authentication.MessageSecurityToken;
import com.sun.management.viperimpl.services.authentication.RequestSecurityToken;
import com.sun.management.viperimpl.services.authentication.ResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.client.ClientSecurityContext;

public class DigestClientSecurityContext
extends ClientSecurityContext {
    private byte[] serverkey = null;
    private byte[] serverchg = null;
    private byte[] clientchg;
    private byte[] sessionkey = null;
    private byte[] hashpswd = null;
    private byte[] salt = null;
    private boolean integrity = false;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestClientSecurityContext(DigestAuthFlavor flavor) throws AuthenticationException {
        super(flavor);
    }

    public RequestSecurityToken generateRequestToken() throws AuthenticationException {
        AuthenticationPrincipal ap = this.getAuthPrincipal();
        if (ap == (AuthenticationPrincipal)null || this.getUserPassword() == (String)null) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)"Missing user name or password in client security context", null);
            throw new AuthenticationException("EXSS_NUI");
        }
        RequestSecurityToken rtok = new RequestSecurityToken(this.getAuthFlavor(), ap);
        this.setAuthState(1);
        this.setSecurityToken(rtok);
        return rtok;
    }

    public AuthenticatorSecurityToken verifyResponseToken(ResponseSecurityToken responseToken) throws AuthenticationException {
        DigestResponseSecurityToken dtok = null;
        try {
            dtok = (DigestResponseSecurityToken)responseToken;
        }
        catch (Exception ex) {
            throw new AuthenticationException("EXSS_BRT");
        }
        long sid = dtok.getSecurityId();
        this.setSecurityId(sid);
        this.serverchg = dtok.getChallenge();
        this.salt = dtok.getPasswordSalt();
        this.serverkey = dtok.getServerKey();
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Verifying server response...", null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   Id=" + sid), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   challenge=" + this.toHex(this.serverchg)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   salt=" + this.toHex(this.salt)), null);
        String userpswd = this.getUserPassword();
        byte[] pwb = userpswd.getBytes();
        this.hashpswd = null;
        if (userpswd != (String)null) {
            Crypt cs = new Crypt();
            this.hashpswd = cs.crypt(pwb, this.salt);
        }
        if (this.hashpswd == null) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Cannot generate encrypted password", null);
            throw new AuthenticationException("EXSS_BUP");
        }
        this.sessionkey = DigestSecurityUtil.getSessionKey();
        byte[] digest = DigestSecurityUtil.generateDigest(this.serverchg, this.hashpswd, null);
        byte[] msg_digest = DigestSecurityUtil.encryptPassword(digest, pwb);
        byte[] ses_digest = DigestSecurityUtil.encryptDigest(this.sessionkey, digest);
        byte[] kb = new byte[32];
        DigestSecurityUtil.getRandomBytes(kb);
        byte[] authenticator = DigestSecurityUtil.generateDigest(msg_digest, kb, pwb);
        this.clientchg = new byte[16];
        DigestSecurityUtil.getRandomBytes(this.clientchg);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Generating client authenticator...", null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   digest=" + this.toHex(msg_digest)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   auth=" + this.toHex(authenticator)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   challenge=" + this.toHex(this.clientchg)), null);
        DigestAuthenticatorSecurityToken rtok = new DigestAuthenticatorSecurityToken(sid);
        rtok.setMessageDigest(msg_digest);
        rtok.setAuthenticatorDigest(authenticator);
        rtok.setSessionDigest(ses_digest);
        rtok.setChallenge(this.clientchg);
        rtok.setClientKey(kb);
        this.setAuthState(3);
        return rtok;
    }

    public void verifyConfirmToken(ConfirmSecurityToken confirmToken) throws AuthenticationException {
        long htpd;
        DigestConfirmSecurityToken dtok;
        try {
            dtok = (DigestConfirmSecurityToken)confirmToken;
        }
        catch (Exception ex) {
            throw new AuthenticationException("EXSS_BCT");
        }
        byte[] rb = dtok.getResultMessage().getBytes();
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Verifying confirm...", null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   Result=" + dtok.getResultMessage()), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   digest=" + this.toHex(dtok.getMessageDigest())), null);
        byte[] digest = DigestSecurityUtil.generateDigest(this.clientchg, this.hashpswd, rb);
        if (!DigestSecurityUtil.compareDigests(digest, dtok.getMessageDigest())) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Confirmation digests differ", null);
            throw new AuthenticationLoginException();
        }
        if (dtok.isIntegrityRequired()) {
            this.integrity = true;
        }
        if ((htpd = confirmToken.getHeartbeatPeriod()) > 0L) {
            htpd /= 2L;
        }
        this.setHeartbeatPeriod(htpd);
        this.setAuthState(4);
        this.setSecurityToken(confirmToken);
    }

    public MessageSecurityToken generateMessageToken(Object[] objs) throws AuthenticationException {
        if (this.getAuthState() != 4) {
            throw new AuthenticationException("EXSS_VBA");
        }
        long sid = this.getSecurityId();
        DigestMessageSecurityToken vtok = new DigestMessageSecurityToken(sid);
        byte[] digest = this.serverchg;
        if (this.isIntegrityRequired() && objs != null && objs.length > 0) {
            digest = DigestSecurityUtil.generateDigest(objs);
        }
        byte[] msg_digest = DigestSecurityUtil.encryptDigest(digest, this.sessionkey);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("Generating message authenticator: digest=" + this.toHex(digest)), null);
        vtok.setDigest(msg_digest);
        return vtok;
    }

    public void verifyMessageToken(MessageSecurityToken messageToken, Object obj) throws AuthenticationException {
        byte[] e_digest;
        byte[] c_digest;
        DigestMessageSecurityToken dtok;
        try {
            dtok = (DigestMessageSecurityToken)messageToken;
        }
        catch (Exception ex) {
            throw new AuthenticationException("EXSS_BVT");
        }
        byte[] s_digest = this.serverchg;
        if (this.isIntegrityRequired() && obj != null) {
            Object[] objs = new Object[]{obj};
            s_digest = DigestSecurityUtil.generateDigest(objs);
        }
        if ((c_digest = DigestSecurityUtil.encryptDigest(e_digest = dtok.getDigest(), this.sessionkey)) == null) {
            throw new AuthenticationException("EXSS_BVD");
        }
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Verifying message return...", null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   server digest=" + this.toHex(s_digest)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   client digest=" + this.toHex(c_digest)), null);
        if (!DigestSecurityUtil.compareDigests(s_digest, c_digest)) {
            throw new AuthenticationMessageException();
        }
    }

    public byte[] encryptPassword(String password) throws AuthenticationException {
        int i;
        if (this.getAuthState() != 4) {
            throw new AuthenticationException("EXSS_NAX", (Object)"encryptPassword");
        }
        if (password == null || (i = password.trim().length()) == 0 || i > 16) {
            throw new AuthenticationException("EXSS_BUP");
        }
        byte[] pwb = password.getBytes();
        byte[] digest = DigestSecurityUtil.generateDigest(this.serverchg, this.hashpswd, null);
        digest = DigestSecurityUtil.encryptPassword(digest, pwb);
        return digest;
    }

    public ClientSecurityContext newCopy() throws AuthenticationException {
        DigestClientSecurityContext nctx = new DigestClientSecurityContext((DigestAuthFlavor)this.getAuthFlavor());
        super.copyAttrs(nctx);
        nctx.setServerKey(this.serverkey);
        nctx.setServerChallenge(this.serverchg);
        nctx.setClientChallenge(this.clientchg);
        nctx.setPasswordHash(this.hashpswd);
        nctx.setPasswordSalt(this.salt);
        if (this.integrity) {
            nctx.setIntegrity();
        }
        return nctx;
    }

    public void setServerKey(byte[] key) {
        this.serverkey = key;
    }

    public void setServerChallenge(byte[] value) {
        if (value != null) {
            this.serverchg = new byte[value.length];
            System.arraycopy(value, 0, this.serverchg, 0, value.length);
        } else {
            this.serverchg = null;
        }
    }

    public void setClientChallenge(byte[] value) {
        if (value != null) {
            this.clientchg = new byte[value.length];
            System.arraycopy(value, 0, this.clientchg, 0, value.length);
        } else {
            this.clientchg = null;
        }
    }

    public void setPasswordHash(byte[] pswdHash) {
        if (pswdHash != null) {
            this.hashpswd = new byte[pswdHash.length];
            System.arraycopy(pswdHash, 0, this.hashpswd, 0, pswdHash.length);
        } else {
            this.hashpswd = null;
        }
    }

    public void setPasswordSalt(byte[] pswdSalt) {
        if (pswdSalt != null) {
            this.salt = new byte[pswdSalt.length];
            System.arraycopy(pswdSalt, 0, this.salt, 0, pswdSalt.length);
        } else {
            this.salt = null;
        }
    }

    public byte[] getServerKey() {
        return this.serverkey;
    }

    public boolean isIntegrityRequired() {
        return this.integrity;
    }

    public void setIntegrity() {
        this.integrity = true;
    }

    private String toHex(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(hex[data[i] >> 4 & 0xF]);
            sb.append(hex[data[i] & 0xF]);
        }
        return sb.toString();
    }
}

