/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viperimpl.services.authentication.AuthenticationPrincipal;
import java.security.Provider;
import java.util.Date;

public abstract class SecurityContext {
    public static final String AUTH_SERVICE_NAME = "Authentication Service";
    public static final String AUTH_LOG_SERVICE_NAME = "LMS_AuthSvcName";
    public static final int AUTH_LOG_SECURITY = 1;
    public static final int AUTH_LOG_INFO = 100;
    public static final int AUTH_LOG_WARN = 300;
    public static final int AUTH_LOG_ERROR = 400;
    protected static final int MAX_PASSWORD_SIZE = 16;
    protected static final int PUBLIC_KEY_SIZE = 32;
    protected static final int DIGEST_CHALLENGE_SIZE = 16;
    protected static final String DIGEST_RESULT_MESSAGE = "success";
    protected static final String WEAK_PASSWORD_HASHKEY = "pAsSwOrDsEcUrItY";
    AuthenticationFlavor authFlvr;
    Provider authProv;
    AuthenticationPrincipal authPrin;
    long secId;
    int authState;
    Date birthday = new Date();
    long htbtPeriod = -1L;

    public SecurityContext(AuthenticationFlavor authFlavor) throws AuthenticationException {
        this.authFlvr = authFlavor.newCopy();
    }

    public int getAuthState() {
        return this.authState;
    }

    public AuthenticationFlavor getAuthFlavor() {
        return this.authFlvr;
    }

    public int getAuthType() {
        return this.authFlvr.getAuthType();
    }

    public Provider getAuthProvider() {
        return this.authProv;
    }

    public void setAuthProvider(Provider securityProvider) {
        this.authProv = securityProvider;
    }

    public AuthenticationPrincipal getAuthPrincipal() {
        return this.authPrin;
    }

    public Date getStartTime() {
        return this.birthday;
    }

    public void setAuthPrincipal(AuthenticationPrincipal authPrince) {
        this.authPrin = authPrince;
    }

    public long getSecurityId() {
        return this.secId;
    }

    public void setSecurityId(long securityId) {
        this.secId = securityId;
    }

    public long getHeartbeatPeriod() {
        return this.htbtPeriod;
    }

    public void setHeartbeatPeriod(long period) {
        this.htbtPeriod = period;
    }

    protected void copyAttrs(SecurityContext sctx) throws AuthenticationException {
        sctx.setAuthState(this.authState);
        sctx.setAuthProvider(this.authProv);
        sctx.setAuthPrincipal(this.authPrin);
        sctx.setSecurityId(this.secId);
        sctx.setHeartbeatPeriod(this.htbtPeriod);
    }

    protected void setAuthState(int auth_state) {
        this.authState = auth_state;
    }
}

