/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication;

import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viperimpl.services.authentication.AuthenticationPrincipal;
import com.sun.management.viperimpl.services.authentication.SecurityToken;
import java.net.InetAddress;

public class RequestSecurityToken
extends SecurityToken {
    static final long serialVersionUID = 2108525403233184591L;
    AuthenticationFlavor authFlvr;
    AuthenticationPrincipal authPrince;
    String clientHost;
    String clientVMID;

    public RequestSecurityToken(AuthenticationFlavor authFlavor, AuthenticationPrincipal authPrincipal) {
        super(authFlavor.getAuthType());
        this.authFlvr = authFlavor;
        this.authPrince = authPrincipal;
        this.setAuthState(1);
        this.setSecurityId(0L);
        this.clientHost = null;
        try {
            this.clientHost = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception x) {
            this.clientHost = "??";
        }
        this.clientVMID = this.clientHost + this.getClass().hashCode();
    }

    public AuthenticationFlavor getAuthFlavor() {
        return this.authFlvr;
    }

    public AuthenticationPrincipal getAuthPrincipal() {
        return this.authPrince;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public String getClientVMID() {
        return this.clientVMID;
    }

    public String toString() {
        String str = super.toString();
        str = str.concat(", user=" + this.authPrince.toString());
        str = str.concat(", client=" + this.clientHost);
        return str;
    }
}

