/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;

public class DigestAuthFlavor
extends AuthenticationFlavor {
    static final long serialVersionUID = -2978787611373832107L;
    public static final String AUTH_DIGEST_PROP_PREFIX = "auth.digest.";
    public static final String AUTH_DIGEST_PROVIDER_PROP = "auth.digest.provider";
    public static final String AUTH_DIGEST_PROVIDER_DFLT = "SUN";
    public static final String AUTH_DIGEST_DIGEST_ALGO_PROP = "auth.digest.digest.algo";
    public static final String AUTH_DIGEST_DIGEST_ALGO_DFLT = "SHA";
    public static final String AUTH_DIGEST_SIGN_ALGO_PROP = "auth.digest.sign.algo";
    public static final String AUTH_DIGEST_SIGN_ALGO_DFLT = "DSA";
    public static final String AUTH_DIGEST_KEYGEN_ALGO_PROP = "auth.digest.key.algo";
    public static final String AUTH_DIGEST_KEYGEN_ALGO_DFLT = "DSA";
    public static final String AUTH_DIGEST_KEYGEN_SIZE_PROP = "auth.digest.key.strength";
    public static final String AUTH_DIGEST_KEYGEN_SIZE_DFLT = "1024";
    public static final int AUTH_DIGEST_KEYGEN_SIZE_MAX = 1024;
    public static final String AUTH_DIGEST_MSG_INTG_PROP = "auth.digest.msg.integrity";
    public static final String AUTH_DIGEST_MSG_INTG_DFLT = "on";
    private String digestAlgo;
    private String signAlgo;
    private String keyAlgo;
    private int strength;

    public DigestAuthFlavor() throws AuthenticationException {
        super(0);
        this.digestAlgo = AUTH_DIGEST_DIGEST_ALGO_DFLT;
        this.signAlgo = "DSA";
        this.keyAlgo = "DSA";
        this.strength = new Integer(AUTH_DIGEST_KEYGEN_SIZE_DFLT);
    }

    public DigestAuthFlavor(String digestAlgorithm, String signAlgorithm, String keyAlgorithm, int signStrength) throws AuthenticationException {
        super(0);
        if (digestAlgorithm == null || digestAlgorithm.trim().length() == 0) {
            throw new AuthenticationException("EXSS_BSA", (Object)"Digest");
        }
        this.digestAlgo = digestAlgorithm;
        if (signAlgorithm == null || signAlgorithm.trim().length() == 0) {
            throw new AuthenticationException("EXSS_BSA", (Object)"Digest");
        }
        this.signAlgo = signAlgorithm;
        if (keyAlgorithm == null || keyAlgorithm.trim().length() == 0) {
            throw new AuthenticationException("EXSS_BSA", (Object)"Digest");
        }
        this.keyAlgo = keyAlgorithm;
        if (signStrength <= 0) {
            throw new AuthenticationException("EXSS_BKS", (Object)"Digest");
        }
        this.strength = signStrength;
    }

    public AuthenticationFlavor newCopy() throws AuthenticationException {
        DigestAuthFlavor daf = new DigestAuthFlavor(this.digestAlgo, this.signAlgo, this.keyAlgo, this.strength);
        return daf;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgo;
    }

    public void setDigestAlgorithm(String digestAlgorithm) throws AuthenticationException {
        if (digestAlgorithm == null || digestAlgorithm.trim().length() == 0) {
            throw new AuthenticationException("EXSS_BSA", (Object)"Digest");
        }
        this.digestAlgo = digestAlgorithm;
    }

    public String getSignatureAlgorithm() {
        return this.signAlgo;
    }

    public void setSignatureAlgorithm(String signAlgorithm) throws AuthenticationException {
        if (signAlgorithm == null || signAlgorithm.trim().length() == 0) {
            throw new AuthenticationException("EXSS_BSA", (Object)"Digest");
        }
        this.signAlgo = signAlgorithm;
    }

    public String getKeyGenerationAlgorithm() {
        return this.keyAlgo;
    }

    public void setKeyGenerationAlgorithm(String keyAlgorithm) throws AuthenticationException {
        if (keyAlgorithm == null || keyAlgorithm.trim().length() == 0) {
            throw new AuthenticationException("EXSS_BSA", (Object)"Digest");
        }
        this.keyAlgo = keyAlgorithm;
    }

    public int getKeyStrength() {
        return this.strength;
    }

    public void setKeyStrength(int signStrength) throws AuthenticationException {
        if (signStrength <= 0) {
            throw new AuthenticationException("EXSS_BKS", (Object)"Digest");
        }
        this.strength = signStrength;
    }
}

