/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.tty;

import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.VLocalizedInfo;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viperimpl.client.ViperClient;
import com.sun.management.viperimpl.console.BaseConsoleManager;
import com.sun.management.viperimpl.console.ManagedCredentials;
import com.sun.management.viperimpl.console.config.ToolNode;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import com.sun.management.viperimpl.console.tty.TTYPrivilegeManager;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.MessageFormat;

public class TTYConsoleManager
extends BaseConsoleManager {
    public TTYConsoleManager() {
        toolContext = "TC_APPLICATION_NONGUI";
    }

    public void setInitialOptions(String initialHostName, String initialUserName, String initialPassword, String initialRoleName, String initialRolePassword, String initialToolBox, String initialTool, AdminMgmtScope initialScope, String[] initialToolOptions, boolean trusted, boolean yesToAll, boolean silent, InputStream input, PrintStream output, PrintStream error) {
        super.setInitialOptions(initialHostName, initialUserName, initialPassword, initialRoleName, initialRolePassword, initialToolBox, initialTool, initialScope, initialToolOptions, trusted, yesToAll, silent, input, output, error);
        TTYPrivilegeManager mgr = new TTYPrivilegeManager();
        mgr.init(input, output, error, trusted);
        this.privilegeMgr = mgr;
        super.setPrivilegeManager();
    }

    public Tool openSingleTool(String toolClass, String host) throws Exception {
        this.shutDownLoadedTools();
        this.closeAuthenticatedSessions();
        this.initializeClientSet();
        this.initializeIgnoreClientSet();
        if (host == null) {
            host = localHost;
        }
        try {
            ViperClient stubClient = this.handleStubClient(host, toolClass, null, null);
            ToolInfo childInfo = this.handleToolInfo(stubClient, toolClass, null, null);
            AdminMgmtScope childScope = this.initialScope;
            this.handleSupportedContext(toolClass, null, childInfo, null, null, toolContext);
            this.handleSupportedScope(toolClass, null, childInfo, null, null, childScope);
            Tool tool = this.handleLoadTool(toolClass, host, null);
            this.handleToolInitialization(tool, childInfo, childScope, null, stubClient, toolClass, null);
            return tool;
        }
        catch (Throwable t) {
            throw new Exception();
        }
    }

    public int saveConsole() {
        return 1;
    }

    public int saveConsoleAs() {
        return 1;
    }

    public void editConsole() {
    }

    protected String promptUserForTool(String host) {
        return null;
    }

    protected URL promptUserForToolbox() {
        return null;
    }

    protected boolean handlePrimaryLogin(ViperClient client, ManagedCredentials authInfo) throws Exception {
        client.login(authInfo);
        return true;
    }

    protected boolean handleRoleLogin(ViperClient client, ManagedCredentials authInfo) throws Exception {
        return true;
    }

    protected ManagedCredentials promptUserForAuthInfo(String host, int port, String domain, boolean isRetryAttempt) {
        return null;
    }

    protected ManagedCredentials promptUserForRoleInfo(ManagedCredentials authInfo, String domain, VIdentity[] roleList, boolean isRetryAttempt) {
        return authInfo;
    }

    protected boolean promptUserToRetryLogin(String host, boolean retriesExceeded) {
        return false;
    }

    protected void unexpectedException(String toolClass, VConfigurationNode child, VScopeNode parent, Throwable throwable) {
        if (unknownError == null) {
            unknownError = new MessageFormat(ImplResourceManager.getString("UnknownError"));
        }
        if (!this.silent) {
            this.errorS.println(unknownError.format(new Object[]{toolClass}));
            if (throwable != null) {
                throwable.printStackTrace(this.errorS);
            }
        }
        System.exit(1);
    }

    protected void noServerFound(String toolClass, String host, ToolNode child, VScopeNode parent, Throwable throwable) {
        if (hostNotFound == null) {
            hostNotFound = new MessageFormat(ImplResourceManager.getString("HostNotFound"));
        }
        if (!this.silent) {
            this.errorS.println(hostNotFound.format(new Object[]{host}));
        }
        System.exit(1);
    }

    protected void noServerRunningOnHost(String host, ToolNode child, VScopeNode parent, Throwable throwable) {
        if (serverNotRunning == null) {
            serverNotRunning = new MessageFormat(ImplResourceManager.getString("ServerNotRunning"));
        }
        if (!this.silent) {
            this.errorS.println(serverNotRunning.format(new Object[]{host}));
        }
        System.exit(1);
    }

    protected void toolNotFoundOnServer(String toolClass, ToolNode child, VScopeNode parent, Throwable throwable) {
        if (toolNotFound == null) {
            toolNotFound = new MessageFormat(ImplResourceManager.getString("UnknownTool"));
        }
        if (!this.silent) {
            this.errorS.println(toolNotFound.format(new Object[]{toolClass}));
        }
        System.exit(1);
    }

    protected void toolDoesNotHaveLocalizedInfo(String toolClass, ToolNode child, ToolInfo childInfo, VScopeNode parent, Throwable throwable) {
        if (locInfoNotFound == null) {
            locInfoNotFound = new MessageFormat(ImplResourceManager.getString("NoInfo"));
        }
        if (!this.silent) {
            this.errorS.println(locInfoNotFound.format(new Object[]{toolClass}));
        }
        System.exit(1);
    }

    protected void invalidScopeForTool(ToolNode child, VLocalizedInfo childInfo, VScopeNode parent, String badScope, Throwable throwable) {
        if (invalidScope == null) {
            invalidScope = new MessageFormat(ImplResourceManager.getString("BadScope"));
        }
        if (!this.silent) {
            this.errorS.println(invalidScope.format(new Object[]{badScope}));
        }
        System.exit(1);
    }

    protected void toolDoesNotSupportScope(String toolClass, ToolNode child, VLocalizedInfo childInfo, VScopeNode parent, AdminMgmtScope scope, Throwable throwable) {
        if (unsupportedScope == null) {
            unsupportedScope = new MessageFormat(ImplResourceManager.getString("ScopeNotSupported"));
        }
        if (!this.silent) {
            this.errorS.println(unsupportedScope.format(new Object[]{scope.toDirectoryTableURL(), toolClass}));
        }
        System.exit(1);
    }

    protected void toolDoesNotSupportContext(String toolClass, ToolNode child, VLocalizedInfo childInfo, VScopeNode parent, String context, Throwable throwable) {
        if (unsupportedContext == null) {
            unsupportedContext = new MessageFormat(ImplResourceManager.getString("ContextNotSupported"));
        }
        if (!this.silent) {
            this.errorS.println(unsupportedContext.format(new Object[]{toolContext, toolClass}));
        }
        System.exit(1);
    }

    protected void authenticationFailedForTool(String host, VScopeNode stubNode, Throwable t) {
        if (failedAuthentication == null) {
            failedAuthentication = new MessageFormat(ImplResourceManager.getString("FailedAuthentication"));
        }
        if (!this.silent) {
            this.errorS.println(failedAuthentication.format(new Object[]{host}));
        }
        System.exit(1);
    }

    protected void userCanceledAuthenticationForTool(String host, VScopeNode stubNode) {
        if (canceledAuthentication == null) {
            canceledAuthentication = new MessageFormat(ImplResourceManager.getString("AuthCancelled"));
        }
        if (!this.silent) {
            this.errorS.println(canceledAuthentication.format(new Object[]{host}));
        }
        System.exit(1);
    }

    protected void toolInitializationFailed(String toolClass, VScopeNode stubNode, Throwable t) {
        System.err.println(t.getLocalizedMessage());
    }

    protected VScopeNode addToolStubToParent(ToolNode child, VScopeNode parent, VLocalizedInfo info) {
        return null;
    }

    protected VScopeNode addToolToParent(ToolNode child, Tool tool, VScopeNode parent, VScopeNode childNode) {
        return null;
    }

    protected void loadOnlineHelpForTool(Tool tool, ToolInfo toolInfo) {
    }

    protected void establishWindowCommand(String command) {
    }

    protected void warnUserOfFailedToolbox(String toolbox, Throwable t) {
    }
}

