/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.tty;

import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Tool;
import com.sun.management.viper.console.VConsole;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VLogEvent;
import com.sun.management.viper.console.tty.VTTYConsole;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.console.BaseConsoleManager;
import com.sun.management.viperimpl.console.tty.TTYConsoleManager;
import java.io.InputStream;
import java.io.PrintStream;

public class SMCTerminal
extends VTTYConsole {
    protected String initialAuthData = null;
    protected String initialHostName = null;
    protected String initialUserName = null;
    protected String initialPassword = null;
    protected String initialRoleName = null;
    protected String initialRolePassword = null;
    protected String initialToolBox = null;
    protected String initialTool = null;
    protected AdminMgmtScope initialScope = null;
    protected String[] initialToolOptions = null;
    protected boolean trusted = false;
    protected boolean yesToAll = false;
    protected boolean silent = false;

    public SMCTerminal() {
        this.setLookAndFeel(null);
    }

    public void setInitialOptions(String initialAuthData, String initialHostName, String initialUserName, String initialPassword, String initialRoleName, String initialRolePassword, String initialToolBox, String initialTool, AdminMgmtScope initialScope, String[] initialToolOptions, boolean trusted, boolean yesToAll, boolean silent, InputStream input, PrintStream output, PrintStream error) {
        this.initialAuthData = initialAuthData;
        this.initialHostName = initialHostName;
        this.initialUserName = initialUserName;
        this.initialPassword = initialPassword;
        this.initialRoleName = initialRoleName;
        this.initialRolePassword = initialRolePassword;
        this.initialToolBox = initialToolBox;
        this.initialTool = initialTool;
        this.initialScope = initialScope;
        this.initialToolOptions = initialToolOptions;
        this.trusted = trusted;
        this.yesToAll = yesToAll;
        this.silent = silent;
        this.inputS = input;
        this.outputS = output;
        this.errorS = error;
    }

    protected void initManager() {
        try {
            this.consoleManager = new TTYConsoleManager();
            this.consoleManager.init((VConsole)this, null);
            this.consoleManager.addConsoleActionListener((VConsoleActionListener)this);
            this.consoleManager.setProperties(this.properties);
        }
        catch (Throwable t) {
            Debug.trace((String)"ConsoleManager", (int)Debug.ERROR, (String)"Could not initialize manager", (Throwable)t);
        }
    }

    public void start() throws CriticalStopException {
        int toolReturn = 0;
        try {
            ((BaseConsoleManager)this.consoleManager).setInitialOptions(this.initialHostName, this.initialUserName, this.initialPassword, this.initialRoleName, this.initialRolePassword, this.initialToolBox, this.initialTool, this.initialScope, this.initialToolOptions, this.trusted, this.yesToAll, this.silent, this.inputS, this.outputS, this.errorS);
        }
        catch (Throwable t) {
            ((TTYConsoleManager)this.consoleManager).unexpectedException(this.initialTool, null, null, t);
            toolReturn = 1;
        }
        Tool tool = null;
        try {
            tool = ((TTYConsoleManager)this.consoleManager).openSingleTool(this.initialTool, this.initialHostName);
        }
        catch (Throwable t) {
            toolReturn = 1;
        }
        try {
            if (toolReturn != 1) {
                toolReturn = tool.runCommandLine(this.initialToolOptions, this.inputS, this.outputS, this.errorS);
            }
        }
        catch (Throwable t) {
            ((TTYConsoleManager)this.consoleManager).unexpectedException(this.initialTool, null, null, t);
            toolReturn = 1;
        }
        this.consoleManager.shutDown();
        this.consoleManager.destroy();
        System.exit(toolReturn);
    }

    protected int promptUserToExitAllConsoles() {
        return 0;
    }

    protected void showAboutInfo() {
        if (this.outputS != null && !this.silent) {
            this.outputS.println("Solaris Management Console 2.0 - Terminal");
        }
    }

    protected void showHelpInfo() {
        if (this.outputS != null && !this.silent) {
            this.outputS.println("You don't really need help.");
        }
    }

    public void consoleAction(VConsoleEvent vce) {
        super.consoleAction(vce);
        if (this.silent || vce == null) {
            return;
        }
        String eventID = vce.getID();
        if (eventID == null) {
            return;
        }
        try {
            if (eventID.equals("vconsole.updatestatus")) {
                String message = (String)vce.getPayload();
                if (!this.silent) {
                    this.errorS.println(message);
                }
            } else if (eventID.equals("vconsole.logevent")) {
                VLogEvent e = (VLogEvent)vce.getPayload();
                if (!this.silent) {
                    this.errorS.println(e.getMessage());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
    }
}

