/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.ManagerUtility;
import com.sun.management.viperimpl.console.config.ConfigManagement;
import com.sun.management.viperimpl.console.config.VBaseConfiguration;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import com.sun.management.viperimpl.console.gui.ServerToolBoxChooser;
import com.sun.management.viperimpl.console.gui.ToolBoxChooser;
import com.sun.management.viperimpl.console.gui.ToolBoxChooserUI;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Locale;
import javax.accessibility.AccessibleContext;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;

public class ServerToolBoxChooserUI
extends ComponentUI
implements ToolBoxChooserUI,
Runnable {
    protected static int netTimeout = 20000;
    protected JButton approveButton = null;
    protected JButton cancelButton = null;
    protected JTextArea description = null;
    protected JList tbList = null;
    protected JScrollPane tbListPane = null;
    protected String remoteHelp = null;
    protected JComboBox serverComboBox = null;
    protected JTextField remoteTBField = null;
    protected ToolBoxChooser chooser = null;
    protected String remoteTitle = null;
    protected JLabel serverLabel = null;
    protected JButton goButton = null;
    protected JLabel boxesLabel = null;
    protected JLabel descLabel = null;
    protected JLabel urlLabel = null;
    protected ErrMsgPanel hostNotFound = null;
    protected ErrMsgPanel serverDown = null;
    protected ErrMsgPanel hostUnreachable = null;
    protected JLabel serverDescLabel = null;
    protected JLabel boxesDescLabel = null;
    protected VOptionPane optionPane = null;
    protected JPanel resultPanel = null;
    protected String seedServer = null;
    protected boolean netAccess = true;
    protected String host = null;
    protected Thread queryThread = null;
    protected Thread watchDog = null;

    public static ComponentUI createUI(JComponent c) {
        return new ServerToolBoxChooserUI((ServerToolBoxChooser)((Object)c));
    }

    public ServerToolBoxChooserUI(ToolBoxChooser chooser) {
        this.chooser = chooser;
        this.remoteHelp = ImplResourceManager.getString("OPENREMOTETOOLBOXHELP");
        this.remoteHelp = ContextHelpLoader.getContextHelp((String)this.remoteHelp, null);
        this.remoteTitle = ImplResourceManager.getString("Server Toolbox");
        this.installComponents(chooser);
        chooser.setUIReference(this);
    }

    public void setNetworkTimeout(int numMilliseconds) {
        netTimeout = numMilliseconds;
    }

    public void seedServer(String server) {
        this.seedServer = server;
        try {
            this.serverComboBox.addItem(server);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLimitedNetworkAccess(boolean value) {
        this.netAccess = value;
        try {
            this.serverComboBox.setEnabled(this.netAccess);
            this.goButton.setEnabled(this.netAccess);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JComponent getResultPanel() {
        return this.resultPanel;
    }

    public String getHelpHTML() {
        return this.remoteHelp;
    }

    public String getTitle() {
        return this.remoteTitle;
    }

    public void installComponents(ToolBoxChooser chooser) {
        chooser.toggleContentTitle(false);
        chooser.getContentPane();
        this.resultPanel = new JPanel();
        this.resultPanel.setLayout(new BoxLayout(this.resultPanel, 1));
        this.resultPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel p0 = new JPanel();
        p0.setLayout(new BoxLayout(p0, 0));
        this.serverLabel = new JLabel();
        p0.add(this.serverLabel);
        p0.add(Box.createHorizontalGlue());
        this.resultPanel.add(p0);
        this.resultPanel.add(Box.createVerticalStrut(3));
        JPanel p0_1 = new JPanel();
        p0_1.setLayout(new BoxLayout(p0_1, 0));
        this.serverDescLabel = new JLabel();
        p0_1.add(this.serverDescLabel);
        p0_1.add(Box.createHorizontalGlue());
        this.resultPanel.add(p0_1);
        this.resultPanel.add(Box.createVerticalStrut(3));
        JPanel p1 = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        p1.setLayout(new BorderLayout());
        this.serverComboBox = new JComboBox();
        this.serverComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.serverComboBox.setAlignmentX(0.0f);
        this.serverComboBox.setAlignmentY(0.5f);
        this.serverComboBox.setEditable(true);
        this.serverComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerToolBoxChooserUI.this.seedRemoteTBList(null);
            }
        });
        p1.add((Component)this.serverComboBox, "Center");
        this.goButton = new JButton();
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerToolBoxChooserUI.this.seedRemoteTBList(null);
            }
        });
        p1.add((Component)this.goButton, "East");
        this.resultPanel.add(p1);
        this.resultPanel.add(Box.createVerticalStrut(5));
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        this.boxesLabel = new JLabel();
        p2.add(this.boxesLabel);
        p2.add(Box.createHorizontalGlue());
        this.resultPanel.add(p2);
        this.resultPanel.add(Box.createVerticalStrut(3));
        JPanel p2_01 = new JPanel();
        p2_01.setLayout(new BoxLayout(p2_01, 0));
        this.boxesDescLabel = new JLabel();
        p2_01.add(this.boxesDescLabel);
        p2_01.add(Box.createHorizontalGlue());
        this.resultPanel.add(p2_01);
        this.resultPanel.add(Box.createVerticalStrut(3));
        this.resultPanel.add(this.createTBList());
        this.resultPanel.add(Box.createVerticalStrut(5));
        JPanel p4 = new JPanel();
        p4.setLayout(new BoxLayout(p4, 0));
        this.urlLabel = new JLabel();
        p4.add(this.urlLabel);
        p4.add(Box.createHorizontalGlue());
        this.resultPanel.add(p4);
        this.resultPanel.add(Box.createVerticalStrut(5));
        this.remoteTBField = new JTextField(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        this.remoteTBField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerToolBoxChooserUI.this.handleURLEntry();
            }
        });
        this.resultPanel.add(this.remoteTBField);
        this.resultPanel.add(Box.createVerticalStrut(5));
        JPanel p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, 0));
        this.descLabel = new JLabel();
        p3.add(this.descLabel);
        p3.add(Box.createHorizontalGlue());
        this.resultPanel.add(p3);
        this.resultPanel.add(Box.createVerticalStrut(5));
        this.resultPanel.add(this.createDesc());
        this.resultPanel.add(Box.createVerticalStrut(10));
        this.resultPanel.add(Box.createVerticalGlue());
        this.approveButton = new JButton();
        this.approveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerToolBoxChooserUI.this.approveSelection();
            }
        });
        this.approveButton.setEnabled(false);
        chooser.getButtonPane().add(this.approveButton);
        chooser.getButtonPane().add(Box.createHorizontalStrut(5));
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerToolBoxChooserUI.this.cancelSelection();
            }
        });
        chooser.getButtonPane().add(this.cancelButton);
        this.hostNotFound = this.createHostNotFound();
        this.serverDown = this.createServerDown();
        this.hostUnreachable = this.createHostUnreachable();
        this.installStrings();
        chooser.getContentPane().setLayout(new BorderLayout());
        chooser.getContentPane().add((Component)this.resultPanel, "Center");
    }

    protected void approveSelection() {
        if (this.chooser != null) {
            this.chooser.approveSelection();
        }
    }

    protected void cancelSelection() {
        if (this.chooser != null) {
            this.chooser.cancelSelection();
        }
    }

    public void refreshDisplay() {
        try {
            this.serverComboBox.setEnabled(this.netAccess);
            this.goButton.setEnabled(this.netAccess);
            this.seedRemoteTBList(null);
            this.updateFontAndColor();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void installStrings() {
        AccessibleContext ac;
        this.serverLabel.setText(ImplResourceManager.getString("Server:"));
        this.serverLabel.setDisplayedMnemonic(ImplResourceManager.getString("Server:_mnemonic").charAt(0));
        this.serverLabel.setLabelFor(this.serverComboBox);
        this.serverDescLabel.setText(ImplResourceManager.getString("Select a server from list or enter server name and click Load button."));
        this.goButton.setText(ImplResourceManager.getString("Load"));
        this.goButton.setToolTipText(ImplResourceManager.getString("Load_tooltip"));
        this.goButton.setMnemonic(ImplResourceManager.getString("Load_mnemonic").charAt(0));
        this.goButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("Load_accessible_name"));
        this.boxesLabel.setText(ImplResourceManager.getString("Toolboxes:"));
        this.boxesLabel.setDisplayedMnemonic(ImplResourceManager.getString("Toolboxes:_mnemonic").charAt(0));
        this.boxesLabel.setLabelFor(this.tbList);
        this.boxesDescLabel.setText(ImplResourceManager.getString("Select a toolbox from the list below and click Open button."));
        this.descLabel.setText(ImplResourceManager.getString("Description:"));
        this.descLabel.setDisplayedMnemonic(ImplResourceManager.getString("Description:_mnemonic").charAt(0));
        this.descLabel.setLabelFor(this.description);
        this.urlLabel.setText(ImplResourceManager.getString("URL:"));
        this.urlLabel.setDisplayedMnemonic(ImplResourceManager.getString("URL:_mnemonic").charAt(0));
        this.urlLabel.setLabelFor(this.remoteTBField);
        if (this.chooser.getDialogType() == 0) {
            this.approveButton.setText(ImplResourceManager.getString("OPEN_BUTTON"));
            this.approveButton.setToolTipText(ImplResourceManager.getString("OPEN_BUTTON_tooltip"));
            this.approveButton.setMnemonic(ImplResourceManager.getString("OPEN_BUTTON_mnemonic").charAt(0));
            ac = this.approveButton.getAccessibleContext();
            ac.setAccessibleName(ImplResourceManager.getString("OPEN_BUTTON_access_name"));
            ac.setAccessibleDescription(ImplResourceManager.getString("OPEN_BUTTON_access_desc"));
        } else {
            this.approveButton.setText(ImplResourceManager.getString("SAVE_BUTTON"));
            this.approveButton.setToolTipText(ImplResourceManager.getString("SAVE_BUTTON_tooltip"));
            this.approveButton.setMnemonic(ImplResourceManager.getString("SAVE_BUTTON_mnemonic").charAt(0));
            ac = this.approveButton.getAccessibleContext();
            ac.setAccessibleName(ImplResourceManager.getString("SAVE_BUTTON_access_name"));
            ac.setAccessibleDescription(ImplResourceManager.getString("SAVE_BUTTON_access_desc"));
        }
        this.cancelButton.setText(ImplResourceManager.getString("CANCEL_BUTTON"));
        this.cancelButton.setToolTipText(ImplResourceManager.getString("CANCEL_BUTTON_tooltip"));
        this.cancelButton.setMnemonic(ImplResourceManager.getString("CANCEL_BUTTON_mnemonic").charAt(0));
        ac = this.cancelButton.getAccessibleContext();
        ac.setAccessibleName(ImplResourceManager.getString("CANCEL_BUTTON_access_name"));
        ac.setAccessibleDescription(ImplResourceManager.getString("CANCEL_BUTTON_access_desc"));
    }

    protected void updateFontAndColor() {
        this.serverLabel.setFont(ResourceManager.labelFont);
        this.serverLabel.setForeground(ResourceManager.labelColor);
        this.serverDescLabel.setFont(ResourceManager.bodyFont);
        this.serverDescLabel.setForeground(ResourceManager.bodyColor);
        this.serverComboBox.setFont(ResourceManager.bodyFont);
        this.serverComboBox.setForeground(ResourceManager.bodyColor);
        this.goButton.setFont(ResourceManager.menuFont);
        this.goButton.setForeground(ResourceManager.menuColor);
        this.boxesLabel.setFont(ResourceManager.labelFont);
        this.boxesLabel.setForeground(ResourceManager.labelColor);
        this.boxesDescLabel.setFont(ResourceManager.bodyFont);
        this.boxesDescLabel.setForeground(ResourceManager.bodyColor);
        this.tbList.setFont(ResourceManager.bodyFont);
        this.tbList.setForeground(ResourceManager.bodyColor);
        this.urlLabel.setFont(ResourceManager.labelFont);
        this.urlLabel.setForeground(ResourceManager.labelColor);
        this.remoteTBField.setFont(ResourceManager.bodyFont);
        this.remoteTBField.setForeground(ResourceManager.bodyColor);
        this.descLabel.setFont(ResourceManager.labelFont);
        this.descLabel.setForeground(ResourceManager.labelColor);
        this.description.setFont(ResourceManager.bodyFont);
        this.description.setForeground(ResourceManager.bodyColor);
        this.approveButton.setFont(ResourceManager.menuFont);
        this.approveButton.setForeground(ResourceManager.menuColor);
        this.cancelButton.setFont(ResourceManager.menuFont);
        this.cancelButton.setForeground(ResourceManager.menuColor);
    }

    protected JPanel createTBList() {
        JPanel p = new JPanel(new BorderLayout()){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 80);
            }
        };
        this.tbList = new JList();
        this.tbList.setCellRenderer(new TBRenderer());
        this.tbList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ServerToolBoxChooserUI.this.handleTBListSelection();
            }
        });
        this.tbList.addMouseListener(this.createDoubleClickListener(this.chooser, this.tbList));
        this.tbListPane = new JScrollPane(this.tbList);
        p.add((Component)this.tbListPane, "Center");
        return p;
    }

    protected JPanel createDesc() {
        JPanel p = new JPanel(new BorderLayout());
        this.description = new JTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 80);
            }
        };
        this.description.setEditable(false);
        this.description.setBackground(Color.lightGray);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(this.description);
        p.add((Component)scrollPane, "Center");
        return p;
    }

    protected ErrMsgPanel createHostNotFound() {
        return new ErrMsgPanel(0);
    }

    protected ErrMsgPanel createServerDown() {
        return new ErrMsgPanel(1);
    }

    protected ErrMsgPanel createHostUnreachable() {
        return new ErrMsgPanel(2);
    }

    protected MouseListener createDoubleClickListener(ToolBoxChooser tbc, JList list) {
        return new DoubleClickListener(list);
    }

    public void setApproveButtonText(String text) {
    }

    public void setOptionPane(VOptionPane optionPane) {
        if (optionPane == null) {
            return;
        }
        this.optionPane = optionPane;
        optionPane.setTitle(this.remoteTitle);
        optionPane.setHelpHTML(this.remoteHelp);
    }

    protected void seedRemoteTBList(String host) {
        try {
            if (this.queryThread != null && this.queryThread.isAlive()) {
                return;
            }
            if (host == null) {
                host = (String)this.serverComboBox.getSelectedItem();
            }
            if (host == null) {
                return;
            }
            this.chooser.showBusyState(true);
            this.remoteTBField.setText("");
            this.description.setText("");
            this.tbList.setModel(new DefaultListModel());
            this.tbListPane.setViewportView(this.tbList);
            this.chooser.getContentPane().validate();
            this.chooser.getContentPane().repaint();
            this.host = host;
            this.queryThread = new Thread(this);
            this.queryThread.start();
            this.watchDog = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.currentThread();
                        Thread.sleep(netTimeout);
                        if (!ServerToolBoxChooserUI.this.queryThread.isAlive()) {
                            return;
                        }
                        ServerToolBoxChooserUI.this.queryThread.interrupt();
                        ServerToolBoxChooserUI.this.tbList.setModel(new DefaultListModel());
                        ServerToolBoxChooserUI.this.remoteTBField.setText("");
                        ServerToolBoxChooserUI.this.description.setText("");
                        ServerToolBoxChooserUI.this.chooser.showBusyState(false);
                    }
                    catch (Throwable t) {
                        Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Watchdog interrupt", (Throwable)t);
                    }
                }
            });
            this.watchDog.start();
        }
        catch (Throwable t) {
            Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Unexpected error", (Throwable)t);
        }
    }

    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(1500L);
            int port = ManagerUtility.parsePortFromString(this.host);
            if (port < 0) {
                port = 898;
            }
            this.host = ManagerUtility.parseHostFromString(this.host);
            InetAddress ipAddr = InetAddress.getByName(this.host);
            Locale loc = ResourceManager.currentLocale;
            if (loc == null) {
                loc = Locale.getDefault();
            }
            URL u = new URL("http://" + this.host + ":" + port + "/toolboxes/");
            URLConnection uc = u.openConnection();
            uc.setRequestProperty("Locale", loc.toString());
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(uc.getInputStream()));
            Object o = ois.readObject();
            VConfigurationInfo[] infoList = (VConfigurationInfo[])o;
            for (int i = 0; i < infoList.length; ++i) {
                infoList[i].setURL(ServerToolBoxChooserUI.cleanURL(infoList[i].getURL()));
            }
            this.tbListPane.setViewportView(this.tbList);
            this.tbList.setModel(new TBListModel(infoList));
            this.remoteTBField.setText("");
            this.description.setText("");
        }
        catch (UnknownHostException uhe) {
            Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Unknown Host", (Throwable)uhe);
            this.tbList.setModel(new DefaultListModel());
            this.remoteTBField.setText("");
            this.description.setText("");
            this.tbListPane.setViewportView(this.hostNotFound);
        }
        catch (IOException ioe) {
            Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Server Not Running", (Throwable)ioe);
            this.tbList.setModel(new DefaultListModel());
            this.remoteTBField.setText("");
            this.description.setText("");
            this.tbListPane.setViewportView(this.serverDown);
        }
        catch (Throwable t) {
            Debug.trace((String)"TB Chooser", (int)Debug.WARNING, (String)"Query interrupt", (Throwable)t);
            this.tbList.setModel(new DefaultListModel());
            this.remoteTBField.setText("");
            this.description.setText("");
            this.tbListPane.setViewportView(this.hostUnreachable);
        }
        try {
            if (this.watchDog != null && this.watchDog.isAlive()) {
                this.watchDog.interrupt();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.chooser.getContentPane().validate();
        this.chooser.getContentPane().repaint();
        this.chooser.showBusyState(false);
    }

    protected static URL cleanURL(URL u) {
        try {
            String tbU = u.toString();
            int i = tbU.indexOf("//");
            int j = tbU.indexOf(":", i + 2);
            if (j == -1) {
                j = tbU.indexOf("/", i + 2);
            }
            String ip = tbU.substring(i + 2, j);
            ip = InetAddress.getByName(ip).getHostName();
            String tbLocation = tbU.substring(0, i + 2) + ip;
            tbLocation = tbLocation + tbU.substring(j, tbU.length());
            return new URL(tbLocation);
        }
        catch (Throwable throwable) {
            return u;
        }
    }

    protected void handleTBListSelection() {
        try {
            if (this.tbList.isSelectionEmpty()) {
                return;
            }
            VConfigurationInfo info = (VConfigurationInfo)this.tbList.getSelectedValue();
            this.remoteTBField.setText(ConfigManagement.aliasifyURL(info.getURL()).toString());
            this.description.setText(info.getDescription());
            this.approveButton.setEnabled(true);
            this.chooser.setToolBoxURL(info.getURL());
        }
        catch (Throwable e) {
            this.remoteTBField.setText("");
            this.tbList.setModel(new DefaultListModel());
            this.description.setText("");
            this.approveButton.setEnabled(false);
            this.chooser.setToolBoxURL(null);
        }
    }

    protected void handleURLEntry() {
        try {
            URL u = new URL(this.remoteTBField.getText());
            u = ConfigManagement.unaliasifyURL(u);
            VBaseConfiguration config = VBaseConfiguration.createConfiguration(u, ResourceManager.currentLocale);
            this.chooser.setToolBoxURL(u);
            this.chooser.approveSelection();
        }
        catch (Throwable e) {
            Debug.trace((String)"ConsoleManager", (int)Debug.ERROR, (String)"Problem loading toolbox", (Throwable)e);
            this.remoteTBField.setText("");
            this.tbList.setModel(new DefaultListModel());
            this.description.setText("");
            this.approveButton.setEnabled(false);
            this.chooser.setToolBoxURL(null);
        }
    }

    protected JButton getApproveButton(ToolBoxChooser tbc) {
        return this.approveButton;
    }

    class ErrMsgPanel
    extends JPanel {
        protected JLabel title = null;
        protected JTextArea desc = null;
        protected ImageIcon errIcon = null;
        protected int type = 0;

        public ErrMsgPanel(int type) {
            if (type < 0 || type > 2) {
                type = 0;
            }
            this.type = type;
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel iconPanel = new JPanel();
            iconPanel.setBorder(new EmptyBorder(0, 0, 0, 5));
            iconPanel.setLayout(new BoxLayout(iconPanel, 1));
            if (this.errIcon == null) {
                this.errIcon = ConsoleUtility.loadImageIcon((String)"images/Event_Err16.gif", this.getClass());
            }
            iconPanel.add(new JLabel(this.errIcon));
            iconPanel.add(Box.createVerticalGlue());
            this.add((Component)iconPanel, "West");
            JPanel msgPanel = new JPanel(new BorderLayout());
            this.title = new JLabel();
            msgPanel.add((Component)this.title, "North");
            this.desc = new JTextArea();
            msgPanel.add((Component)this.desc, "Center");
            this.desc.setEditable(false);
            this.desc.setOpaque(false);
            this.desc.setLineWrap(true);
            this.desc.setWrapStyleWord(true);
            this.add((Component)msgPanel, "Center");
            this.installStrings();
        }

        protected void installStrings() {
            if (this.type == 0) {
                this.title.setText(ImplResourceManager.getString("Host Not Found"));
                this.desc.setText(ImplResourceManager.getString("NoServerFound"));
            } else if (this.type == 1) {
                this.title.setText(ImplResourceManager.getString("Server Not Running"));
                this.desc.setText(ImplResourceManager.getString("NoServerOnHost"));
            } else if (this.type == 2) {
                this.title.setText(ImplResourceManager.getString("Connection Timeout"));
                this.desc.setText(ImplResourceManager.getString("ConnectionTimeout"));
            }
        }
    }

    protected class TBListModel
    implements ListModel {
        protected VConfigurationInfo[] infoList = null;

        public TBListModel(VConfigurationInfo[] infoList) {
            this.infoList = infoList;
        }

        public void addListDataListener(ListDataListener l) {
        }

        public Object getElementAt(int index) {
            return this.infoList[index];
        }

        public int getSize() {
            return this.infoList.length;
        }

        public void removeListDataListener(ListDataListener l) {
        }
    }

    protected class TBRenderer
    extends DefaultListCellRenderer {
        protected TBRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            VConfigurationInfo cInfo = (VConfigurationInfo)value;
            this.setText(cInfo.getName());
            this.setIcon(ConsoleUtility.loadImageIcon((URL)cInfo.getSmallIcon(), (String)""));
            return this;
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        JList list;

        public DoubleClickListener(JList list) {
            this.list = list;
        }

        public void mouseClicked(MouseEvent e) {
            try {
                if (e.getClickCount() == 2) {
                    int index = this.list.locationToIndex(e.getPoint());
                    Object o = this.list.getModel().getElementAt(index);
                    VConfigurationInfo info = (VConfigurationInfo)o;
                    ServerToolBoxChooserUI.this.chooser.setToolBoxURL(info.getURL());
                    ServerToolBoxChooserUI.this.chooser.approveSelection();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

