/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.BasicFileFilter;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.config.VBaseConfiguration;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import com.sun.management.viperimpl.console.gui.BaseToolBoxChooser;
import com.sun.management.viperimpl.console.gui.ToolBoxChooser;
import com.sun.management.viperimpl.console.gui.ToolBoxChooserUI;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class LocalToolBoxChooserUI
extends BasicFileChooserUI
implements ToolBoxChooserUI {
    protected static final String TOOLBOX_EXT = "tbx";
    protected Action directoryComboBoxAction = new DirectoryComboBoxAction();
    protected DirectoryComboBoxModel directoryComboBoxModel = null;
    protected FilterComboBoxModel filterComboBoxModel = null;
    protected JComboBox directoryComboBox = null;
    protected JTextField filenameTextField = null;
    protected JPanel centerPanel = null;
    protected JList list = null;
    protected JButton approveButton = null;
    protected JButton cancelButton = null;
    protected JComboBox filterComboBox = null;
    protected JPanel bodyPanel = null;
    protected JLabel lookInLabel = null;
    protected JButton upButton = null;
    protected JButton homeButton = null;
    protected JButton folderButton = null;
    protected JLabel fileNameLabel = null;
    protected JLabel filesOfTypeLabel = null;
    protected JLabel descLabel = null;
    protected JTextArea description = null;
    protected JPanel resultPanel = null;
    protected JFileChooser hiddenFC = null;
    protected ToolBoxChooser chooser = null;
    protected String localOpenHelp = null;
    protected String localSaveHelp = null;
    protected String localTitle = null;
    protected static final Dimension hstrut10 = new Dimension(10, 1);
    protected static final Dimension hstrut25 = new Dimension(25, 1);
    protected static final Dimension vstrut10 = new Dimension(1, 10);
    protected static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    int lastIndex = -1;
    boolean editing = false;
    int editX = 20;
    int editWidth = 200;
    JTextField editCell = null;
    static final int space = 10;

    public static ComponentUI createUI(JComponent c) {
        return new LocalToolBoxChooserUI((BaseToolBoxChooser)((Object)c));
    }

    public LocalToolBoxChooserUI(ToolBoxChooser chooser) {
        super(null);
        this.chooser = chooser;
        this.localOpenHelp = ImplResourceManager.getString("OPENLOCALTOOLBOXHELP");
        this.localOpenHelp = ContextHelpLoader.getContextHelp((String)this.localOpenHelp, null);
        this.localSaveHelp = ImplResourceManager.getString("SAVELOCALTOOLBOXHELP");
        this.localSaveHelp = ContextHelpLoader.getContextHelp((String)this.localSaveHelp, null);
        this.localTitle = ImplResourceManager.getString("Local Toolbox");
        this.installUI(null);
        this.installComponents(chooser);
        chooser.setUIReference(this);
        chooser.setTitle(this.localTitle);
        if (chooser.getDialogType() == 0) {
            chooser.setHelpHTML(this.localOpenHelp);
        } else {
            chooser.setHelpHTML(this.localSaveHelp);
        }
    }

    public void installUI(JComponent c) {
        if (this.hiddenFC == null) {
            this.hiddenFC = new JFileChooser(){

                public void rescanCurrentDirectory() {
                    LocalToolBoxChooserUI.this.rescanCurrentDirectory(LocalToolBoxChooserUI.this.hiddenFC);
                }

                public void ensureFileIsVisible(File newFolder) {
                    LocalToolBoxChooserUI.this.ensureFileIsVisible(LocalToolBoxChooserUI.this.hiddenFC, newFolder);
                }
            };
            BasicFileFilter ff = new BasicFileFilter(TOOLBOX_EXT, ImplResourceManager.getString("TOOLBOX_DESCRIPTION"));
            this.hiddenFC.setFileFilter((FileFilter)ff);
        }
        super.installUI(this.hiddenFC);
    }

    public JFileChooser getFileChooser() {
        return this.hiddenFC;
    }

    public JComponent getResultPanel() {
        return this.resultPanel;
    }

    public String getHelpHTML() {
        return this.localOpenHelp;
    }

    public String getTitle() {
        return this.localTitle;
    }

    public void installComponents(ToolBoxChooser chooser) {
        chooser.toggleContentTitle(false);
        this.resultPanel = new JPanel();
        this.resultPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.resultPanel.setLayout(new BoxLayout(this.resultPanel, 1));
        this.resultPanel.add(Box.createRigidArea(vstrut10));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        this.resultPanel.add(topPanel);
        this.resultPanel.add(Box.createRigidArea(vstrut10));
        this.lookInLabel = new JLabel();
        this.lookInLabel.setAlignmentX(0.0f);
        this.lookInLabel.setAlignmentY(0.5f);
        topPanel.add(Box.createRigidArea(hstrut10));
        topPanel.add(this.lookInLabel);
        topPanel.add(Box.createRigidArea(hstrut25));
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(this.hiddenFC);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(this.hiddenFC));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.5f);
        topPanel.add(this.directoryComboBox);
        topPanel.add(Box.createRigidArea(hstrut10));
        this.upButton = new JButton(this.upFolderIcon);
        this.upButton.setAlignmentX(0.0f);
        this.upButton.setAlignmentY(0.5f);
        this.upButton.setMargin(shrinkwrap);
        this.upButton.addActionListener(this.getChangeToParentDirectoryAction());
        topPanel.add(this.upButton);
        topPanel.add(Box.createRigidArea(hstrut10));
        this.homeButton = new JButton(this.homeFolderIcon);
        this.homeButton.setAlignmentX(0.0f);
        this.homeButton.setAlignmentY(0.5f);
        this.homeButton.setMargin(shrinkwrap);
        this.homeButton.addActionListener(this.getGoHomeAction());
        topPanel.add(this.homeButton);
        topPanel.add(Box.createRigidArea(hstrut10));
        this.folderButton = new JButton(this.newFolderIcon);
        this.folderButton.setAlignmentX(0.0f);
        this.folderButton.setAlignmentY(0.5f);
        this.folderButton.setMargin(shrinkwrap);
        this.folderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File cd = LocalToolBoxChooserUI.this.hiddenFC.getCurrentDirectory();
                File newFolder = null;
                try {
                    newFolder = LocalToolBoxChooserUI.this.hiddenFC.getFileSystemView().createNewFolder(cd);
                    LocalToolBoxChooserUI.this.hiddenFC.rescanCurrentDirectory();
                    LocalToolBoxChooserUI.this.list.setModel(LocalToolBoxChooserUI.this.getModel());
                    int newIndex = LocalToolBoxChooserUI.this.getModel().indexOf(newFolder);
                    LocalToolBoxChooserUI.this.list.setSelectedIndex(newIndex);
                    LocalToolBoxChooserUI.this.list.ensureIndexIsVisible(newIndex);
                    LocalToolBoxChooserUI.this.list.validate();
                    LocalToolBoxChooserUI.this.list.repaint();
                    LocalToolBoxChooserUI.this.list.setSelectedIndex(newIndex);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        });
        topPanel.add(this.folderButton);
        topPanel.add(Box.createRigidArea(hstrut10));
        this.centerPanel = new JPanel(new BorderLayout());
        JPanel p = this.createList(this.hiddenFC);
        this.centerPanel.add((Component)p, "Center");
        this.centerPanel.add((Component)this.getAccessoryPanel(), "East");
        JComponent accessory = this.hiddenFC.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        this.resultPanel.add(this.centerPanel);
        JPanel labelPanel = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        labelPanel.setLayout(new GridLayout(2, 1));
        EmptyBorder labelBorder = new EmptyBorder(7, 0, 7, 0);
        this.fileNameLabel = new JLabel();
        this.fileNameLabel.setBorder(labelBorder);
        labelPanel.add(this.fileNameLabel);
        this.filesOfTypeLabel = new JLabel();
        this.filesOfTypeLabel.setBorder(labelBorder);
        labelPanel.add(this.filesOfTypeLabel);
        JPanel fieldPanel = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        fieldPanel.setLayout(new GridLayout(2, 1));
        this.filenameTextField = new JTextField();
        this.fileNameLabel.setLabelFor(this.filenameTextField);
        this.filenameTextField.addActionListener(this.getApproveSelectionAction());
        File f = this.hiddenFC.getSelectedFile();
        if (f != null) {
            this.setFileName(this.hiddenFC.getName(f));
        }
        JPanel fPanel = new JPanel();
        fPanel.setLayout(new BorderLayout());
        fPanel.add((Component)this.filenameTextField, "North");
        fieldPanel.add(fPanel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        this.hiddenFC.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filesOfTypeLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        fieldPanel.add(this.filterComboBox);
        JPanel bottomPanel = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(labelPanel);
        bottomPanel.add(Box.createHorizontalStrut(10));
        bottomPanel.add(fieldPanel);
        this.resultPanel.add(Box.createVerticalStrut(5));
        this.resultPanel.add(bottomPanel);
        JPanel p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, 0));
        this.descLabel = new JLabel();
        p3.add(this.descLabel);
        p3.add(Box.createHorizontalGlue());
        this.resultPanel.add(p3);
        this.resultPanel.add(Box.createVerticalStrut(5));
        this.resultPanel.add(this.createDesc());
        this.resultPanel.add(Box.createVerticalStrut(10));
        this.resultPanel.add(Box.createVerticalGlue());
        chooser.getContentPane().removeAll();
        chooser.getContentPane().setLayout(new BorderLayout());
        chooser.getContentPane().add((Component)this.resultPanel, "Center");
        this.approveButton = new JButton();
        this.approveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    File dir = LocalToolBoxChooserUI.this.hiddenFC.getCurrentDirectory();
                    URL u = dir.toURL();
                    String name = LocalToolBoxChooserUI.this.filenameTextField.getText();
                    if (!name.endsWith(".tbx")) {
                        name = name + ".tbx";
                    }
                    LocalToolBoxChooserUI.this.chooser.setToolBoxURL(new URL(u, name));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                LocalToolBoxChooserUI.this.chooser.approveSelection();
            }
        });
        this.approveButton.setEnabled(false);
        chooser.getButtonPane().add(this.approveButton);
        chooser.getButtonPane().add(Box.createHorizontalStrut(5));
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LocalToolBoxChooserUI.this.chooser.cancelSelection();
            }
        });
        chooser.getButtonPane().add(this.cancelButton);
        this.installStrings();
    }

    protected void installStrings() {
        AccessibleContext ac;
        this.lookInLabel.setText(ImplResourceManager.getString("Look in:"));
        this.lookInLabel.setDisplayedMnemonic(ImplResourceManager.getString("Look in:_mnemonic").charAt(0));
        this.upButton.setToolTipText(ImplResourceManager.getString("UP_BUTTON_tooltip"));
        this.upButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("UP_BUTTON_access_name"));
        this.homeButton.setToolTipText(ImplResourceManager.getString("HOME_BUTTON_tooltip"));
        this.homeButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("HOME_BUTTON_access_name"));
        this.folderButton.setToolTipText(ImplResourceManager.getString("FOLDER_BUTTON_tooltip"));
        this.folderButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("FOLDER_BUTTON_access_name"));
        this.fileNameLabel.setText(ImplResourceManager.getString("Filename:"));
        this.fileNameLabel.setDisplayedMnemonic(ImplResourceManager.getString("Filename:_mnemonic").charAt(0));
        this.filesOfTypeLabel.setText(ImplResourceManager.getString("Files of type:"));
        this.filesOfTypeLabel.setDisplayedMnemonic(ImplResourceManager.getString("Files of type:_mnemonic").charAt(0));
        this.descLabel.setText(ImplResourceManager.getString("Description:"));
        this.descLabel.setDisplayedMnemonic(ImplResourceManager.getString("Description:_mnemonic").charAt(0));
        if (this.chooser.getDialogType() == 0) {
            this.approveButton.setText(ImplResourceManager.getString("OPEN_BUTTON"));
            this.approveButton.setToolTipText(ImplResourceManager.getString("OPEN_BUTTON_tooltip"));
            this.approveButton.setMnemonic(ImplResourceManager.getString("OPEN_BUTTON_mnemonic").charAt(0));
            ac = this.approveButton.getAccessibleContext();
            ac.setAccessibleName(ImplResourceManager.getString("OPEN_BUTTON_access_name"));
            ac.setAccessibleDescription(ImplResourceManager.getString("OPEN_BUTTON_access_desc"));
        } else {
            this.approveButton.setText(ImplResourceManager.getString("SAVE_BUTTON"));
            this.approveButton.setToolTipText(ImplResourceManager.getString("SAVE_BUTTON_tooltip"));
            this.approveButton.setMnemonic(ImplResourceManager.getString("SAVE_BUTTON_mnemonic").charAt(0));
            ac = this.approveButton.getAccessibleContext();
            ac.setAccessibleName(ImplResourceManager.getString("SAVE_BUTTON_access_name"));
            ac.setAccessibleDescription(ImplResourceManager.getString("SAVE_BUTTON_access_desc"));
        }
        this.cancelButton.setText(ImplResourceManager.getString("CANCEL_BUTTON"));
        this.cancelButton.setToolTipText(ImplResourceManager.getString("CANCEL_BUTTON_tooltip"));
        this.cancelButton.setMnemonic(ImplResourceManager.getString("CANCEL_BUTTON_mnemonic").charAt(0));
        ac = this.cancelButton.getAccessibleContext();
        ac.setAccessibleName(ImplResourceManager.getString("CANCEL_BUTTON_access_name"));
        ac.setAccessibleDescription(ImplResourceManager.getString("CANCEL_BUTTON_access_desc"));
    }

    protected void updateFontAndColor() {
        this.lookInLabel.setFont(ResourceManager.labelFont);
        this.lookInLabel.setForeground(ResourceManager.labelColor);
        this.directoryComboBox.setFont(ResourceManager.bodyFont);
        this.directoryComboBox.setForeground(ResourceManager.bodyColor);
        this.fileNameLabel.setFont(ResourceManager.labelFont);
        this.fileNameLabel.setForeground(ResourceManager.labelColor);
        this.filenameTextField.setFont(ResourceManager.bodyFont);
        this.filenameTextField.setForeground(ResourceManager.bodyColor);
        this.list.setFont(ResourceManager.bodyFont);
        this.list.setForeground(ResourceManager.bodyColor);
        this.filesOfTypeLabel.setFont(ResourceManager.labelFont);
        this.filesOfTypeLabel.setForeground(ResourceManager.labelColor);
        this.filterComboBox.setFont(ResourceManager.bodyFont);
        this.filterComboBox.setForeground(ResourceManager.bodyColor);
        this.descLabel.setFont(ResourceManager.labelFont);
        this.descLabel.setForeground(ResourceManager.labelColor);
        this.description.setFont(ResourceManager.bodyFont);
        this.description.setForeground(ResourceManager.bodyColor);
        this.approveButton.setFont(ResourceManager.menuFont);
        this.approveButton.setForeground(ResourceManager.menuColor);
        this.cancelButton.setFont(ResourceManager.menuFont);
        this.cancelButton.setForeground(ResourceManager.menuColor);
    }

    protected JPanel createList(JFileChooser fc) {
        JPanel p = new JPanel(new BorderLayout()){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 80);
            }
        };
        this.list = new JList();
        this.list.setCellRenderer(new FileRenderer());
        this.list.setModel(this.getModel());
        this.list.addListSelectionListener(this.createListSelectionListener(fc));
        this.list.addMouseListener(this.createDoubleClickListener(fc, this.list));
        this.list.addMouseListener(this.createSingleClickListener(fc, this.list));
        JScrollPane scrollpane = new JScrollPane(this.list);
        p.add((Component)scrollpane, "Center");
        return p;
    }

    protected JPanel createDesc() {
        JPanel p = new JPanel(new BorderLayout());
        this.description = new JTextArea(){

            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, 80);
            }
        };
        this.description.setEditable(false);
        this.description.setBackground(Color.lightGray);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(this.description);
        p.add((Component)scrollPane, "Center");
        return p;
    }

    protected MouseListener createSingleClickListener(JFileChooser fc, JList list) {
        return new SingleClickListener(list);
    }

    protected void cancelEdit() {
        this.editing = false;
        if (this.editCell != null) {
            this.list.remove(this.editCell);
        }
    }

    public void refreshDisplay() {
        try {
            this.hiddenFC.setSelectedFile(null);
            this.filenameTextField.setText("");
            this.description.setText("");
            this.list.clearSelection();
            this.hiddenFC.rescanCurrentDirectory();
            this.list.setModel(this.getModel());
            if (this.chooser.getDialogType() == 1) {
                this.chooser.setHelpHTML(this.localSaveHelp);
                this.approveButton.setEnabled(true);
            } else {
                this.chooser.setHelpHTML(this.localOpenHelp);
                this.approveButton.setEnabled(false);
            }
            this.folderButton.setEnabled(this.chooser.getDialogType() != 0);
            this.installStrings();
            this.updateFontAndColor();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setApproveButtonText(String text) {
    }

    public void setOptionPane(VOptionPane optionPane) {
    }

    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.filenameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(c);
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (prop.equals("SelectedFileChangedProperty")) {
                    LocalToolBoxChooserUI.this.cancelEdit();
                    File f = (File)e.getNewValue();
                    if (f != null) {
                        LocalToolBoxChooserUI.this.setFileName(LocalToolBoxChooserUI.this.getFileChooser().getName(f));
                        if (LocalToolBoxChooserUI.this.getModel().contains(f)) {
                            LocalToolBoxChooserUI.this.list.setSelectedIndex(LocalToolBoxChooserUI.this.getModel().indexOf(f));
                            LocalToolBoxChooserUI.this.list.ensureIndexIsVisible(LocalToolBoxChooserUI.this.list.getSelectedIndex());
                        }
                    }
                    LocalToolBoxChooserUI.this.handleTBSelection();
                } else if (prop.equals("directoryChanged")) {
                    LocalToolBoxChooserUI.this.cancelEdit();
                    LocalToolBoxChooserUI.this.clearIconCache();
                    LocalToolBoxChooserUI.this.list.clearSelection();
                    File currentDirectory = LocalToolBoxChooserUI.this.getFileChooser().getCurrentDirectory();
                    if (currentDirectory != null) {
                        LocalToolBoxChooserUI.this.directoryComboBoxModel.addItem(currentDirectory);
                        LocalToolBoxChooserUI.this.folderButton.setEnabled(LocalToolBoxChooserUI.this.chooser.getDialogType() != 0 && currentDirectory.canWrite());
                    }
                } else if (prop.equals("fileSelectionChanged")) {
                    LocalToolBoxChooserUI.this.clearIconCache();
                    LocalToolBoxChooserUI.this.list.clearSelection();
                } else if (prop == "AccessoryChangedProperty") {
                    if (LocalToolBoxChooserUI.this.getAccessoryPanel() != null) {
                        JComponent accessory;
                        if (e.getOldValue() != null) {
                            LocalToolBoxChooserUI.this.getAccessoryPanel().remove((JComponent)e.getOldValue());
                        }
                        if ((accessory = (JComponent)e.getNewValue()) != null) {
                            LocalToolBoxChooserUI.this.getAccessoryPanel().add((Component)accessory, "Center");
                        }
                    }
                } else if (prop == "ApproveButtonTextChangedProperty" || prop == "DialogTypeChangedProperty") {
                    JFileChooser chooser = LocalToolBoxChooserUI.this.getFileChooser();
                    LocalToolBoxChooserUI.this.approveButton.setText(LocalToolBoxChooserUI.this.getApproveButtonText(chooser));
                    LocalToolBoxChooserUI.this.approveButton.setToolTipText(LocalToolBoxChooserUI.this.getApproveButtonToolTipText(chooser));
                    LocalToolBoxChooserUI.this.approveButton.setMnemonic(LocalToolBoxChooserUI.this.getApproveButtonMnemonic(chooser));
                } else if (prop.equals("ApproveButtonMnemonicChangedProperty")) {
                    LocalToolBoxChooserUI.this.approveButton.setMnemonic(LocalToolBoxChooserUI.this.getApproveButtonMnemonic(LocalToolBoxChooserUI.this.getFileChooser()));
                }
            }
        };
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
        if (this.getModel().contains(f)) {
            this.list.ensureIndexIsVisible(this.getModel().indexOf(f));
        }
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        this.getModel().invalidateFileCache();
        this.getModel().validateFileCache();
    }

    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    public void setFileName(String filename) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(filename);
        }
    }

    protected void handleTBSelection() {
        try {
            File f = this.hiddenFC.getSelectedFile();
            if (f == null || !f.isFile()) {
                this.description.setText("");
                this.chooser.setToolBoxURL(null);
                return;
            }
            VBaseConfiguration config = VBaseConfiguration.createConfiguration(f.toURL());
            VConfigurationInfo info = config.getInfo();
            this.description.setText(info.getDescription());
            this.chooser.setToolBoxURL(info.getURL());
            this.approveButton.setEnabled(true);
        }
        catch (Throwable e) {
            Debug.trace((String)"ConsoleManager", (int)Debug.ERROR, (String)"Problem loading toolbox", (Throwable)e);
            this.description.setText("");
            this.chooser.setToolBoxURL(null);
            this.approveButton.setEnabled(false);
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String dirname) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent e) {
        File f = this.getFileChooser().getSelectedFile();
        if (!e.getValueIsAdjusting() && f != null && !this.getFileChooser().isTraversable(f)) {
            this.setFileName(this.getFileChooser().getName(f));
        }
    }

    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent e) {
            LocalToolBoxChooserUI.this.hiddenFC.setCurrentDirectory((File)LocalToolBoxChooserUI.this.directoryComboBox.getSelectedItem());
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = LocalToolBoxChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object filter) {
            if (filter != null) {
                LocalToolBoxChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter currentFilter = LocalToolBoxChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (int i = 0; i < this.filters.length; ++i) {
                    if (this.filters[i] != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    LocalToolBoxChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return LocalToolBoxChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return LocalToolBoxChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            FileFilter filter = (FileFilter)value;
            if (filter != null) {
                this.setText(filter.getDescription());
            }
            return this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        int topIndex = -1;
        int pathCount = 0;
        File selectedDirectory = null;

        public DirectoryComboBoxModel() {
            File[] roots = LocalToolBoxChooserUI.this.getFileChooser().getFileSystemView().getRoots();
            for (int i = 0; i < roots.length; ++i) {
                this.directories.addElement(roots[i]);
            }
            this.addItem(LocalToolBoxChooserUI.this.getFileChooser().getCurrentDirectory());
        }

        protected void removeSelectedDirectory() {
            if (this.topIndex >= 0) {
                for (int i = this.topIndex; i < this.topIndex + this.pathCount; ++i) {
                    this.directories.removeElementAt(this.topIndex + 1);
                }
            }
            this.topIndex = -1;
            this.pathCount = 0;
            this.selectedDirectory = null;
        }

        protected void addItem(File directory) {
            if (directory == null) {
                return;
            }
            if (this.selectedDirectory != null) {
                this.removeSelectedDirectory();
            }
            File canonical = null;
            try {
                canonical = LocalToolBoxChooserUI.this.getFileChooser().getFileSystemView().createFileObject(directory.getCanonicalPath());
            }
            catch (IOException e) {
                // empty catch block
            }
            File f = canonical;
            Vector<File> path = new Vector<File>(10);
            while (f.getParent() != null) {
                path.addElement(f);
                if (this.directories.contains(f)) {
                    this.topIndex = this.directories.indexOf(f);
                }
                f = LocalToolBoxChooserUI.this.getFileChooser().getFileSystemView().createFileObject(f.getParent());
            }
            this.pathCount = path.size();
            if (this.topIndex < 0 && this.directories.contains(f)) {
                this.topIndex = this.directories.indexOf(f);
            }
            for (int i = 0; i < path.size(); ++i) {
                this.directories.insertElementAt(path.elementAt(i), this.topIndex + 1);
            }
            this.setSelectedItem(canonical);
        }

        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon.paintIcon(c, g, x + this.depth * 10, y);
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File directory = (File)value;
            if (directory == null) {
                this.setText("");
                return this;
            }
            String fileName = LocalToolBoxChooserUI.this.getFileChooser().getName(directory);
            this.setText(fileName);
            int depth = 0;
            if (index != -1) {
                File f = directory;
                while (f.getParent() != null) {
                    ++depth;
                    f = LocalToolBoxChooserUI.this.getFileChooser().getFileSystemView().createFileObject(f.getParent());
                }
            }
            this.ii.icon = icon = LocalToolBoxChooserUI.this.getFileChooser().getIcon(directory);
            this.ii.depth = depth;
            this.setIcon(this.ii);
            return this;
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            String fileName = LocalToolBoxChooserUI.this.getFileChooser().getName(file);
            this.setText(fileName);
            Icon icon = LocalToolBoxChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (isSelected) {
                LocalToolBoxChooserUI.this.editX = icon.getIconWidth() + 4;
            }
            return this;
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            File f2;
            JTextField tf = (JTextField)e.getSource();
            File f = (File)LocalToolBoxChooserUI.this.list.getSelectedValue();
            String newFileName = tf.getText();
            if (!(newFileName = newFileName.trim()).equals(LocalToolBoxChooserUI.this.getFileChooser().getName(f)) && f.renameTo(f2 = LocalToolBoxChooserUI.this.getFileChooser().getFileSystemView().createFileObject(LocalToolBoxChooserUI.this.getFileChooser().getCurrentDirectory(), newFileName))) {
                LocalToolBoxChooserUI.this.rescanCurrentDirectory(LocalToolBoxChooserUI.this.getFileChooser());
            }
            LocalToolBoxChooserUI.this.cancelEdit();
            LocalToolBoxChooserUI.this.list.repaint();
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        JList list;

        public SingleClickListener(JList list) {
            this.list = list;
            LocalToolBoxChooserUI.this.editCell = new JTextField();
            LocalToolBoxChooserUI.this.editCell.addActionListener(new EditActionListener());
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 1) {
                int index = this.list.locationToIndex(e.getPoint());
                if (LocalToolBoxChooserUI.this.lastIndex == index && !LocalToolBoxChooserUI.this.editing) {
                    LocalToolBoxChooserUI.this.editing = true;
                    Rectangle r = this.list.getCellBounds(index, index);
                    this.list.add(LocalToolBoxChooserUI.this.editCell);
                    File f = (File)this.list.getSelectedValue();
                    LocalToolBoxChooserUI.this.editCell.setText(LocalToolBoxChooserUI.this.getFileChooser().getName(f));
                    LocalToolBoxChooserUI.this.editCell.setBounds(LocalToolBoxChooserUI.this.editX + r.x, r.y, LocalToolBoxChooserUI.this.editWidth, r.height);
                    LocalToolBoxChooserUI.this.editCell.selectAll();
                } else {
                    LocalToolBoxChooserUI.this.lastIndex = index;
                    LocalToolBoxChooserUI.this.cancelEdit();
                }
            } else {
                LocalToolBoxChooserUI.this.cancelEdit();
            }
            this.list.repaint();
        }
    }
}

