/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.VLocalizedInfo;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VLogEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VBusyPanel;
import com.sun.management.viper.console.gui.VContainer;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.BaseConsoleManager;
import com.sun.management.viperimpl.console.ManagedCredentials;
import com.sun.management.viperimpl.console.ManagerUtility;
import com.sun.management.viperimpl.console.ToolPayload;
import com.sun.management.viperimpl.console.config.ToolNode;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import com.sun.management.viperimpl.console.editor.SMCEditor;
import com.sun.management.viperimpl.console.gui.AdvancedLoginChooser;
import com.sun.management.viperimpl.console.gui.ComboToolBoxChooser;
import com.sun.management.viperimpl.console.gui.GUIPrivilegeManager;
import com.sun.management.viperimpl.console.gui.LocalToolBoxChooser;
import com.sun.management.viperimpl.console.gui.LoginChooser;
import com.sun.management.viperimpl.console.gui.LoginFailed;
import com.sun.management.viperimpl.console.gui.RoleChooser;
import com.sun.management.viperimpl.console.gui.ToolBoxChooser;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.help.HelpSet;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class GUIConsoleManager
extends BaseConsoleManager {
    protected ToolBoxChooser openChooser = null;
    protected ToolBoxChooser saveChooser = null;
    protected LoginChooser login = null;
    protected AdvancedLoginChooser advLogin = null;
    protected RoleChooser roleLogin = null;
    protected LoginFailed loginFailed = null;
    protected Component parentComp = null;
    protected boolean initParent = false;
    protected Vector cancelSet = null;
    protected SMCEditor toolBoxEditor = null;
    protected VConsoleActionListener chooserListener = null;
    protected static ImageIcon warnIcon = null;
    protected static ImageIcon errIcon = null;
    protected static ImageIcon smallToolIcon = null;
    protected static ImageIcon largeToolIcon = null;
    protected static WindowCommandSetter cmdSetter = null;

    public GUIConsoleManager() {
        toolContext = "TC_APPLICATION_GUI";
        this.chooserListener = new VConsoleActionListener(){

            public void consoleAction(VConsoleEvent e) {
                GUIConsoleManager.this.notifyListeners(e);
            }
        };
        if (warnIcon == null) {
            try {
                warnIcon = ConsoleUtility.loadImageIcon((String)"images/Event_Warn16.gif", this.getClass());
                errIcon = ConsoleUtility.loadImageIcon((String)"images/Event_Err16.gif", this.getClass());
                smallToolIcon = ConsoleUtility.loadImageIcon((String)"images/Tool_NotLoaded16.gif", this.getClass());
                largeToolIcon = ConsoleUtility.loadImageIcon((String)"images/Tool_NotLoaded32.gif", this.getClass());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (loadMessage == null) {
            loadMessage = new MessageFormat(ImplResourceManager.getString("Loading {0} Tool..."));
        }
    }

    protected void initComboTBChooser() {
        ComboToolBoxChooser c = new ComboToolBoxChooser();
        c.addConsoleActionListener(this.chooserListener);
        this.openChooser = c;
        this.openChooser.setProperties(this.properties);
        c.seedRemoteServer(this.initialHostName);
    }

    protected void initLocalTBChooser() {
        LocalToolBoxChooser c = new LocalToolBoxChooser();
        c.addConsoleActionListener(this.chooserListener);
        this.saveChooser = c;
        this.saveChooser.setProperties(this.properties);
    }

    protected void initLoginChooser() {
        this.login = new LoginChooser();
        this.login.addConsoleActionListener(this.chooserListener);
    }

    protected void initLoginFailed() {
        this.loginFailed = new LoginFailed();
        this.loginFailed.addConsoleActionListener(this.chooserListener);
    }

    protected void initAdvancedLoginChooser() {
        this.advLogin = new AdvancedLoginChooser();
        this.advLogin.addConsoleActionListener(this.chooserListener);
    }

    protected void initRoleChooser() {
        this.roleLogin = new RoleChooser();
        this.roleLogin.addConsoleActionListener(this.chooserListener);
    }

    protected void initParent() {
        try {
            String dType = this.properties.getProperty("vconsole.dialogtype");
            if (dType == null || dType.equals("vconsole.frame")) {
                JFrame j = (JFrame)this.properties.getPropertyObject("vconsole.frame");
                this.parentComp = j;
                if (j == null) {
                    j = new JFrame();
                }
            } else if (dType.equals("vconsole.internalframe")) {
                // empty if block
            }
            GUIPrivilegeManager mgr = new GUIPrivilegeManager();
            mgr.init(this.parentComp, this.trusted);
            this.privilegeMgr = mgr;
            super.setPrivilegeManager();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initParent = true;
    }

    protected void showBusyState(boolean busyState) {
        if (!this.initParent) {
            this.initParent();
        }
        if (this.parentComp instanceof VContainer) {
            VContainer c = (VContainer)this.parentComp;
            c.showBusyState(busyState);
        }
    }

    protected void showTemporaryBusyState() {
        if (!this.initParent) {
            this.initParent();
        }
        if (this.parentComp instanceof VContainer) {
            VContainer c = (VContainer)this.parentComp;
            c.showTemporaryBusyState();
        }
    }

    public int saveConsole() {
        try {
            if (this.currentConfig == null) {
                return 1;
            }
            VConfigurationInfo info = this.currentConfig.getInfo();
            URL tbURL = info.getURL();
            File f = new File(tbURL.getFile());
            FileOutputStream fos = new FileOutputStream(f);
            this.currentConfig.write(fos);
            fos.close();
            this.configHasChanged = false;
            return 0;
        }
        catch (Throwable t) {
            Debug.trace((String)"GUI Console Manager", (int)Debug.WARNING, (String)"Unable to save console, trying save as...", (Throwable)t);
            return this.saveConsoleAs();
        }
    }

    public int saveConsoleAs() {
        if (!this.initParent) {
            this.initParent();
        }
        try {
            int response;
            if (this.currentConfig == null) {
                return 1;
            }
            if (this.saveChooser == null) {
                this.initLocalTBChooser();
            }
            if ((response = this.saveChooser.showSaveDialog(this.parentComp)) == -1) {
                return 0;
            }
            URL tbURL = this.saveChooser.getToolBoxURL();
            File f = new File(tbURL.getFile());
            FileOutputStream fos = new FileOutputStream(f);
            this.currentConfig.write(fos);
            fos.close();
            this.configHasChanged = false;
            return 0;
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this.parentComp, ImplResourceManager.getString("Could not save toolbox to the specified location."), ImplResourceManager.getString("Save As Failed"), 0);
            Debug.trace((String)"GUI Console Manager", (int)Debug.ERROR, (String)"Unable to save console as...", (Throwable)t);
            return this.saveConsoleAs();
        }
    }

    public void editConsole() {
        Debug.trace((String)"GUI Console Manager", (int)Debug.INFORMATION, (String)"Editing not launchable from console", null);
    }

    protected String promptUserForTool(String host) {
        return null;
    }

    protected URL promptUserForToolbox() {
        if (!this.initParent) {
            this.initParent();
        }
        if (this.openChooser == null) {
            this.initComboTBChooser();
        } else {
            this.openChooser.refreshDisplay();
        }
        this.properties.setProperty("vconsole.working", "false");
        this.showBusyState(true);
        int response = this.openChooser.showOpenDialog(this.parentComp);
        this.showBusyState(false);
        this.properties.setProperty("vconsole.working", "true");
        if (response == -1) {
            return null;
        }
        return this.openChooser.getToolBoxURL();
    }

    protected ManagedCredentials promptUserForAuthInfo(String host, int port, String domain, boolean retryAttempt) {
        String loginMode;
        if (!this.initParent) {
            this.initParent();
        }
        boolean advancedLogin = (loginMode = this.properties.getProperty("vconsole.loginmode")) != null && loginMode.equals("vconsole.advanced");
        String serverDisplay = host;
        if (port != 898) {
            serverDisplay = serverDisplay + ":" + port;
        }
        int result = 1;
        if (advancedLogin) {
            if (this.advLogin == null) {
                this.initAdvancedLoginChooser();
            }
            result = this.advLogin.showLoginDialog(this.parentComp, serverDisplay, retryAttempt);
        } else {
            if (this.login == null) {
                this.initLoginChooser();
            }
            result = this.login.showLoginDialog(this.parentComp, serverDisplay, retryAttempt);
        }
        if (result == 1) {
            return null;
        }
        ManagedCredentials aInfo = null;
        aInfo = advancedLogin ? new ManagedCredentials(host, port, this.advLogin.getUserName(), this.advLogin.getPassword(), this.advLogin.getRoleName(), this.advLogin.getRolePassword(), this.advLogin.shouldAssumeRole()) : new ManagedCredentials(host, port, this.login.getUserName(), this.login.getPassword(), null, null, true);
        return aInfo;
    }

    protected boolean promptUserToRetryLogin(String host, boolean retriesExceeded) {
        return true;
    }

    protected ManagedCredentials promptUserForRoleInfo(ManagedCredentials authInfo, String domain, VIdentity[] roleList, boolean retryAttempt) {
        if (!this.initParent) {
            this.initParent();
        }
        String serverDisplay = authInfo.getHostName() + ":" + authInfo.getPort();
        int result = 1;
        if (this.roleLogin == null) {
            this.initRoleChooser();
        }
        if ((result = this.roleLogin.showRoleDialog(this.parentComp, serverDisplay, authInfo.getName(), roleList, retryAttempt)) == 2) {
            return null;
        }
        if (result == 1) {
            authInfo.setShouldAssumeRole(false);
            return authInfo;
        }
        authInfo = new ManagedCredentials(authInfo.getHostName(), authInfo.getPort(), authInfo.getName(), authInfo.getCredential(), this.roleLogin.getRoleName(), this.roleLogin.getRolePassword(), true);
        return authInfo;
    }

    protected void unexpectedException(String toolClass, VConfigurationNode child, VScopeNode parent, Throwable throwable) {
        VScopeNode childNode = null;
        String description = null;
        if (parent != null) {
            childNode = new VScopeNode();
            childNode.setSmallIcon(errIcon);
            childNode.setLargeIcon(largeToolIcon);
            childNode.setDescription(ImplResourceManager.getString("UnexpectedException"));
            if (child instanceof ToolNode) {
                childNode.setText(((ToolNode)child).getClassName());
            } else {
                childNode.setText(child.getName());
            }
            description = childNode.getDescription();
            parent.add((MutableTreeNode)childNode);
        }
        if (unknownError == null) {
            unknownError = new MessageFormat(ImplResourceManager.getString("UnknownError"));
        }
        this.notifyLog(new VLogEvent((Object)this, 30, new Date(), ImplResourceManager.getString("Unknown Error"), unknownError.format(new Object[]{toolClass}), description, throwable, childNode));
    }

    protected void noServerFound(String toolClass, String host, ToolNode child, VScopeNode parent, Throwable throwable) {
        VScopeNode childNode = null;
        String description = null;
        if (parent != null) {
            childNode = new VScopeNode();
            childNode.setSmallIcon(errIcon);
            childNode.setLargeIcon(largeToolIcon);
            childNode.setDescription(ImplResourceManager.getString("NoServerFound"));
            childNode.setText(toolClass);
            description = childNode.getDescription();
            parent.add((MutableTreeNode)childNode);
        }
        if (hostNotFound == null) {
            hostNotFound = new MessageFormat(ImplResourceManager.getString("HostNotFound"));
        }
        this.notifyLog(new VLogEvent((Object)this, 30, new Date(), ImplResourceManager.getString("Host Not Found"), hostNotFound.format(new Object[]{host}), description, throwable, childNode));
    }

    protected void noServerRunningOnHost(String host, ToolNode child, VScopeNode parent, Throwable throwable) {
        VScopeNode childNode = null;
        String description = null;
        if (parent != null) {
            childNode = new VScopeNode();
            childNode.setSmallIcon(errIcon);
            childNode.setLargeIcon(largeToolIcon);
            childNode.setDescription(ImplResourceManager.getString("NoServerOnHost"));
            childNode.setText(child.getClassName());
            parent.add((MutableTreeNode)childNode);
            description = childNode.getDescription();
        }
        if (serverNotRunning == null) {
            serverNotRunning = new MessageFormat(ImplResourceManager.getString("ServerNotRunning"));
        }
        this.notifyLog(new VLogEvent((Object)this, 30, new Date(), ImplResourceManager.getString("Server Not Running"), serverNotRunning.format(new Object[]{host}), description, throwable, childNode));
    }

    protected void toolNotFoundOnServer(String toolClass, ToolNode child, VScopeNode parent, Throwable throwable) {
        VScopeNode childNode = null;
        String description = null;
        if (parent != null) {
            childNode = new VScopeNode();
            childNode.setSmallIcon(warnIcon);
            childNode.setLargeIcon(largeToolIcon);
            childNode.setDescription(ImplResourceManager.getString("ToolNotFound"));
            childNode.setText(child.getClassName());
            parent.add((MutableTreeNode)childNode);
            description = childNode.getDescription();
        }
        if (toolNotFound == null) {
            toolNotFound = new MessageFormat(ImplResourceManager.getString("UnknownTool"));
        }
        this.notifyLog(new VLogEvent((Object)this, 30, new Date(), ImplResourceManager.getString("Tool Not Found"), toolNotFound.format(new Object[]{toolClass}), description, throwable, childNode));
    }

    protected void toolDoesNotHaveLocalizedInfo(String toolClass, ToolNode child, ToolInfo childInfo, VScopeNode parent, Throwable throwable) {
        VScopeNode childNode = null;
        String description = null;
        if (parent != null) {
            childNode = new VScopeNode();
            childNode.setSmallIcon(errIcon);
            childNode.setLargeIcon(largeToolIcon);
            childNode.setDescription(ImplResourceManager.getString("NoLocalizedInfo"));
            childNode.setText(child.getClassName());
            parent.add((MutableTreeNode)childNode);
            description = childNode.getDescription();
        }
        if (locInfoNotFound == null) {
            locInfoNotFound = new MessageFormat(ImplResourceManager.getString("NoInfo"));
        }
        this.notifyLog(new VLogEvent((Object)this, 30, new Date(), ImplResourceManager.getString("Missing Information"), locInfoNotFound.format(new Object[]{toolClass}), description, throwable, childNode));
    }

    protected void invalidScopeForTool(ToolNode child, VLocalizedInfo childInfo, VScopeNode parent, String badScope, Throwable throwable) {
        VScopeNode childNode = null;
        String description = null;
        if (parent != null) {
            childNode = ManagerUtility.createScopeNodeFor(childInfo, child, null);
            childNode.setSmallIcon(warnIcon);
            childNode.setLargeIcon(largeToolIcon);
            childNode.setDescription(ImplResourceManager.getString("InvalidScope"));
            parent.add((MutableTreeNode)childNode);
            description = childNode.getDescription();
        }
        if (invalidScope == null) {
            invalidScope = new MessageFormat(ImplResourceManager.getString("BadScope"));
        }
        this.notifyLog(new VLogEvent((Object)this, 20, new Date(), ImplResourceManager.getString("Invalid Domain"), invalidScope.format(new Object[]{badScope}), description, throwable, childNode));
    }

    protected void toolDoesNotSupportScope(String toolClass, ToolNode child, VLocalizedInfo childInfo, VScopeNode parent, AdminMgmtScope scope, Throwable throwable) {
        VScopeNode childNode = null;
        String description = null;
        if (parent != null) {
            childNode = ManagerUtility.createScopeNodeFor(childInfo, child, null);
            childNode.setSmallIcon(warnIcon);
            childNode.setLargeIcon(largeToolIcon);
            childNode.setDescription(ImplResourceManager.getString("UnsupportedScope"));
            parent.add((MutableTreeNode)childNode);
            description = childNode.getDescription();
        }
        if (unsupportedScope == null) {
            unsupportedScope = new MessageFormat(ImplResourceManager.getString("ScopeNotSupported"));
        }
        this.notifyLog(new VLogEvent((Object)this, 20, new Date(), ImplResourceManager.getString("Domain Not Supported"), unsupportedScope.format(new Object[]{scope.toDirectoryTableURL(), toolClass}), description, throwable, childNode));
    }

    protected void toolDoesNotSupportContext(String toolClass, ToolNode child, VLocalizedInfo childInfo, VScopeNode parent, String context, Throwable throwable) {
        VScopeNode childNode = null;
        String description = null;
        if (parent != null) {
            childNode = ManagerUtility.createScopeNodeFor(childInfo, child, null);
            childNode.setSmallIcon(warnIcon);
            childNode.setLargeIcon(largeToolIcon);
            childNode.setDescription(ImplResourceManager.getString("UnsupportedContext"));
            parent.add((MutableTreeNode)childNode);
            description = childNode.getDescription();
        }
        if (unsupportedContext == null) {
            unsupportedContext = new MessageFormat(ImplResourceManager.getString("ContextNotSupported"));
        }
        this.notifyLog(new VLogEvent((Object)this, 20, new Date(), ImplResourceManager.getString("Context Not Supported"), unsupportedContext.format(new Object[]{toolContext, toolClass}), description, throwable, childNode));
    }

    protected void authenticationFailedForTool(String host, VScopeNode stubNode, Throwable throwable) {
        ToolPayload toolPayload = (ToolPayload)stubNode.getPayload();
        ToolNode toolNode = toolPayload.getToolNode();
        stubNode.setSmallIcon(warnIcon);
        stubNode.setDescription(ImplResourceManager.getString("AuthenticationFailed"));
        if (failedAuthentication == null) {
            failedAuthentication = new MessageFormat(ImplResourceManager.getString("FailedAuthentication"));
        }
        this.notifyLog(new VLogEvent((Object)this, 20, new Date(), ImplResourceManager.getString("Authentication Failed"), failedAuthentication.format(new Object[]{host}), stubNode.getDescription(), throwable, stubNode));
        stubNode.setResultPane(null);
        stubNode.setPayload(null);
        this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)stubNode));
    }

    protected void userCanceledAuthenticationForTool(String host, VScopeNode stubNode) {
        if (canceledAuthentication == null) {
            canceledAuthentication = new MessageFormat(ImplResourceManager.getString("AuthCancelled"));
        }
        this.notifyLog(new VLogEvent((Object)this, 20, new Date(), ImplResourceManager.getString("Authentication Cancelled"), canceledAuthentication.format(new Object[]{host}), stubNode.getDescription(), null, stubNode));
        stubNode.setResultPane(null);
        this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)stubNode));
    }

    protected void toolInitializationFailed(String toolClass, VScopeNode stubNode, Throwable throwable) {
        ToolPayload toolPayload = (ToolPayload)stubNode.getPayload();
        ToolNode toolNode = toolPayload.getToolNode();
        stubNode.setSmallIcon(warnIcon);
        stubNode.setDescription(ImplResourceManager.getString("Initialization Failed"));
        if (failedInitialization == null) {
            failedInitialization = new MessageFormat(ImplResourceManager.getString("FailedInitialization"));
        }
        this.notifyLog(new VLogEvent((Object)this, 20, new Date(), ImplResourceManager.getString("Initialization Failed"), failedInitialization.format(new Object[]{stubNode.getText()}), stubNode.getDescription(), throwable, stubNode));
        stubNode.setResultPane(null);
        stubNode.setPayload(null);
        this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)stubNode));
    }

    protected VScopeNode addToolStubToParent(ToolNode child, VScopeNode parent, VLocalizedInfo info) {
        if (child == null || parent == null || info == null) {
            return null;
        }
        String toolName = info.getName();
        if (child.getName() != null) {
            toolName = child.getName();
        }
        VBusyPanel busyPanel = new VBusyPanel(loadMessage.format(new Object[]{toolName}));
        VScopeNode childNode = ManagerUtility.createScopeNodeFor(info, child, (Component)busyPanel);
        if (!child.getTreeDisplay()) {
            childNode.setResultPane(null);
        }
        try {
            ManagerUtility.addChildToParent(child, parent, childNode);
        }
        catch (Throwable t) {
            this.unexpectedException(child.getClassName(), child, parent, t);
            return null;
        }
        return childNode;
    }

    protected void loadToolForStub(VScopeNode stubNode, boolean selectWhenDone) {
        if (stubNode == null) {
            super.loadToolForStub(stubNode, selectWhenDone);
            return;
        }
        if (stubNode.getResultPane() != null) {
            super.loadToolForStub(stubNode, selectWhenDone);
            return;
        }
        VBusyPanel busyPanel = new VBusyPanel(loadMessage.format(new Object[]{stubNode.getText()}));
        stubNode.setResultPane((Component)busyPanel);
        this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)stubNode));
        super.loadToolForStub(stubNode, selectWhenDone);
    }

    protected VScopeNode addToolToParent(ToolNode child, Tool tool, VScopeNode parent, VScopeNode stubNode) {
        if (child == null || tool == null || parent == null) {
            return null;
        }
        VScopeNode childNode = tool.getScopeNode();
        if (childNode != null) {
            try {
                if (child.getName() != null) {
                    childNode.setText(child.getName());
                }
                if (child.getDescription() != null) {
                    childNode.setDescription(child.getDescription());
                }
                if (child.getSmallIcon() != null) {
                    childNode.setSmallIcon(new ImageIcon(child.getSmallIcon()));
                }
                if (child.getLargeIcon() != null) {
                    childNode.setLargeIcon(new ImageIcon(child.getLargeIcon()));
                }
                ManagerUtility.setBackgroundImage(child, childNode);
            }
            catch (Throwable t) {
                // empty catch block
            }
            int childIndex = 0;
            if (stubNode != null) {
                parent = (VScopeNode)stubNode.getParent();
                childIndex = parent.getIndex((TreeNode)stubNode);
                parent.remove((MutableTreeNode)stubNode);
            }
            parent.insert((MutableTreeNode)childNode, childIndex);
        } else {
            childNode = stubNode;
            childNode.setPayload(null);
            if (tool instanceof Component) {
                childNode.setResultPane((Component)tool);
            } else {
                childNode.setResultPane(null);
                childNode.setSmallIcon(warnIcon);
                Debug.trace((String)"ConsoleManager", (int)Debug.WARNING, (String)("The tool: " + childNode.getText() + "did not provide its own model node" + " and none could be created for it."), null);
            }
        }
        return childNode;
    }

    protected void loadOnlineHelpForTool(Tool tool, ToolInfo toolInfo) {
        if (tool == null || toolInfo == null) {
            return;
        }
        try {
            String helpBase = toolInfo.getHelpBaseName();
            if (helpBase != null && !helpBase.equals("null")) {
                Locale l = ResourceManager.currentLocale;
                URL hsURL = HelpSet.findHelpSet((ClassLoader)tool.getClass().getClassLoader(), (String)helpBase, (Locale)l);
                Debug.trace((String)"ConsoleManager", (int)Debug.INFORMATION, (String)("Best HelpSet for Tool: " + tool.getClass().toString() + " for Locale: " + l.toString() + " found to be: " + hsURL.toString()), null);
                HelpSet hs = new HelpSet(tool.getClass().getClassLoader(), hsURL);
                VConsoleEvent vce = new VConsoleEvent((Object)this, "vconsole.addhelpset", (Object)hs);
                this.notifyListeners(vce);
            }
        }
        catch (Throwable t) {
            Debug.trace((String)"ConsoleManager", (int)Debug.WARNING, (String)"Could not load tool's helpset", (Throwable)t);
        }
    }

    protected void establishWindowCommand(String command) {
        if (!this.initParent) {
            this.initParent();
        }
        try {
            if (cmdSetter == null) {
                cmdSetter = new WindowCommandSetter();
            }
            cmdSetter.setCommand(command);
        }
        catch (Throwable t) {
            Debug.trace((String)"ConsoleManager", (int)Debug.WARNING, (String)"Problem setting window command.", (Throwable)t);
        }
    }

    protected void warnUserOfFailedToolbox(String toolbox, Throwable t) {
        if (toolbox == null) {
            return;
        }
        if (tbLoadFailed == null) {
            tbLoadFailed = new MessageFormat(ImplResourceManager.getString("Toolbox: {0} could not be loaded."));
        }
        this.notifyLog(new VLogEvent((Object)this, 30, new Date(), ImplResourceManager.getString("Toolbox Load Failure"), tbLoadFailed.format(new Object[]{toolbox}), ImplResourceManager.getString("ToolboxFailure"), t, null));
        System.err.println("Open Toolbox: " + toolbox + " failed");
    }

    class WindowCommandSetter
    implements PrivilegedAction {
        protected String cmd = null;

        WindowCommandSetter() {
        }

        public Object run() {
            try {
                Class<?> c = Class.forName("com.sun.dt.Xsession");
                Method method = c.getMethod("WMcommand", Object.class, String.class);
                method.invoke(null, GUIConsoleManager.this.parentComp, this.cmd);
                Debug.trace((String)"Console Manager", (int)Debug.INFORMATION, (String)("CDE Command Set: " + this.cmd), null);
            }
            catch (Throwable t) {
                Debug.trace((String)"Console Manager", (int)Debug.WARNING, (String)"Could not set CDE window command", (Throwable)t);
            }
            return this.cmd;
        }

        public void setCommand(String cmd) {
            this.cmd = cmd;
        }
    }
}

