/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.editor.lf.toolboxurlwizard;

import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.wizard.VWizard;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.config.ConfigManagement;
import com.sun.management.viperimpl.console.config.ToolBoxURLNode;
import com.sun.management.viperimpl.console.config.VBaseConfiguration;
import com.sun.management.viperimpl.console.editor.lf.toolboxurlwizard.ToolBoxURLFileSelection;
import com.sun.management.viperimpl.console.editor.lf.toolboxurlwizard.ToolBoxURLIcon;
import com.sun.management.viperimpl.console.editor.lf.toolboxurlwizard.ToolBoxURLLocation;
import com.sun.management.viperimpl.console.editor.lf.toolboxurlwizard.ToolBoxURLNameDescription;
import com.sun.management.viperimpl.console.editor.lf.toolboxurlwizard.ToolBoxURLScope;
import com.sun.management.viperimpl.console.editor.lf.toolboxurlwizard.ToolBoxURLSelection;
import com.sun.management.viperimpl.console.editor.lf.toolboxurlwizard.ToolBoxURLServer;
import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class ToolBoxURLWizard
extends VWizard {
    private Frame f = null;
    private ToolBoxURLNode tnode = null;
    private Component[] c = null;
    private JComponent buttonPane = null;

    public ToolBoxURLWizard(String title, Frame f1, boolean b, ToolBoxURLNode tNode) {
        super(title);
        this.f = f1;
        this.tnode = tNode;
        super.toggleContentTitle(false);
        if (b) {
            this.getDeckProperties().setProperty("TOOLBOXURLADD", (Object)"vwp.true");
        } else {
            URL u;
            this.getDeckProperties().setProperty("TOOLBOXURLADD", (Object)"vwp.false");
            String t = tNode.getName();
            if (t != null && t.trim().length() > 0) {
                this.getDeckProperties().setProperty("OLDTOOLBOXURLNAME", (Object)t);
            }
            if ((t = tNode.getDescription()) != null && t.trim().length() > 0) {
                this.getDeckProperties().setProperty("OLDTOOLBOXURLDESCRIPTION", (Object)t);
            }
            if ((u = tNode.getLargeIcon()) != null) {
                this.getDeckProperties().setProperty("OLDTOOLBOXURLBIGICON", (Object)u.toString());
            }
            if ((u = tNode.getSmallIcon()) != null) {
                this.getDeckProperties().setProperty("OLDTOOLBOXURLSMALLICON", (Object)u.toString());
            }
            if ((t = tNode.getScope()) != null && t.trim().length() > 0) {
                this.getDeckProperties().setProperty("OLDTOOLBOXURLSCOPE", (Object)t);
                if (tNode.getScopeText() != null) {
                    this.getDeckProperties().setProperty("OLDTOOLBOXURLSCOPETEXT", (Object)tNode.getScopeText());
                }
            }
            t = tNode.getURLText();
            this.getDeckProperties().setProperty("OLDTOOLBOXURLTOOLBOX", (Object)t);
        }
    }

    public void init() {
        this.buttonPane = this.getButtonPane();
        this.addCard("toolboxurl-location", new ToolBoxURLLocation());
        this.addCard("toolboxurl-server", new ToolBoxURLServer());
        this.addCard("toolboxurl-selection", new ToolBoxURLSelection());
        this.addCard("toolboxurl-namedescription", new ToolBoxURLNameDescription());
        this.addCard("toolboxurl-icon", new ToolBoxURLIcon(this.f));
        this.addCard("toolboxurl-scope", new ToolBoxURLScope(this.buttonPane));
        this.addCard("toolboxurl-fileselection", new ToolBoxURLFileSelection(this.f));
        this.setFirst("toolboxurl-location");
        this.manager.setNext("toolboxurl-server", "toolboxurl-selection");
        this.manager.setNext("toolboxurl-selection", "toolboxurl-namedescription");
        this.manager.setNext("toolboxurl-fileselection", "toolboxurl-namedescription");
        this.manager.setNext("toolboxurl-namedescription", "toolboxurl-icon");
        this.manager.setNext("toolboxurl-icon", "toolboxurl-scope");
        super.init();
        this.setMnemonic();
    }

    protected void setMnemonic() {
        int count = this.buttonPane.getComponentCount();
        this.c = new Component[count];
        this.c = this.buttonPane.getComponents();
        String tmp1 = null;
        JButton jb = null;
        for (int i = 0; i < count; ++i) {
            if (!(this.c[i] instanceof JButton)) continue;
            String nextString = ResourceManager.getString((String)"Next");
            String backString = ResourceManager.getString((String)"Back");
            String cancelString = ResourceManager.getString((String)"Cancel");
            String finishString = ResourceManager.getString((String)"Finish");
            jb = (JButton)this.c[i];
            tmp1 = jb.getText();
            if (tmp1.equals(nextString)) {
                jb.setMnemonic(ResourceManager.getString((String)"Next").charAt(0));
                continue;
            }
            if (tmp1.equals(backString)) {
                jb.setMnemonic(ResourceManager.getString((String)"Back").charAt(0));
                continue;
            }
            if (tmp1.equals(cancelString)) {
                jb.setMnemonic(ResourceManager.getString((String)"Cancel").charAt(0));
                continue;
            }
            if (!tmp1.equals(finishString)) continue;
            jb.setMnemonic(ResourceManager.getString((String)"Finish").charAt(0));
        }
    }

    public boolean setToolBoxURLProperties(VScopeNode o) {
        String tbxURL = (String)this.getDeckProperties().getProperty("TOOLBOXURLTOOLBOX");
        if (tbxURL == null) {
            return false;
        }
        if (tbxURL.trim().length() == 0) {
            String fileName = (String)this.getDeckProperties().getProperty("TOOLBOXURLFILESELECTED");
            o.setText("Toolbox URL (" + fileName + ")");
            this.tnode.setURL(fileName);
        } else {
            try {
                o.setText("Toolbox URL (" + tbxURL + ")");
                URL au = ConfigManagement.unaliasifyURL(new URL(tbxURL));
                this.tnode.setURL(au.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String tbxURLName = (String)this.getDeckProperties().getProperty("TOOLBOXURLNAME");
        if (tbxURLName != null && tbxURLName.trim().length() > 0) {
            this.tnode.setName(tbxURLName);
        } else {
            this.tnode.setName(null);
        }
        String tbxURLDesc = (String)this.getDeckProperties().getProperty("TOOLBOXURLDESCRIPTION");
        if (tbxURLDesc != null && tbxURLDesc.trim().length() > 0) {
            this.tnode.setDescription(tbxURLDesc);
        } else {
            this.tnode.setDescription(null);
        }
        String tbxURLBigIcon = (String)this.getDeckProperties().getProperty("TOOLBOXURLBIGICON");
        if (tbxURLBigIcon != null && tbxURLBigIcon.trim().length() > 0) {
            this.tnode.setLargeIcon(tbxURLBigIcon);
        } else {
            this.tnode.setLargeIcon((String)null);
        }
        String tbxURLSmallIcon = (String)this.getDeckProperties().getProperty("TOOLBOXURLSMALLICON");
        if (tbxURLSmallIcon != null && tbxURLSmallIcon.trim().length() > 0) {
            this.tnode.setSmallIcon(tbxURLSmallIcon);
        } else {
            this.tnode.setSmallIcon((String)null);
        }
        String tbxURLScope = (String)this.getDeckProperties().getProperty("TOOLBOXURLSCOPE");
        if (tbxURLScope != null && tbxURLScope.trim().length() > 0) {
            this.tnode.setScope(tbxURLScope);
        } else {
            this.tnode.setScope(null);
        }
        return true;
    }

    public ToolBoxURLNode createToolBoxURLNode(VBaseConfiguration vb) {
        String tbxURL = (String)this.getDeckProperties().getProperty("TOOLBOXURLTOOLBOX");
        if (tbxURL == null) {
            return null;
        }
        if (tbxURL.trim().length() == 0) {
            tbxURL = (String)this.getDeckProperties().getProperty("TOOLBOXURLFILESELECTED");
            return vb.createToolBoxURLNode(tbxURL);
        }
        try {
            URL au = ConfigManagement.unaliasifyURL(new URL(tbxURL));
            return vb.createToolBoxURLNode(au.toString());
        }
        catch (Exception e) {
            return vb.createToolBoxURLNode(tbxURL);
        }
    }

    public void setMiscToolBoxURLProperties(ToolBoxURLNode t) {
        String scope;
        String smallIcon;
        String lgIcon;
        String desc;
        String name = (String)this.getDeckProperties().getProperty("TOOLBOXURLNAME");
        if (name != null && name.trim().length() > 0) {
            t.setName(name);
        }
        if ((desc = (String)this.getDeckProperties().getProperty("TOOLBOXURLDESCRIPTION")) != null && desc.trim().length() > 0) {
            t.setDescription(desc);
        }
        if ((lgIcon = (String)this.getDeckProperties().getProperty("TOOLBOXURLBIGICON")) != null && lgIcon.trim().length() > 0) {
            t.setLargeIcon(lgIcon);
        }
        if ((smallIcon = (String)this.getDeckProperties().getProperty("TOOLBOXURLSMALLICON")) != null && smallIcon.trim().length() > 0) {
            t.setSmallIcon(smallIcon);
        }
        if ((scope = (String)this.getDeckProperties().getProperty("TOOLBOXURLSCOPE")) != null && scope.trim().length() > 0) {
            t.setScope(scope);
        }
    }

    public static void main(String[] args) {
        ToolBoxURLWizard stw = new ToolBoxURLWizard("Add Toolbox", null, true, null);
        stw.init();
        JFrame j = new JFrame();
        stw.setContainer(j);
        j.setSize(600, 350);
        stw.setVisible(true);
        stw.start();
    }
}

