/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.editor.lf;

import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.gui.lf.VToolBar;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;

public class EditorToolBar
extends VToolBar {
    protected AbstractButton newNodeButton = null;
    protected static ImageIcon newNodeIcon = null;
    protected static ImageIcon newNodeIconD = null;
    protected AbstractButton moveUpButton = null;
    protected static ImageIcon moveUpIcon = null;
    protected static ImageIcon moveUpIconD = null;
    protected AbstractButton moveDnButton = null;
    protected static ImageIcon moveDnIcon = null;
    protected static ImageIcon moveDnIconD = null;
    protected JPopupMenu newNodeMenu = null;
    protected JMenuItem legacyItem = null;
    protected JMenuItem toolItem = null;
    protected JMenuItem tbLinkItem = null;
    protected JMenuItem folderItem = null;
    protected ActionListener newNodeListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == null) {
                return;
            }
            JMenuItem m = (JMenuItem)o;
            VConsoleEvent vce = new VConsoleEvent((Object)EditorToolBar.this, m.getActionCommand(), null);
            EditorToolBar.super.notifyListeners(vce);
        }
    };

    public void propertyChange(PropertyChangeEvent pce) {
        if (pce == null) {
            return;
        }
        String key = pce.getPropertyName();
        Object o = pce.getNewValue();
        String value = null;
        if (o instanceof String) {
            value = (String)o;
        }
        if (key.equals("editor.addlegacyapp")) {
            this.setItemEnabled(this.legacyItem, value);
        } else if (key.equals("editor.addtool")) {
            this.setItemEnabled(this.toolItem, value);
        } else if (key.equals("editor.addtoolbox")) {
            this.setItemEnabled(this.tbLinkItem, value);
        } else if (key.equals("editor.addfolder")) {
            this.setItemEnabled(this.folderItem, value);
            if (value.equals("true")) {
                this.newNodeButton.setEnabled(true);
            } else {
                this.newNodeButton.setEnabled(false);
            }
        } else if (key.equals("editor.moveup")) {
            this.setButtonEnabled(this.moveUpButton, value);
        } else if (key.equals("editor.movedown")) {
            this.setButtonEnabled(this.moveDnButton, value);
        }
        super.propertyChange(pce);
    }

    protected void setItemEnabled(JMenuItem item, String value) {
        if (item == null || value == null) {
            return;
        }
        item.setEnabled(value.equals("true"));
    }

    protected void createDefaultToolBar() {
        this.setBorder(new EmptyBorder(2, 2, 2, 3));
        this.setFloatable(false);
        this.addButton("vconsole.newconsole");
        this.add(Box.createHorizontalStrut(1));
        this.addButton("vconsole.openconsole");
        this.add(Box.createHorizontalStrut(1));
        this.addButton("vconsole.saveconsole");
        this.add(Box.createHorizontalStrut(1));
        this.addButton("vconsole.saveconsoleas");
        this.addSeparator();
        this.addButton("NEW_NODE");
        this.add(Box.createHorizontalStrut(1));
        this.addButton("editor.moveup");
        this.add(Box.createHorizontalStrut(1));
        this.addButton("editor.movedown");
        this.addSeparator();
        this.addButton("vconsole.cut");
        this.addButton("vconsole.copy");
        this.addButton("vconsole.paste");
        this.addSeparator();
        this.addButton("vconsole.delete");
        this.addButton("vconsole.displayproperties");
        this.add(Box.createHorizontalStrut(1));
        this.addButton("vconsole.upscopelevel");
        this.installStaticStrings();
        this.installIcons();
        this.installMenuStrings();
    }

    protected void installIcons() {
        super.installIcons();
        this.installIcon(this.newNodeButton, newNodeIcon);
        this.installDisabledIcon(this.newNodeButton, newNodeIconD);
        this.installIcon(this.moveUpButton, moveUpIcon);
        this.installDisabledIcon(this.moveUpButton, moveUpIconD);
        this.installIcon(this.moveDnButton, moveDnIcon);
        this.installDisabledIcon(this.moveDnButton, moveDnIconD);
    }

    protected void uninstallIcons() {
        super.uninstallIcons();
        this.installIcon(this.newNodeButton, null);
        this.installDisabledIcon(this.newNodeButton, null);
        this.installIcon(this.moveUpButton, null);
        this.installDisabledIcon(this.moveUpButton, null);
        this.installIcon(this.moveDnButton, null);
        this.installDisabledIcon(this.moveDnButton, null);
    }

    protected void installStaticStrings() {
        super.installStaticStrings();
        this.installToolTip(this.newNodeButton, ImplResourceManager.getString("Toolbar_New Node_tooltip"));
        this.installAccessName(this.newNodeButton, ImplResourceManager.getString("Toolbar_New Node_access_name"));
        this.installAccessDesc(this.newNodeButton, ImplResourceManager.getString("Toolbar_New Node_access_desc"));
        this.installToolTip(this.moveUpButton, ImplResourceManager.getString("Toolbar_Move Up_tooltip"));
        this.installAccessName(this.moveUpButton, ImplResourceManager.getString("Toolbar_Move Up_access_name"));
        this.installAccessDesc(this.moveUpButton, ImplResourceManager.getString("Toolbar_Move Up_access_desc"));
        this.installToolTip(this.moveDnButton, ImplResourceManager.getString("Toolbar_Move Down_tooltip"));
        this.installAccessName(this.moveDnButton, ImplResourceManager.getString("Toolbar_Move Down_access_name"));
        this.installAccessDesc(this.moveDnButton, ImplResourceManager.getString("Toolbar_Move Down_access_desc"));
    }

    protected void installMenuStrings() {
        super.installMenuStrings();
        if (this.legacyItem != null) {
            this.legacyItem.setText(ImplResourceManager.getString("Add Legacy Application"));
        }
        if (this.toolItem != null) {
            this.toolItem.setText(ImplResourceManager.getString("Add Tool"));
        }
        if (this.tbLinkItem != null) {
            this.tbLinkItem.setText(ImplResourceManager.getString("Add Toolbox"));
        }
        if (this.folderItem != null) {
            this.folderItem.setText(ImplResourceManager.getString("Add Folder"));
        }
    }

    protected void installStrings() {
        super.installStrings();
        this.installString(this.newNodeButton, ImplResourceManager.getString("Toolbar_New Node"));
        this.installString(this.moveUpButton, ImplResourceManager.getString("Move Up"));
        this.installString(this.moveDnButton, ImplResourceManager.getString("Move Down"));
    }

    protected void uninstallStrings() {
        super.uninstallStrings();
        this.installString(this.newNodeButton, null);
        this.installString(this.moveUpButton, null);
        this.installString(this.moveDnButton, null);
    }

    protected AbstractButton addButton(String buttonID) {
        JButton returnButton = null;
        if (buttonID.equals("NEW_NODE")) {
            if (newNodeIcon == null) {
                newNodeIcon = ConsoleUtility.loadImageIcon((String)"images/jlf_New24.gif", ((Object)((Object)this)).getClass());
            }
            returnButton = (JButton)super.add((Component)new JButton(newNodeIcon));
            this.newNodeMenu = new JPopupMenu();
            this.legacyItem = new JMenuItem();
            this.legacyItem.setFont(ResourceManager.menuFont);
            this.legacyItem.setForeground(ResourceManager.menuColor);
            this.legacyItem.setActionCommand("editor.addlegacyapp");
            this.legacyItem.addActionListener(this.newNodeListener);
            this.legacyItem.setEnabled(false);
            this.toolItem = new JMenuItem();
            this.toolItem.setFont(ResourceManager.menuFont);
            this.toolItem.setForeground(ResourceManager.menuColor);
            this.toolItem.setActionCommand("editor.addtool");
            this.toolItem.addActionListener(this.newNodeListener);
            this.toolItem.setEnabled(false);
            this.tbLinkItem = new JMenuItem();
            this.tbLinkItem.setFont(ResourceManager.menuFont);
            this.tbLinkItem.setForeground(ResourceManager.menuColor);
            this.tbLinkItem.setActionCommand("editor.addtoolbox");
            this.tbLinkItem.addActionListener(this.newNodeListener);
            this.tbLinkItem.setEnabled(false);
            this.folderItem = new JMenuItem();
            this.folderItem.setFont(ResourceManager.menuFont);
            this.folderItem.setForeground(ResourceManager.menuColor);
            this.folderItem.setActionCommand("editor.addfolder");
            this.folderItem.addActionListener(this.newNodeListener);
            this.folderItem.setEnabled(false);
            this.newNodeMenu.add(this.legacyItem);
            this.newNodeMenu.add(this.toolItem);
            this.newNodeMenu.add(this.tbLinkItem);
            this.newNodeMenu.add(this.folderItem);
            returnButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Point p = EditorToolBar.this.newNodeButton.getLocation();
                    Dimension size = EditorToolBar.this.newNodeButton.getSize();
                    if (EditorToolBar.this.newNodeButton.isEnabled()) {
                        EditorToolBar.this.newNodeMenu.show(EditorToolBar.this.newNodeButton, e.getX(), p.y + size.height);
                    }
                }
            });
            if (newNodeIconD == null) {
                newNodeIconD = ConsoleUtility.getDisabledIcon((ImageIcon)newNodeIcon);
            }
            returnButton.setDisabledIcon(newNodeIconD);
            this.newNodeButton = returnButton;
            this.newNodeButton.setEnabled(false);
        } else if (buttonID.equals("editor.moveup")) {
            if (moveUpIcon == null) {
                moveUpIcon = ConsoleUtility.loadImageIcon((String)"images/jlf_Up24.gif", ((Object)((Object)this)).getClass());
            }
            returnButton = (JButton)super.add((Component)new JButton(moveUpIcon));
            returnButton.addActionListener(this.buttonListener);
            if (moveUpIconD == null) {
                moveUpIconD = ConsoleUtility.getDisabledIcon((ImageIcon)moveUpIcon);
            }
            returnButton.setDisabledIcon(moveUpIconD);
            returnButton.setActionCommand("editor.moveup");
            this.moveUpButton = returnButton;
            this.moveUpButton.setEnabled(false);
        } else if (buttonID.equals("editor.movedown")) {
            if (moveDnIcon == null) {
                moveDnIcon = ConsoleUtility.loadImageIcon((String)"images/jlf_Down24.gif", ((Object)((Object)this)).getClass());
            }
            returnButton = (JButton)super.add((Component)new JButton(moveDnIcon));
            returnButton.addActionListener(this.buttonListener);
            if (moveDnIconD == null) {
                moveDnIconD = ConsoleUtility.getDisabledIcon((ImageIcon)moveDnIcon);
            }
            returnButton.setDisabledIcon(moveDnIconD);
            returnButton.setActionCommand("editor.movedown");
            this.moveDnButton = returnButton;
            this.moveDnButton.setEnabled(false);
        } else {
            return super.addButton(buttonID);
        }
        return returnButton;
    }

    protected void syncButtons() {
        this.removeAll();
        try {
            this.add(this.oconsoleButton);
            this.add(Box.createHorizontalStrut(1));
            this.add(this.sconsoleButton);
            this.add(Box.createHorizontalStrut(1));
            this.add(this.saconsoleButton);
            this.addSeparator();
            this.add(this.moveUpButton);
            this.add(Box.createHorizontalStrut(1));
            this.add(this.moveDnButton);
            this.addSeparator();
            if (this.cut) {
                this.add(this.cutButton);
            }
            if (this.cut && this.copy) {
                this.add(Box.createHorizontalStrut(1));
            }
            if (this.copy) {
                this.add(this.copyButton);
            }
            if (this.copy && this.paste) {
                this.add(Box.createHorizontalStrut(1));
            }
            if (this.paste) {
                this.add(this.pasteButton);
            }
            if (this.cut || this.copy || this.paste) {
                this.addSeparator();
            }
            if (this.delete) {
                this.add(this.deleteButton);
            }
            if (this.delete) {
                this.addSeparator();
            }
            this.add(this.newNodeButton);
            this.addSeparator();
            if (this.props) {
                this.add(this.propsButton);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

